/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.journal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provider;
import io.kazuki.v0.internal.availability.AvailabilityManager;
import io.kazuki.v0.internal.helper.LogTranslation;
import io.kazuki.v0.internal.helper.SqlTypeHelper;
import io.kazuki.v0.internal.v2schema.Schema;
import io.kazuki.v0.store.KazukiException;
import io.kazuki.v0.store.Key;
import io.kazuki.v0.store.journal.JournalStore;
import io.kazuki.v0.store.journal.PartitionInfo;
import io.kazuki.v0.store.journal.PartitionInfoImpl;
import io.kazuki.v0.store.journal.PartitionInfoSnapshot;
import io.kazuki.v0.store.keyvalue.KeyValueIterable;
import io.kazuki.v0.store.keyvalue.KeyValueIterator;
import io.kazuki.v0.store.keyvalue.KeyValuePair;
import io.kazuki.v0.store.keyvalue.KeyValueStore;
import io.kazuki.v0.store.keyvalue.KeyValueStoreConfiguration;
import io.kazuki.v0.store.keyvalue.KeyValueStoreJdbiH2Impl;
import io.kazuki.v0.store.lifecycle.Lifecycle;
import io.kazuki.v0.store.lifecycle.LifecycleRegistration;
import io.kazuki.v0.store.lifecycle.LifecycleSupportBase;
import io.kazuki.v0.store.schema.SchemaStore;
import io.kazuki.v0.store.schema.TypeValidation;
import io.kazuki.v0.store.sequence.KeyImpl;
import io.kazuki.v0.store.sequence.ResolvedKey;
import io.kazuki.v0.store.sequence.SequenceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;

public class PartitionedJournalStore
implements JournalStore,
LifecycleRegistration {
    private final Logger log = LogTranslation.getLogger(this.getClass());
    private final AvailabilityManager availability;
    private final IDBI database;
    private final SqlTypeHelper typeHelper;
    private final SequenceService sequence;
    private final SchemaStore schema;
    private KeyValueStore metaStore;
    private final Lock nukeLock = new ReentrantLock();
    private final String dbType;
    private final String groupName;
    private final String storeName;
    private final boolean strictTypeCreation;
    private final Long partitionSize;
    private final String dataType;
    private final String typeName;
    private final AtomicReference<KeyValueStore> activePartitionStore;
    private final AtomicReference<PartitionInfoImpl> activePartitionInfo;

    public PartitionedJournalStore(AvailabilityManager availabilityManager, IDBI iDBI, SqlTypeHelper sqlTypeHelper, SchemaStore schemaStore, SequenceService sequenceService, String string, String string2, String string3, Long l, String string4, boolean bl) {
        Preconditions.checkNotNull((Object)string4, (Object)"dataType");
        this.availability = availabilityManager;
        this.database = iDBI;
        this.typeHelper = sqlTypeHelper;
        this.schema = schemaStore;
        this.sequence = sequenceService;
        this.dbType = string;
        this.dataType = string4;
        this.groupName = string2;
        this.storeName = string3;
        this.strictTypeCreation = bl;
        this.partitionSize = l;
        this.typeName = "PartitionInfo-" + string2 + "-" + string3;
        this.activePartitionInfo = new AtomicReference();
        this.activePartitionStore = new AtomicReference();
    }

    @Inject
    public PartitionedJournalStore(AvailabilityManager availabilityManager, IDBI iDBI, SqlTypeHelper sqlTypeHelper, SchemaStore schemaStore, SequenceService sequenceService, KeyValueStoreConfiguration keyValueStoreConfiguration) {
        this(availabilityManager, iDBI, sqlTypeHelper, schemaStore, sequenceService, keyValueStoreConfiguration.getDbType(), keyValueStoreConfiguration.getGroupName(), keyValueStoreConfiguration.getStoreName(), keyValueStoreConfiguration.getPartitionSize(), keyValueStoreConfiguration.getDataType(), keyValueStoreConfiguration.isStrictTypeCreation());
    }

    @Override
    @Inject
    public void register(Lifecycle lifecycle) {
        lifecycle.register(new LifecycleSupportBase(){

            @Override
            public void init() {
                PartitionedJournalStore.this.initialize();
            }
        });
    }

    @Override
    public synchronized void initialize() {
        this.log.debug("Intitializing PartitionedJournalStore {}", (Object)this);
        this.metaStore = this.getKeyValueStore("META", true);
        try {
            if (this.schema.retrieveSchema(this.typeName) == null) {
                this.schema.createSchema(this.typeName, new Schema(Collections.emptyList()));
            }
            try (KeyValueIterable<PartitionInfoSnapshot> keyValueIterable = this.getAllPartitions();){
                for (PartitionInfoSnapshot partitionInfoSnapshot : keyValueIterable) {
                    if (partitionInfoSnapshot.isClosed()) continue;
                    this.log.debug("Found active partition: {}", (Object)partitionInfoSnapshot.getPartitionId());
                    this.activePartitionInfo.set(new PartitionInfoImpl(partitionInfoSnapshot.getPartitionId(), partitionInfoSnapshot.getMinId(), partitionInfoSnapshot.getMaxId(), partitionInfoSnapshot.getSize(), partitionInfoSnapshot.isClosed()));
                    this.activePartitionStore.set(this.getKeyValueStore(PartitionedJournalStore.getPartitionName(this.sequence.resolveKey(KeyImpl.valueOf(partitionInfoSnapshot.getPartitionId()))), false));
                    break;
                }
            }
        }
        catch (KazukiException kazukiException) {
            throw Throwables.propagate((Throwable)kazukiException);
        }
        this.availability.setAvailable(true);
        this.log.debug("Intitialized PartitionedJournalStore {}", (Object)this);
    }

    @Override
    public synchronized <T> Key append(String string, Class<T> clazz, T t, TypeValidation typeValidation) throws KazukiException {
        this.availability.assertAvailable();
        if (!this.dataType.equals(string)) {
            throw new IllegalArgumentException("invalid type: expected " + this.dataType + ", was " + string);
        }
        Key key = this.sequence.nextKey(string);
        ResolvedKey resolvedKey = this.sequence.resolveKey(key);
        if (key == null) {
            throw new IllegalStateException("unable to allocate new key of type: " + string);
        }
        PartitionInfoImpl partitionInfoImpl = this.activePartitionInfo.get();
        KeyValueStore keyValueStore = this.activePartitionStore.get();
        if (partitionInfoImpl == null) {
            KeyImpl keyImpl = (KeyImpl)this.sequence.nextKey(this.typeName);
            if (keyImpl == null) {
                throw new IllegalStateException("unable to allocate new partition key of type: " + this.typeName);
            }
            ResolvedKey resolvedKey2 = this.sequence.resolveKey(keyImpl);
            String string2 = PartitionedJournalStore.getPartitionName(resolvedKey2);
            partitionInfoImpl = new PartitionInfoImpl(keyImpl.getInternalIdentifier(), resolvedKey.getIdentifierLo(), resolvedKey.getIdentifierLo(), 0L, false);
            this.activePartitionInfo.set(partitionInfoImpl);
            this.metaStore.create(this.typeName, PartitionInfo.class, partitionInfoImpl.snapshot(), resolvedKey2, TypeValidation.STRICT);
            keyValueStore = this.getKeyValueStore(string2, true);
            this.activePartitionStore.set(keyValueStore);
        }
        keyValueStore.create(string, clazz, t, resolvedKey, typeValidation);
        partitionInfoImpl.setMaxId(resolvedKey.getIdentifierLo());
        partitionInfoImpl.setSize(partitionInfoImpl.getSize() + 1L);
        boolean bl = this.metaStore.update(KeyImpl.valueOf(partitionInfoImpl.getPartitionId()), PartitionInfo.class, partitionInfoImpl.snapshot());
        if (!bl) {
            throw new KazukiException("unable to update partition info");
        }
        if (partitionInfoImpl.getSize() >= this.partitionSize) {
            this.closeActivePartition();
        }
        return key;
    }

    @Override
    public <T> KeyValueIterable<KeyValuePair<T>> entriesAbsolute(String string, Class<T> clazz, Long l, Long l2) throws KazukiException {
        this.availability.assertAvailable();
        if (!this.dataType.equals(string)) {
            throw new IllegalArgumentException("invalid type: expected " + this.dataType + ", was " + string);
        }
        long l3 = 0L;
        if (l != null) {
            l3 = l;
        }
        ++l3;
        ArrayList<KeyValueIterable<T>> arrayList = new ArrayList<KeyValueIterable<T>>();
        try (KeyValueIterator<PartitionInfoSnapshot> keyValueIterator = this.getAllPartitions().iterator();){
            while (keyValueIterator.hasNext() && (l2 == null || l2 > 0L)) {
                Long l4;
                PartitionInfo partitionInfo = keyValueIterator.next();
                if (l3 < partitionInfo.getMinId() || l3 > partitionInfo.getMaxId()) continue;
                Long l5 = l4 = l2 == null ? null : l2;
                if (l4 != null) {
                    long l6 = 1L + partitionInfo.getMaxId() - l3;
                    l4 = Math.min(l6, l4);
                    l2 = l2 - l4;
                }
                arrayList.add(new LazyIterable<KeyValuePair<T>>(this.getIterableProvider(string, clazz, PartitionedJournalStore.getPartitionName(this.sequence.resolveKey(KeyImpl.valueOf(partitionInfo.getPartitionId()))), l3 - partitionInfo.getMinId(), l4)));
                l3 = partitionInfo.getMaxId() + 1L;
            }
        }
        if (arrayList.isEmpty()) {
            return PartitionedJournalStore.emptyKeyValueIterable();
        }
        return PartitionedJournalStore.concatKeyValueIterables(arrayList);
    }

    @Override
    public <T> KeyValueIterable<KeyValuePair<T>> entriesRelative(String string, Class<T> clazz, Long l, Long l2) throws KazukiException {
        this.availability.assertAvailable();
        if (!this.dataType.equals(string)) {
            throw new IllegalArgumentException("invalid type: expected " + this.dataType + ", was " + string);
        }
        long l3 = 0L;
        if (l != null) {
            l3 = l;
        }
        ArrayList<KeyValueIterable<T>> arrayList = new ArrayList<KeyValueIterable<T>>();
        try (KeyValueIterator<PartitionInfoSnapshot> keyValueIterator = this.getAllPartitions().iterator();){
            while (keyValueIterator.hasNext() && (l2 == null || l2 > 0L)) {
                Long l4;
                PartitionInfo partitionInfo = keyValueIterator.next();
                long l5 = 1L + partitionInfo.getMaxId() - partitionInfo.getMinId();
                long l6 = Math.min(l3, l5);
                if (l6 == l5) {
                    l3 -= l5;
                    continue;
                }
                Long l7 = l4 = l2 == null ? null : l2;
                if (l4 != null) {
                    long l8 = l5 - l6;
                    l4 = Math.min(l8, l4);
                    l2 = l2 - l4;
                }
                arrayList.add(new LazyIterable<KeyValuePair<T>>(this.getIterableProvider(string, clazz, PartitionedJournalStore.getPartitionName(this.sequence.resolveKey(KeyImpl.valueOf(partitionInfo.getPartitionId()))), l3, l4)));
                l3 = 0L;
            }
        }
        if (arrayList.isEmpty()) {
            return PartitionedJournalStore.emptyKeyValueIterable();
        }
        return PartitionedJournalStore.concatKeyValueIterables(arrayList);
    }

    @Override
    public Long approximateSize() throws KazukiException {
        this.availability.assertAvailable();
        long l = 0L;
        try (KeyValueIterable<PartitionInfoSnapshot> keyValueIterable = this.getAllPartitions();){
            for (PartitionInfo partitionInfo : keyValueIterable) {
                l += partitionInfo.getSize();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() throws KazukiException {
        this.log.debug("Clearing PartitionedJournalStore {}", (Object)this);
        this.availability.assertAvailable();
        this.nukeLock.lock();
        try {
            this.closeActivePartition();
            try (KeyValueIterable<PartitionInfoSnapshot> keyValueIterable = this.getAllPartitions();){
                for (PartitionInfo partitionInfo : keyValueIterable) {
                    if (this.dropPartition(partitionInfo.getPartitionId())) continue;
                    throw new KazukiException("unable to delete partition");
                }
            }
            this.sequence.resetCounter(this.dataType);
            this.sequence.resetCounter(this.typeName);
            this.metaStore.destroy();
            this.activePartitionInfo.set(null);
            this.activePartitionStore.set(null);
            this.initialize();
        }
        finally {
            this.nukeLock.unlock();
        }
        this.log.debug("Cleared PartitionedJournalStore {}", (Object)this);
    }

    @Override
    public synchronized boolean closeActivePartition() throws KazukiException {
        this.log.debug("Closing Active Partition for PartitionedJournalStore {}", (Object)this);
        this.availability.assertAvailable();
        PartitionInfoImpl partitionInfoImpl = this.activePartitionInfo.get();
        if (partitionInfoImpl == null || partitionInfoImpl.isClosed()) {
            return false;
        }
        this.activePartitionInfo.set(null);
        this.activePartitionStore.set(null);
        partitionInfoImpl.setClosed(true);
        boolean bl = this.metaStore.update(KeyImpl.valueOf(partitionInfoImpl.getPartitionId()), PartitionInfo.class, partitionInfoImpl);
        if (bl) {
            this.log.debug("Closed Active Partition for PartitionedJournalStore {}", (Object)this);
        }
        return bl;
    }

    @Override
    public synchronized boolean dropPartition(String string) throws KazukiException {
        this.log.debug("Dropping Partition {} of PartitionedJournalStore {}", (Object)string, (Object)this);
        this.availability.assertAvailable();
        Key key = KeyImpl.valueOf(string);
        PartitionInfo partitionInfo = this.metaStore.retrieve(key, PartitionInfoSnapshot.class);
        if (partitionInfo == null) {
            return false;
        }
        if (!partitionInfo.isClosed()) {
            throw new IllegalStateException("drop() applies to closed partitions only");
        }
        ResolvedKey resolvedKey = this.sequence.resolveKey(key);
        KeyValueStore keyValueStore = this.getKeyValueStore(PartitionedJournalStore.getPartitionName(resolvedKey), false);
        keyValueStore.destroy();
        boolean bl = this.metaStore.delete(key);
        if (bl) {
            this.log.debug("Dropped Partition {} of PartitionedJournalStore {}", (Object)string, (Object)this);
        }
        return bl;
    }

    @Override
    @Nullable
    public PartitionInfo getActivePartition() throws KazukiException {
        this.availability.assertAvailable();
        PartitionInfoImpl partitionInfoImpl = this.activePartitionInfo.get();
        return partitionInfoImpl == null ? null : partitionInfoImpl.snapshot();
    }

    @Override
    public KeyValueIterable<PartitionInfoSnapshot> getAllPartitions() throws KazukiException {
        this.availability.assertAvailable();
        return this.metaStore.iterators().values(this.typeName, PartitionInfoSnapshot.class);
    }

    private KeyValueStore getKeyValueStore(String string, boolean bl) {
        KeyValueStoreConfiguration.Builder builder = new KeyValueStoreConfiguration.Builder();
        builder.withDbType(this.dbType);
        builder.withGroupName(this.groupName);
        builder.withStoreName(this.storeName);
        builder.withPartitionName(string);
        builder.withPartitionSize(this.partitionSize);
        builder.withStrictTypeCreation(this.strictTypeCreation);
        KeyValueStoreJdbiH2Impl keyValueStoreJdbiH2Impl = new KeyValueStoreJdbiH2Impl(this.availability, this.database, this.typeHelper, this.schema, this.sequence, builder.build());
        if (bl) {
            keyValueStoreJdbiH2Impl.initialize();
        }
        return keyValueStoreJdbiH2Impl;
    }

    private static String getPartitionName(ResolvedKey resolvedKey) {
        return String.format("%016x", resolvedKey.getIdentifierLo());
    }

    private static <T> KeyValueIterable<T> emptyKeyValueIterable() {
        return new KeyValueIterable<T>(){

            @Override
            public KeyValueIterator<T> iterator() {
                return new KeyValueIterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public T next() {
                        throw new IllegalStateException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void close() {
                    }
                };
            }

            @Override
            public void close() {
            }
        };
    }

    private static <T> KeyValueIterable<T> concatKeyValueIterables(final Collection<KeyValueIterable<T>> collection) {
        return new KeyValueIterable<T>(){
            private final List<KeyValueIterable<T>> innerIterables;
            private boolean instantiated;
            {
                this.innerIterables = ImmutableList.copyOf((Collection)collection);
                this.instantiated = false;
            }

            @Override
            public KeyValueIterator<T> iterator() {
                if (this.instantiated) {
                    throw new IllegalStateException("iterable may only be used once!");
                }
                if (collection.isEmpty()) {
                    return PartitionedJournalStore.emptyKeyValueIterable().iterator();
                }
                return new KeyValueIterator<T>(){
                    private final Iterator<KeyValueIterable<T>> outerIter;
                    private KeyValueIterator<T> innerIter;
                    private boolean initialized;
                    {
                        this.outerIter = innerIterables.iterator();
                        this.innerIter = null;
                        this.initialized = false;
                    }

                    private void advance() {
                        while (this.outerIter.hasNext() && (this.innerIter == null || !this.innerIter.hasNext())) {
                            this.innerIter = this.outerIter.next().iterator();
                            if (!this.innerIter.hasNext()) continue;
                            break;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.initialized) {
                            this.advance();
                            this.initialized = true;
                        }
                        return this.innerIter.hasNext();
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new IllegalStateException("iterator has no next()");
                        }
                        Object t = this.innerIter.next();
                        if (!this.innerIter.hasNext()) {
                            this.advance();
                        }
                        return t;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void close() {
                        for (KeyValueIterable keyValueIterable : innerIterables) {
                            keyValueIterable.close();
                        }
                    }
                };
            }

            @Override
            public void close() {
                for (KeyValueIterable keyValueIterable : this.innerIterables) {
                    keyValueIterable.close();
                }
            }
        };
    }

    private <T> Provider<KeyValueIterable<KeyValuePair<T>>> getIterableProvider(final String string, final Class<T> clazz, final String string2, final Long l, final Long l2) {
        return new Provider<KeyValueIterable<KeyValuePair<T>>>(){

            public KeyValueIterable<KeyValuePair<T>> get() {
                try {
                    return PartitionedJournalStore.this.getKeyValueStore(string2, false).iterators().entries(string, clazz, l, l2);
                }
                catch (Exception exception) {
                    throw Throwables.propagate((Throwable)exception);
                }
            }

            public String toString() {
                return "Provider<Iterable>(t=" + string + ",c=" + clazz.getName() + ",p=" + string2 + ",o=" + l + ",l=" + l2 + ")";
            }
        };
    }

    public static class LazyIterable<T>
    implements KeyValueIterable<T> {
        private final Provider<KeyValueIterable<T>> provider;
        private KeyValueIterator<T> instance;
        private boolean instantiated = false;

        public LazyIterable(Provider<KeyValueIterable<T>> provider) {
            this.provider = provider;
        }

        @Override
        public KeyValueIterator<T> iterator() {
            if (this.instantiated) {
                throw new IllegalStateException("iterable may only be used once!");
            }
            if (this.instance == null) {
                this.instance = ((KeyValueIterable)this.provider.get()).iterator();
                this.instantiated = true;
            }
            return this.instance;
        }

        @Override
        public void close() {
            if (this.instantiated && this.instance != null) {
                this.instance.close();
                this.instance = null;
            }
        }

        public String toString() {
            return "LazyIterator(" + this.provider.toString() + ")";
        }
    }
}

