/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.journal;

import com.google.common.base.Preconditions;
import io.kazuki.v0.store.KazukiException;
import io.kazuki.v0.store.Key;
import io.kazuki.v0.store.journal.JournalStore;
import io.kazuki.v0.store.journal.PartitionInfo;
import io.kazuki.v0.store.journal.PartitionInfoSnapshot;
import io.kazuki.v0.store.keyvalue.KeyValueIterable;
import io.kazuki.v0.store.keyvalue.KeyValuePair;
import io.kazuki.v0.store.keyvalue.KeyValueStore;
import io.kazuki.v0.store.keyvalue.KeyValueStoreConfiguration;
import io.kazuki.v0.store.schema.TypeValidation;
import javax.inject.Inject;

public class SimpleJournalStore
implements JournalStore {
    private final KeyValueStore store;
    private final String dataType;

    @Inject
    public SimpleJournalStore(KeyValueStore keyValueStore, KeyValueStoreConfiguration keyValueStoreConfiguration) {
        Preconditions.checkNotNull((Object)keyValueStoreConfiguration.getDataType(), (Object)"dataType");
        this.store = keyValueStore;
        this.dataType = keyValueStoreConfiguration.getDataType();
    }

    @Override
    public void initialize() throws KazukiException {
    }

    @Override
    public <T> Key append(String string, Class<T> clazz, T t, TypeValidation typeValidation) throws KazukiException {
        return this.store.create(string, clazz, t, typeValidation);
    }

    @Override
    public <T> KeyValueIterable<KeyValuePair<T>> entriesAbsolute(String string, Class<T> clazz, Long l, Long l2) throws KazukiException {
        return this.store.iterators().entries(string, clazz, l, l2);
    }

    @Override
    public <T> KeyValueIterable<KeyValuePair<T>> entriesRelative(String string, Class<T> clazz, Long l, Long l2) throws KazukiException {
        return this.entriesAbsolute(string, clazz, l, l2);
    }

    @Override
    public Long approximateSize() throws KazukiException {
        return this.store.approximateSize(this.dataType);
    }

    @Override
    public void clear() throws KazukiException {
        this.store.clear(false, false);
    }

    @Override
    public boolean closeActivePartition() {
        throw new UnsupportedOperationException("closeActivePartition() not supported");
    }

    @Override
    public boolean dropPartition(String string) {
        throw new UnsupportedOperationException("dropPartition() not yet supported");
    }

    @Override
    public PartitionInfo getActivePartition() {
        throw new UnsupportedOperationException("getActivePartition() not yet supported");
    }

    @Override
    public KeyValueIterable<PartitionInfoSnapshot> getAllPartitions() {
        throw new UnsupportedOperationException("getAllPartitions() not yet supported");
    }
}

