/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.keyvalue;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.kazuki.v0.internal.availability.AvailabilityManager;
import io.kazuki.v0.internal.helper.EncodingHelper;
import io.kazuki.v0.internal.helper.JDBIHelper;
import io.kazuki.v0.internal.helper.LogTranslation;
import io.kazuki.v0.internal.helper.SqlTypeHelper;
import io.kazuki.v0.internal.v2schema.Schema;
import io.kazuki.v0.internal.v2schema.compact.FieldTransform;
import io.kazuki.v0.internal.v2schema.compact.StructureTransform;
import io.kazuki.v0.store.KazukiException;
import io.kazuki.v0.store.Key;
import io.kazuki.v0.store.keyvalue.KeyValueIterable;
import io.kazuki.v0.store.keyvalue.KeyValueIterator;
import io.kazuki.v0.store.keyvalue.KeyValuePair;
import io.kazuki.v0.store.keyvalue.KeyValueStore;
import io.kazuki.v0.store.keyvalue.KeyValueStoreIteration;
import io.kazuki.v0.store.lifecycle.Lifecycle;
import io.kazuki.v0.store.lifecycle.LifecycleSupportBase;
import io.kazuki.v0.store.schema.SchemaStore;
import io.kazuki.v0.store.schema.TypeValidation;
import io.kazuki.v0.store.sequence.KeyImpl;
import io.kazuki.v0.store.sequence.ResolvedKey;
import io.kazuki.v0.store.sequence.SequenceService;
import io.kazuki.v0.store.sequence.SequenceServiceJdbiImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.slf4j.Logger;

public abstract class KeyValueStoreJdbiBaseImpl
implements KeyValueStore,
KeyValueStoreIteration {
    public static int MULTIGET_MAX_KEYS = 3000;
    protected final Logger log = LogTranslation.getLogger(this.getClass());
    protected final AvailabilityManager availability;
    protected final IDBI database;
    protected final SchemaStore schemaService;
    protected final SequenceService sequences;
    protected final SqlTypeHelper typeHelper;
    protected final Lock nukeLock = new ReentrantLock();
    protected final String tableName;

    protected abstract String getPrefix();

    public KeyValueStoreJdbiBaseImpl(AvailabilityManager availabilityManager, IDBI iDBI, SqlTypeHelper sqlTypeHelper, SchemaStore schemaStore, SequenceService sequenceService, String string, String string2, String string3) {
        this.availability = availabilityManager;
        this.database = iDBI;
        this.typeHelper = sqlTypeHelper;
        this.schemaService = schemaStore;
        this.sequences = sequenceService;
        this.tableName = "_" + string + "_" + string2 + "__kv__" + string3;
    }

    @Inject
    public void register(Lifecycle lifecycle) {
        lifecycle.register(new LifecycleSupportBase(){

            @Override
            public void init() {
                KeyValueStoreJdbiBaseImpl.this.initialize();
            }

            @Override
            public void stop() {
                KeyValueStoreJdbiBaseImpl.this.availability.setAvailable(false);
            }
        });
    }

    @Override
    public void initialize() {
        this.log.debug("Intitializing KeyValueStore {}", (Object)this);
        this.database.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                KeyValueStoreJdbiBaseImpl.this.performInitialization(handle, KeyValueStoreJdbiBaseImpl.this.tableName);
                return null;
            }
        });
        this.availability.setAvailable(true);
        this.log.debug("Intitialized KeyValueStore {}", (Object)this);
    }

    @Override
    public Key toKey(String string) {
        return KeyImpl.valueOf(string);
    }

    @Override
    public synchronized <T> Key create(String string, Class<T> clazz, T t, TypeValidation typeValidation) throws KazukiException {
        return this.create(string, clazz, t, null, typeValidation);
    }

    @Override
    public synchronized <T> Key create(String string, Class<T> clazz, final T t, ResolvedKey resolvedKey, TypeValidation typeValidation) throws KazukiException {
        ResolvedKey resolvedKey2;
        Key key;
        this.availability.assertAvailable();
        if (string == null || TypeValidation.STRICT.equals((Object)typeValidation) && (string.contains("@") || string.contains("$"))) {
            throw new IllegalArgumentException("Invalid entity 'type'");
        }
        if (resolvedKey != null) {
            key = this.sequences.unresolveKey(resolvedKey);
            resolvedKey2 = resolvedKey;
        } else {
            key = this.sequences.nextKey(string);
            resolvedKey2 = this.sequences.resolveKey(key);
        }
        final Schema schema = this.schemaService.retrieveSchema(string);
        return (Key)this.database.inTransaction((TransactionCallback)new TransactionCallback<Key>(){

            public Key inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                int n;
                Object object;
                Object object2;
                Object object3 = EncodingHelper.asJsonMap(t);
                if (schema != null) {
                    object2 = new FieldTransform(schema);
                    object = new StructureTransform(schema);
                    object3 = ((StructureTransform)object).pack(((FieldTransform)object2).pack((Map<String, Object>)object3));
                }
                if ((n = KeyValueStoreJdbiBaseImpl.this.doInsert(handle, resolvedKey2, (byte[])(object2 = EncodingHelper.convertToSmile(object3)), (DateTime)(object = new DateTime()))) < 1) {
                    throw new KazukiException("Entity not created!");
                }
                return key;
            }
        });
    }

    @Override
    public synchronized <T> T retrieve(Key key, final Class<T> clazz) throws KazukiException {
        this.availability.assertAvailable();
        final Schema schema = this.schemaService.retrieveSchema(key.getTypePart());
        final ResolvedKey resolvedKey = this.sequences.resolveKey(key);
        return (T)this.database.inTransaction(new TransactionCallback<T>(){

            public T inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                try {
                    byte[] byArray = KeyValueStoreJdbiBaseImpl.this.getObjectBytes(handle, resolvedKey);
                    if (byArray == null) {
                        return null;
                    }
                    Map<String, Object> map = EncodingHelper.parseSmile(byArray, Object.class);
                    if (schema != null && map instanceof List) {
                        FieldTransform fieldTransform = new FieldTransform(schema);
                        StructureTransform structureTransform = new StructureTransform(schema);
                        map = fieldTransform.unpack(structureTransform.unpack((List)((Object)map)));
                    }
                    return EncodingHelper.asValue(map, clazz);
                }
                catch (Exception exception) {
                    throw new KazukiException(exception);
                }
            }
        });
    }

    @Override
    public synchronized <T> Map<Key, T> multiRetrieve(final Collection<Key> collection, final Class<T> clazz) throws KazukiException {
        this.availability.assertAvailable();
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyMap();
        }
        Preconditions.checkArgument((collection.size() <= MULTIGET_MAX_KEYS ? 1 : 0) != 0, (String)"Multiget max is %s keys", (Object[])new Object[]{MULTIGET_MAX_KEYS});
        final HashMap<String, Schema> hashMap = new HashMap<String, Schema>(collection.size());
        for (Key key : collection) {
            String string = key.getTypePart();
            if (hashMap.containsKey(string)) continue;
            hashMap.put(string, this.schemaService.retrieveSchema(key.getTypePart()));
        }
        return (Map)this.database.inTransaction(new TransactionCallback<Map<Key, T>>(){

            public Map<Key, T> inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                for (Key key : collection) {
                    ResolvedKey resolvedKey = KeyValueStoreJdbiBaseImpl.this.sequences.resolveKey(key);
                    Query<Map<String, Object>> query = JDBIHelper.getBoundQuery(handle, KeyValueStoreJdbiBaseImpl.this.getPrefix(), "kv_table_name", KeyValueStoreJdbiBaseImpl.this.tableName, "kv_retrieve");
                    query.bind("key_type", resolvedKey.getTypeTag());
                    query.bind("key_id_hi", resolvedKey.getIdentifierHi());
                    query.bind("key_id_lo", resolvedKey.getIdentifierLo());
                    List list = query.list();
                    if (list == null || list.isEmpty()) {
                        linkedHashMap.put(key, null);
                        continue;
                    }
                    Map map = (Map)list.iterator().next();
                    Map<String, Object> map2 = EncodingHelper.parseSmile((byte[])map.get("_value"), Object.class);
                    Schema schema = (Schema)hashMap.get(key.getTypePart());
                    if (schema != null && map2 instanceof List) {
                        FieldTransform fieldTransform = new FieldTransform(schema);
                        StructureTransform structureTransform = new StructureTransform(schema);
                        map2 = fieldTransform.unpack(structureTransform.unpack((List)((Object)map2)));
                    }
                    linkedHashMap.put(key, EncodingHelper.asValue(map2, clazz));
                }
                return linkedHashMap;
            }
        });
    }

    @Override
    public synchronized <T> boolean update(Key key, Class<T> clazz, final T t) throws KazukiException {
        this.availability.assertAvailable();
        final Schema schema = this.schemaService.retrieveSchema(key.getTypePart());
        final ResolvedKey resolvedKey = this.sequences.resolveKey(key);
        try {
            return (Boolean)this.database.inTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                    int n;
                    Object object = EncodingHelper.asJsonMap(t);
                    if (schema != null) {
                        FieldTransform fieldTransform = new FieldTransform(schema);
                        StructureTransform structureTransform = new StructureTransform(schema);
                        object = structureTransform.pack(fieldTransform.pack((Map<String, Object>)object));
                    }
                    return (n = KeyValueStoreJdbiBaseImpl.this.doUpdate(handle, resolvedKey, EncodingHelper.convertToSmile(object))) == 1;
                }
            });
        }
        catch (Exception exception) {
            throw new KazukiException(exception);
        }
    }

    @Override
    public synchronized boolean delete(Key key) throws KazukiException {
        this.availability.assertAvailable();
        final ResolvedKey resolvedKey = this.sequences.resolveKey(key);
        return (Boolean)this.database.inTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                Update update = JDBIHelper.getBoundStatement(handle, KeyValueStoreJdbiBaseImpl.this.getPrefix(), "kv_table_name", KeyValueStoreJdbiBaseImpl.this.tableName, "kv_delete");
                update.bind("updated_dt", KeyValueStoreJdbiBaseImpl.this.getEpochSecondsNow());
                update.bind("key_type", resolvedKey.getTypeTag());
                update.bind("key_id_hi", resolvedKey.getIdentifierHi());
                update.bind("key_id_lo", resolvedKey.getIdentifierLo());
                int n = update.execute();
                return n == 1;
            }
        });
    }

    @Override
    public synchronized boolean deleteHard(Key key) throws KazukiException {
        this.availability.assertAvailable();
        final ResolvedKey resolvedKey = this.sequences.resolveKey(key);
        return (Boolean)this.database.inTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                Update update = JDBIHelper.getBoundStatement(handle, KeyValueStoreJdbiBaseImpl.this.getPrefix(), "kv_table_name", KeyValueStoreJdbiBaseImpl.this.tableName, "kv_delete_hard");
                update.bind("updated_dt", KeyValueStoreJdbiBaseImpl.this.getEpochSecondsNow());
                update.bind("key_type", resolvedKey.getTypeTag());
                update.bind("key_id_hi", resolvedKey.getIdentifierHi());
                update.bind("key_id_lo", resolvedKey.getIdentifierLo());
                int n = update.execute();
                return n != 0;
            }
        });
    }

    @Override
    public Long approximateSize(String string) throws KazukiException {
        this.availability.assertAvailable();
        Key key = ((SequenceServiceJdbiImpl)this.sequences).peekKey(string);
        ResolvedKey resolvedKey = this.sequences.resolveKey(key);
        return key == null ? 0L : resolvedKey.getIdentifierLo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(final boolean bl, boolean bl2) {
        this.log.debug("Clearing KeyValueStore {} table {}", (Object)this, (Object)this.tableName);
        this.availability.assertAvailable();
        this.nukeLock.lock();
        try {
            this.database.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

                public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                    if (bl) {
                        JDBIHelper.getBoundStatement(handle, KeyValueStoreJdbiBaseImpl.this.getPrefix(), "kv_table_name", KeyValueStoreJdbiBaseImpl.this.tableName, "kv_reset");
                    } else {
                        JDBIHelper.getBoundStatement(handle, KeyValueStoreJdbiBaseImpl.this.getPrefix(), "kv_table_name", KeyValueStoreJdbiBaseImpl.this.tableName, "kv_truncate").execute();
                        KeyValueStoreJdbiBaseImpl.this.performInitialization(handle, KeyValueStoreJdbiBaseImpl.this.tableName);
                    }
                    return null;
                }
            });
            this.sequences.clear(bl, bl2);
        }
        finally {
            this.nukeLock.unlock();
        }
        this.log.debug("Cleared KeyValueStore {} table {}", (Object)this, (Object)this.tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(String string) throws KazukiException {
        this.log.debug("Clearing KeyValueStore {} table {} type {}", new Object[]{this, this.tableName, string});
        this.availability.assertAvailable();
        this.nukeLock.lock();
        final int n = this.sequences.getTypeId(string, false);
        try {
            this.database.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

                public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                    ((Update)JDBIHelper.getBoundStatement(handle, KeyValueStoreJdbiBaseImpl.this.getPrefix(), "kv_table_name", KeyValueStoreJdbiBaseImpl.this.tableName, "kv_clear_type").bind("key_type", n)).execute();
                    return null;
                }
            });
            this.log.debug("Cleared KeyValueStore {} table {} type {}", new Object[]{this, this.tableName, string});
        }
        finally {
            this.nukeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.log.debug("Destroying KeyValueStore {} table {}", (Object)this, (Object)this.tableName);
        this.availability.assertAvailable();
        this.nukeLock.lock();
        try {
            this.database.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

                public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                    JDBIHelper.getBoundStatement(handle, KeyValueStoreJdbiBaseImpl.this.getPrefix(), "kv_table_name", KeyValueStoreJdbiBaseImpl.this.tableName, "kv_truncate").execute();
                    JDBIHelper.getBoundStatement(handle, KeyValueStoreJdbiBaseImpl.this.getPrefix(), "kv_table_name", KeyValueStoreJdbiBaseImpl.this.tableName, "kv_destroy");
                    return null;
                }
            });
        }
        finally {
            this.nukeLock.unlock();
        }
        this.log.debug("Destroyed KeyValueStore {} table {}", (Object)this, (Object)this.tableName);
    }

    @Override
    public KeyValueStoreIteration iterators() {
        return this;
    }

    @Override
    public <T> KeyValueIterator<T> iterator(String string, Class<T> clazz) {
        return this.values(string, clazz).iterator();
    }

    @Override
    public <T> KeyValueIterator<T> iterator(String string, Class<T> clazz, @Nullable Long l, @Nullable Long l2) {
        return this.values(string, clazz, l, l2).iterator();
    }

    @Override
    public <T> KeyValueIterable<KeyValuePair<T>> entries(String string, Class<T> clazz) {
        return this.entries(string, clazz, null, null);
    }

    @Override
    public <T> KeyValueIterable<KeyValuePair<T>> entries(String string, Class<T> clazz, @Nullable Long l, @Nullable Long l2) {
        return new KeyValueIterableJdbiImpl<T>(string, clazz, l, l2, true);
    }

    @Override
    public <T> KeyValueIterable<Key> keys(String string, Class<T> clazz) {
        return this.keys(string, clazz, null, null);
    }

    @Override
    public <T> KeyValueIterable<Key> keys(final String string, final Class<T> clazz, final @Nullable Long l, final @Nullable Long l2) {
        return new KeyValueIterable<Key>(){
            private volatile KeyValueIterableJdbiImpl<T> inner;
            {
                this.inner = new KeyValueIterableJdbiImpl(string, clazz, l, l2, false);
            }

            @Override
            public KeyValueIterator<Key> iterator() {
                return new KeyValueIterator<Key>(){
                    volatile KeyValueIterator<KeyValuePair<T>> innerIter;
                    {
                        this.innerIter = inner.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.innerIter == null) {
                            return false;
                        }
                        return this.innerIter.hasNext();
                    }

                    @Override
                    public Key next() {
                        return this.innerIter.next().getKey();
                    }

                    @Override
                    public void remove() {
                        this.innerIter.remove();
                    }

                    @Override
                    public void close() {
                        KeyValueStoreJdbiBaseImpl.this.closeQuietly(this.innerIter);
                        this.innerIter = null;
                    }
                };
            }

            @Override
            public void close() {
                KeyValueStoreJdbiBaseImpl.this.closeQuietly(this.inner);
                this.inner = null;
            }
        };
    }

    @Override
    public <T> KeyValueIterable<T> values(String string, Class<T> clazz) {
        return this.values(string, clazz, null, null);
    }

    @Override
    public <T> KeyValueIterable<T> values(final String string, final Class<T> clazz, final @Nullable Long l, final @Nullable Long l2) {
        return new KeyValueIterable<T>(){
            private volatile KeyValueIterableJdbiImpl<T> inner;
            {
                this.inner = new KeyValueIterableJdbiImpl(string, clazz, l, l2, true);
            }

            @Override
            public KeyValueIterator<T> iterator() {
                return new KeyValueIterator<T>(){
                    volatile KeyValueIterator<KeyValuePair<T>> innerIter;
                    {
                        this.innerIter = inner.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.innerIter == null) {
                            return false;
                        }
                        return this.innerIter.hasNext();
                    }

                    @Override
                    public T next() {
                        return this.innerIter.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.innerIter.remove();
                    }

                    @Override
                    public void close() {
                        KeyValueStoreJdbiBaseImpl.this.closeQuietly(this.innerIter);
                        this.innerIter = null;
                    }
                };
            }

            @Override
            public void close() {
                KeyValueStoreJdbiBaseImpl.this.closeQuietly(this.inner);
                this.inner = null;
            }
        };
    }

    private byte[] getObjectBytes(Handle handle, ResolvedKey resolvedKey) throws KazukiException {
        Query<Map<String, Object>> query = JDBIHelper.getBoundQuery(handle, this.getPrefix(), "kv_table_name", this.tableName, "kv_retrieve");
        query.bind("key_type", resolvedKey.getTypeTag());
        query.bind("key_id_hi", resolvedKey.getIdentifierHi());
        query.bind("key_id_lo", resolvedKey.getIdentifierLo());
        List list = query.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Map map = (Map)list.iterator().next();
        byte[] byArray = (byte[])map.get("_value");
        return byArray;
    }

    private KeyValueIterator<Map<String, Object>> createKeyValueIterator(String string, Long l, Long l2, boolean bl) {
        Integer n;
        try {
            n = this.sequences.getTypeId(string, false);
        }
        catch (KazukiException kazukiException) {
            throw Throwables.propagate((Throwable)kazukiException);
        }
        if (n == null) {
            return null;
        }
        final Handle handle = this.database.open();
        String string2 = bl ? "kv_key_values_of_type" : "kv_key_ids_of_type";
        Query<Map<String, Object>> query = JDBIHelper.getBoundQuery(handle, this.getPrefix(), "kv_table_name", this.tableName, string2);
        query.bind("key_type", n);
        query.bind("offset", l);
        query.bind("limit", l2);
        ResultIterator resultIterator = query.iterator();
        return new KeyValueIterator<Map<String, Object>>((Iterator)resultIterator){
            private Handle theHandle;
            final /* synthetic */ Iterator val$iter;
            {
                this.val$iter = iterator;
                this.theHandle = handle;
            }

            @Override
            public boolean hasNext() {
                if (this.theHandle == null) {
                    return false;
                }
                boolean bl = this.val$iter.hasNext();
                if (!bl) {
                    KeyValueStoreJdbiBaseImpl.this.closeQuietly((AutoCloseable)this.theHandle);
                    this.theHandle = null;
                }
                return bl;
            }

            @Override
            public Map<String, Object> next() {
                return (Map)this.val$iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                KeyValueStoreJdbiBaseImpl.this.closeQuietly((AutoCloseable)this.theHandle);
                this.theHandle = null;
            }
        };
    }

    private void performInitialization(Handle handle, String string) {
        block2: {
            this.log.debug("Creating table if not exist with name {} for KeyValueStore {}", (Object)string, (Object)this);
            try {
                JDBIHelper.getBoundStatement(handle, this.getPrefix(), "kv_table_name", string, "kv_create_table").execute();
            }
            catch (Throwable throwable) {
                if (this.typeHelper.isTableAlreadyExistsException(throwable)) break block2;
                throw Throwables.propagate((Throwable)throwable);
            }
        }
        this.log.debug("Creating index if not exists on table {} for KeyValueStore {}", (Object)string, (Object)this);
        JDBIHelper.getBoundStatement(handle, this.getPrefix(), "kv_table_name", string, "kv_create_table_index").execute();
    }

    private int doInsert(Handle handle, ResolvedKey resolvedKey, byte[] byArray, DateTime dateTime) {
        Update update = JDBIHelper.getBoundStatement(handle, this.getPrefix(), "kv_table_name", this.tableName, "kv_create");
        update.bind("key_type", resolvedKey.getTypeTag());
        update.bind("key_id_hi", resolvedKey.getIdentifierHi());
        update.bind("key_id_lo", resolvedKey.getIdentifierLo());
        update.bind("created_dt", dateTime.withZone(DateTimeZone.UTC).getMillis() / 1000L);
        update.bind("version", 0L);
        update.bind("value", byArray);
        int n = update.execute();
        return n;
    }

    private int doUpdate(Handle handle, ResolvedKey resolvedKey, byte[] byArray) {
        Update update = JDBIHelper.getBoundStatement(handle, this.getPrefix(), "kv_table_name", this.tableName, "kv_update");
        update.bind("key_type", resolvedKey.getTypeTag());
        update.bind("key_id_hi", resolvedKey.getIdentifierHi());
        update.bind("key_id_lo", resolvedKey.getIdentifierLo());
        update.bind("updated_dt", this.getEpochSecondsNow());
        update.bind("old_version", 0L);
        update.bind("new_version", 0L);
        update.bind("value", byArray);
        int n = update.execute();
        return n;
    }

    private int getEpochSecondsNow() {
        return (int)(new DateTime().withZone(DateTimeZone.UTC).getMillis() / 1000L);
    }

    private void closeQuietly(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                this.log.debug("Exception during close {}", (Throwable)exception);
            }
        }
    }

    class KeyValueIterableJdbiImpl<T>
    implements KeyValueIterable<KeyValuePair<T>> {
        private final String type;
        private final Class<T> clazz;
        private final Long offset;
        private final Long limit;
        private final boolean includeValues;
        private volatile KeyValueIterator<KeyValuePair<T>> theIter = null;
        private boolean instantiated = false;

        public KeyValueIterableJdbiImpl(String string, Class<T> clazz, Long l, Long l2, boolean bl) {
            this.type = string;
            this.clazz = clazz;
            this.offset = l;
            this.limit = l2;
            this.includeValues = bl;
        }

        @Override
        public KeyValueIterator<KeyValuePair<T>> iterator() {
            if (this.instantiated) {
                throw new IllegalStateException("iterable may only be used once!");
            }
            try {
                this.theIter = new KeyValueIterator<KeyValuePair<T>>(){
                    private volatile KeyValueIterator<Map<String, Object>> inner;
                    private final Schema schema;
                    private KeyValuePair<T> nextKv;
                    private KeyValuePair<T> currentKv;
                    {
                        this.inner = KeyValueStoreJdbiBaseImpl.this.createKeyValueIterator(KeyValueIterableJdbiImpl.this.type, KeyValueIterableJdbiImpl.this.offset, KeyValueIterableJdbiImpl.this.limit, KeyValueIterableJdbiImpl.this.includeValues);
                        this.schema = KeyValueStoreJdbiBaseImpl.this.schemaService.retrieveSchema(KeyValueIterableJdbiImpl.this.type);
                        this.nextKv = this.advance();
                        this.currentKv = null;
                    }

                    public KeyValuePair<T> advance() {
                        Preconditions.checkNotNull(this.inner, (Object)"iterator");
                        Map<String, Object> map = null;
                        KeyImpl keyImpl = null;
                        Object t = null;
                        if (keyImpl == null && this.inner.hasNext()) {
                            map = this.inner.next();
                            try {
                                keyImpl = KeyImpl.createInternal(KeyValueIterableJdbiImpl.this.type, ((Number)map.get("_key_id_lo")).longValue());
                            }
                            catch (Exception exception) {
                                throw Throwables.propagate((Throwable)exception);
                            }
                        }
                        if (keyImpl == null) {
                            return null;
                        }
                        try {
                            if (KeyValueIterableJdbiImpl.this.includeValues) {
                                byte[] byArray = (byte[])map.get("_value");
                                Map<String, Object> map2 = EncodingHelper.parseSmile(byArray, Object.class);
                                if (this.schema != null && map2 instanceof List) {
                                    FieldTransform fieldTransform = new FieldTransform(this.schema);
                                    StructureTransform structureTransform = new StructureTransform(this.schema);
                                    map2 = fieldTransform.unpack(structureTransform.unpack((List)((Object)map2)));
                                }
                                t = EncodingHelper.asValue(map2, KeyValueIterableJdbiImpl.this.clazz);
                            }
                        }
                        catch (Exception exception) {
                            throw Throwables.propagate((Throwable)exception);
                        }
                        return new KeyValuePair<Object>(keyImpl, t);
                    }

                    @Override
                    public boolean hasNext() {
                        Preconditions.checkNotNull(this.inner, (Object)"iterator");
                        return this.nextKv != null;
                    }

                    @Override
                    public KeyValuePair<T> next() {
                        KeyValueStoreJdbiBaseImpl.this.availability.assertAvailable();
                        this.currentKv = this.nextKv;
                        this.nextKv = this.advance();
                        return this.currentKv;
                    }

                    @Override
                    public void remove() {
                        KeyValueStoreJdbiBaseImpl.this.availability.assertAvailable();
                        Preconditions.checkNotNull(this.inner, (Object)"iterator");
                        Preconditions.checkNotNull(this.currentKv, (Object)"next");
                        try {
                            KeyValueStoreJdbiBaseImpl.this.delete(this.currentKv.getKey());
                            this.currentKv = null;
                        }
                        catch (KazukiException kazukiException) {
                            throw Throwables.propagate((Throwable)kazukiException);
                        }
                    }

                    @Override
                    public void close() {
                        KeyValueStoreJdbiBaseImpl.this.closeQuietly(this.inner);
                        this.inner = null;
                    }
                };
            }
            catch (KazukiException kazukiException) {
                throw Throwables.propagate((Throwable)kazukiException);
            }
            this.instantiated = true;
            return this.theIter;
        }

        @Override
        public void close() {
            KeyValueStoreJdbiBaseImpl.this.closeQuietly(this.theIter);
            this.theIter = null;
        }
    }
}

