/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.keyvalue;

import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import io.kazuki.v0.internal.availability.AvailabilityManager;
import io.kazuki.v0.internal.helper.H2TypeHelper;
import io.kazuki.v0.internal.helper.SqlTypeHelper;
import io.kazuki.v0.store.config.ConfigurationProvider;
import io.kazuki.v0.store.jdbi.IdbiProvider;
import io.kazuki.v0.store.keyvalue.KeyValueStore;
import io.kazuki.v0.store.keyvalue.KeyValueStoreConfiguration;
import io.kazuki.v0.store.keyvalue.KeyValueStoreJdbiH2Impl;
import io.kazuki.v0.store.lifecycle.Lifecycle;
import io.kazuki.v0.store.schema.SchemaStore;
import io.kazuki.v0.store.schema.SchemaStoreImpl;
import io.kazuki.v0.store.sequence.SequenceService;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.skife.jdbi.v2.IDBI;

public class KeyValueStoreJdbiH2Module
extends PrivateModule {
    protected final String name;
    protected final String propertiesPath;
    private final AtomicReference<KeyValueStoreConfiguration> config;

    public KeyValueStoreJdbiH2Module(String string, @Nullable String string2) {
        this.name = string;
        this.propertiesPath = string2;
        this.config = new AtomicReference();
    }

    public KeyValueStoreJdbiH2Module withConfiguration(KeyValueStoreConfiguration keyValueStoreConfiguration) {
        this.config.set(keyValueStoreConfiguration);
        return this;
    }

    protected void includeInternal() {
    }

    protected void includeExposures() {
    }

    public void configure() {
        this.bind(Lifecycle.class).to(Key.get(Lifecycle.class, (Annotation)Names.named((String)this.name))).in(Scopes.SINGLETON);
        KeyValueStoreConfiguration keyValueStoreConfiguration = this.config.get();
        if (keyValueStoreConfiguration != null) {
            this.bind(KeyValueStoreConfiguration.class).toInstance((Object)keyValueStoreConfiguration);
        } else if (this.propertiesPath != null) {
            this.bind(KeyValueStoreConfiguration.class).toProvider(new ConfigurationProvider<KeyValueStoreConfiguration>(this.name, KeyValueStoreConfiguration.class, this.propertiesPath, true));
        } else {
            this.bind(KeyValueStoreConfiguration.class).to(Key.get(KeyValueStoreConfiguration.class, (Annotation)Names.named((String)this.name)));
        }
        this.bind(SqlTypeHelper.class).to(H2TypeHelper.class).in(Scopes.SINGLETON);
        this.bind(AvailabilityManager.class).in(Scopes.SINGLETON);
        Provider provider = this.binder().getProvider(Key.get(SequenceService.class, (Annotation)Names.named((String)this.name)));
        Provider provider2 = this.binder().getProvider(Key.get(DataSource.class, (Annotation)Names.named((String)this.name)));
        this.bind(DataSource.class).toProvider(provider2);
        this.bind(IDBI.class).toProvider((Provider)new IdbiProvider(KeyValueStore.class, (Provider<DataSource>)provider2)).in(Scopes.SINGLETON);
        this.bind(SequenceService.class).toProvider(provider).in(Scopes.SINGLETON);
        this.bind(KeyValueStore.class).to(KeyValueStoreJdbiH2Impl.class).in(Scopes.SINGLETON);
        this.bind(KeyValueStore.class).annotatedWith((Annotation)Names.named((String)this.name)).toProvider(this.binder().getProvider(Key.get(KeyValueStore.class))).in(Scopes.SINGLETON);
        this.bind(SchemaStore.class).to(SchemaStoreImpl.class).in(Scopes.SINGLETON);
        this.bind(SchemaStore.class).annotatedWith((Annotation)Names.named((String)this.name)).to(Key.get(SchemaStore.class));
        this.includeInternal();
        this.expose(Key.get(SchemaStore.class, (Annotation)Names.named((String)this.name)));
        this.expose(Key.get(KeyValueStore.class, (Annotation)Names.named((String)this.name)));
        this.includeExposures();
    }
}

