/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.lifecycle;

import io.kazuki.v0.internal.helper.LogTranslation;
import io.kazuki.v0.store.lifecycle.Lifecycle;
import io.kazuki.v0.store.lifecycle.LifecycleAware;
import io.kazuki.v0.store.lifecycle.LifecycleEvent;
import io.kazuki.v0.store.lifecycle.LifecycleRegistration;
import org.slf4j.Logger;

public abstract class LifecycleSupportBase
implements LifecycleRegistration,
LifecycleAware {
    protected final Logger log = LogTranslation.getLogger(this.getClass());

    @Override
    public void register(Lifecycle lifecycle) {
        lifecycle.register(this);
    }

    public void init() {
    }

    public void start() {
    }

    public void announce() {
    }

    public void unannounce() {
    }

    public void shutdown() {
    }

    public void stop() {
    }

    @Override
    public void eventFired(LifecycleEvent lifecycleEvent) {
        switch (lifecycleEvent) {
            case INIT: {
                this.init();
                break;
            }
            case START: {
                this.start();
                break;
            }
            case ANNOUNCE: {
                this.announce();
                break;
            }
            case UNANNOUNCE: {
                this.unannounce();
                break;
            }
            case SHUTDOWN: {
                this.shutdown();
                break;
            }
            case STOP: {
                this.stop();
            }
        }
    }
}

