/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.sequence;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import io.kazuki.v0.internal.availability.AvailabilityManager;
import io.kazuki.v0.internal.helper.H2TypeHelper;
import io.kazuki.v0.internal.helper.SqlTypeHelper;
import io.kazuki.v0.store.config.ConfigurationProvider;
import io.kazuki.v0.store.jdbi.IdbiProvider;
import io.kazuki.v0.store.lifecycle.Lifecycle;
import io.kazuki.v0.store.sequence.SequenceHelper;
import io.kazuki.v0.store.sequence.SequenceService;
import io.kazuki.v0.store.sequence.SequenceServiceConfiguration;
import io.kazuki.v0.store.sequence.SequenceServiceJdbiImpl;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.skife.jdbi.v2.IDBI;

public class H2SequenceServiceModule
extends PrivateModule {
    private final String name;
    private final String propertiesPath;
    private final AtomicReference<SequenceServiceConfiguration> config;

    public H2SequenceServiceModule(String string, @Nullable String string2) {
        Preconditions.checkNotNull((Object)string, (Object)"name");
        this.name = string;
        this.propertiesPath = string2;
        this.config = new AtomicReference();
    }

    public H2SequenceServiceModule withConfiguration(SequenceServiceConfiguration sequenceServiceConfiguration) {
        this.config.set(sequenceServiceConfiguration);
        return this;
    }

    protected void configure() {
        this.bind(Lifecycle.class).to(Key.get(Lifecycle.class, (Annotation)Names.named((String)this.name))).in(Scopes.SINGLETON);
        Provider provider = this.binder().getProvider(Key.get(DataSource.class, (Annotation)Names.named((String)this.name)));
        this.bind(IDBI.class).toProvider((Provider)new IdbiProvider(SequenceService.class, (Provider<DataSource>)provider)).in(Scopes.SINGLETON);
        this.bind(SqlTypeHelper.class).to(H2TypeHelper.class).in(Scopes.SINGLETON);
        SequenceServiceConfiguration sequenceServiceConfiguration = this.config.get();
        if (sequenceServiceConfiguration != null) {
            this.bind(SequenceServiceConfiguration.class).toInstance((Object)sequenceServiceConfiguration);
        } else if (this.propertiesPath != null) {
            this.bind(SequenceServiceConfiguration.class).toProvider(new ConfigurationProvider<SequenceServiceConfiguration>(this.name, SequenceServiceConfiguration.class, this.propertiesPath, true));
        } else {
            this.bind(SequenceServiceConfiguration.class).to(Key.get(SequenceServiceConfiguration.class, (Annotation)Names.named((String)this.name)));
        }
        this.bind(SequenceHelper.class).in(Scopes.SINGLETON);
        this.bind(AvailabilityManager.class).in(Scopes.SINGLETON);
        this.bind(SequenceService.class).annotatedWith((Annotation)Names.named((String)this.name)).to(SequenceServiceJdbiImpl.class).in(Scopes.SINGLETON);
        this.expose(SequenceService.class).annotatedWith((Annotation)Names.named((String)this.name));
    }
}

