/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.sequence;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.kazuki.v0.store.config.ConfigurationBuilder;

public class SequenceServiceConfiguration {
    private final String dbType;
    private final String dbPrefix;
    private final String groupName;
    private final String storeName;
    private final Long incrementBlockSize;
    private final boolean strictTypeCreation;

    public SequenceServiceConfiguration(@JsonProperty(value="dbType") String string, @JsonProperty(value="groupName") String string2, @JsonProperty(value="storeName") String string3, @JsonProperty(value="incrementBlockSize") Long l, @JsonProperty(value="strict") boolean bl) {
        Preconditions.checkNotNull((Object)string, (Object)"dbType");
        Preconditions.checkArgument((!string.contains("_") && !string.contains(":") ? 1 : 0) != 0, (Object)"invalid dbType");
        Preconditions.checkNotNull((Object)string2, (Object)"groupName");
        Preconditions.checkNotNull((Object)string3, (Object)"storeName");
        Preconditions.checkNotNull((Object)l, (Object)"incrementBlockSize");
        this.dbType = string;
        this.dbPrefix = string + ":" + string + "_";
        this.groupName = string2;
        this.storeName = string3;
        this.incrementBlockSize = l;
        this.strictTypeCreation = bl;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getDbPrefix() {
        return this.dbPrefix;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Long getIncrementBlockSize() {
        return this.incrementBlockSize;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public boolean isStrictTypeCreation() {
        return this.strictTypeCreation;
    }

    public static class Builder
    implements ConfigurationBuilder<SequenceServiceConfiguration> {
        private String dbType;
        private String groupName;
        private String storeName;
        private Long incrementBlockSize = 100000L;
        private boolean strictTypeCreation = true;

        public Builder withDbType(String string) {
            this.dbType = string;
            return this;
        }

        public Builder withGroupName(String string) {
            this.groupName = string;
            return this;
        }

        public Builder withStoreName(String string) {
            this.storeName = string;
            return this;
        }

        public Builder withIncrementBlockSize(Long l) {
            this.incrementBlockSize = l;
            return this;
        }

        public Builder withStrictTypeCreation(boolean bl) {
            this.strictTypeCreation = bl;
            return this;
        }

        @Override
        public SequenceServiceConfiguration build() {
            return new SequenceServiceConfiguration(this.dbType, this.groupName, this.storeName, this.incrementBlockSize, this.strictTypeCreation);
        }
    }
}

