/*
 * Decompiled with CFR 0.152.
 */
package io.kazuki.v0.store.sequence;

import com.google.common.base.Throwables;
import io.kazuki.v0.internal.availability.AvailabilityManager;
import io.kazuki.v0.internal.availability.Releasable;
import io.kazuki.v0.internal.helper.JDBIHelper;
import io.kazuki.v0.internal.helper.LogTranslation;
import io.kazuki.v0.internal.helper.SqlTypeHelper;
import io.kazuki.v0.store.KazukiException;
import io.kazuki.v0.store.Key;
import io.kazuki.v0.store.lifecycle.Lifecycle;
import io.kazuki.v0.store.lifecycle.LifecycleRegistration;
import io.kazuki.v0.store.lifecycle.LifecycleSupportBase;
import io.kazuki.v0.store.sequence.KeyImpl;
import io.kazuki.v0.store.sequence.ResolvedKey;
import io.kazuki.v0.store.sequence.SequenceHelper;
import io.kazuki.v0.store.sequence.SequenceService;
import io.kazuki.v0.store.sequence.SequenceServiceConfiguration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.slf4j.Logger;

public class SequenceServiceJdbiImpl
implements SequenceService,
LifecycleRegistration {
    public static final long DEFAULT_INCREMENT_BLOCK_SIZE = 100000L;
    private final Logger log = LogTranslation.getLogger(this.getClass());
    protected final Map<String, Counter> counters = new ConcurrentHashMap<String, Counter>();
    protected final Map<String, Integer> typeCodes = new ConcurrentHashMap<String, Integer>();
    protected final Map<Integer, String> typeNames = new ConcurrentHashMap<Integer, String>();
    protected final SequenceHelper sequenceHelper;
    protected final SqlTypeHelper typeHelper;
    protected final AvailabilityManager availabilityManager;
    protected final IDBI dataSource;
    protected final long incrementBlockSize;

    @Inject
    public SequenceServiceJdbiImpl(SequenceServiceConfiguration sequenceServiceConfiguration, AvailabilityManager availabilityManager, SequenceHelper sequenceHelper, IDBI iDBI, SqlTypeHelper sqlTypeHelper) {
        this(sequenceHelper, availabilityManager, iDBI, sqlTypeHelper, sequenceServiceConfiguration.getGroupName(), sequenceServiceConfiguration.getStoreName(), sequenceServiceConfiguration.getIncrementBlockSize());
    }

    public SequenceServiceJdbiImpl(SequenceHelper sequenceHelper, AvailabilityManager availabilityManager, IDBI iDBI, SqlTypeHelper sqlTypeHelper, String string, String string2, Long l) {
        this.sequenceHelper = sequenceHelper;
        this.availabilityManager = availabilityManager;
        this.dataSource = iDBI;
        this.typeHelper = sqlTypeHelper;
        this.incrementBlockSize = l != null ? l : 100000L;
    }

    @Override
    @Inject
    public void register(Lifecycle lifecycle) {
        lifecycle.register(new LifecycleSupportBase(){

            @Override
            public void init() {
                SequenceServiceJdbiImpl.this.initialize();
            }

            @Override
            public void shutdown() {
                SequenceServiceJdbiImpl.this.shutdown();
            }
        });
    }

    public synchronized void initialize() {
        this.log.debug("Initializing Sequence Service {}", (Object)this);
        this.availabilityManager.setAvailable(false);
        this.dataSource.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                block5: {
                    block4: {
                        JDBIHelper.getBoundStatement(handle, SequenceServiceJdbiImpl.this.sequenceHelper.getDbPrefix(), "key_types_table_name", SequenceServiceJdbiImpl.this.sequenceHelper.getKeyTypesTableName(), "seq_types_create_table").execute();
                        JDBIHelper.getBoundStatement(handle, SequenceServiceJdbiImpl.this.sequenceHelper.getDbPrefix(), "sequence_table_name", SequenceServiceJdbiImpl.this.sequenceHelper.getSequenceTableName(), "seq_seq_create_table").execute();
                        try {
                            JDBIHelper.getBoundStatement(handle, SequenceServiceJdbiImpl.this.sequenceHelper.getDbPrefix(), "key_types_table_name", SequenceServiceJdbiImpl.this.sequenceHelper.getKeyTypesTableName(), "seq_types_init").execute();
                        }
                        catch (Throwable throwable) {
                            if (SequenceServiceJdbiImpl.this.typeHelper.isDuplicateKeyException(throwable)) break block4;
                            throw Throwables.propagate((Throwable)throwable);
                        }
                    }
                    try {
                        JDBIHelper.getBoundStatement(handle, SequenceServiceJdbiImpl.this.sequenceHelper.getDbPrefix(), "sequence_table_name", SequenceServiceJdbiImpl.this.sequenceHelper.getSequenceTableName(), "seq_seq_init").execute();
                    }
                    catch (Throwable throwable) {
                        if (SequenceServiceJdbiImpl.this.typeHelper.isDuplicateKeyException(throwable)) break block5;
                        throw Throwables.propagate((Throwable)throwable);
                    }
                }
                return null;
            }
        });
        this.availabilityManager.setAvailable(true);
        this.log.debug("Initialized Sequence Service {}", (Object)this);
    }

    public synchronized void shutdown() {
        this.log.debug("Shutting down Sequence Service {}", (Object)this);
        this.availabilityManager.assertAvailable();
        this.availabilityManager.setAvailable(false);
        this.dataSource.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                for (Counter counter : SequenceServiceJdbiImpl.this.counters.values()) {
                    SequenceServiceJdbiImpl.this.sequenceHelper.setNextId(handle, counter.typeId, counter.base + counter.offset.get());
                }
                return null;
            }
        });
        this.log.debug("Shut down Sequence Service {}", (Object)this);
    }

    public synchronized void bumpKey(String string, long l) throws Exception {
        Counter counter = this.counters.get(string);
        if (counter == null) {
            this.nextKey(string);
        }
        this.counters.get(string).bumpKey(l);
    }

    @Override
    public synchronized Key nextKey(String string) throws KazukiException {
        Key key;
        if (string == null) {
            throw new IllegalArgumentException("Invalid entity 'type'");
        }
        Counter counter = this.counters.get(string);
        if (counter == null) {
            counter = this.createCounter(string);
            this.counters.put(string, counter);
        }
        if ((key = counter.getNext()) == null) {
            counter = this.createCounter(string);
            this.counters.put(string, counter);
            key = counter.getNext();
        }
        return key;
    }

    @Override
    public synchronized ResolvedKey resolveKey(Key key) throws KazukiException {
        Integer n = this.getTypeId(key.getTypePart(), false);
        if (n == null) {
            throw new IllegalArgumentException("Invalid entity 'type'");
        }
        KeyImpl keyImpl = (KeyImpl)key;
        return new ResolvedKey(n, 0L, keyImpl.getInternalId());
    }

    @Override
    public synchronized Key unresolveKey(ResolvedKey resolvedKey) throws KazukiException {
        return KeyImpl.createInternal(this.getTypeName(resolvedKey.getTypeTag()), resolvedKey.getIdentifierLo());
    }

    @Nullable
    public synchronized Key peekKey(String string) throws KazukiException {
        Counter counter = this.counters.get(string);
        if (counter == null) {
            return null;
        }
        return counter.peekNext();
    }

    @Override
    public synchronized Integer getTypeId(final String string, final boolean bl) throws KazukiException {
        if (string == null) {
            throw new IllegalArgumentException("Invalid entity 'type'");
        }
        if (this.typeCodes.containsKey(string)) {
            return this.typeCodes.get(string);
        }
        this.availabilityManager.assertAvailable();
        Integer n = (Integer)this.dataSource.inTransaction((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                return SequenceServiceJdbiImpl.this.sequenceHelper.validateType(handle, SequenceServiceJdbiImpl.this.typeCodes, SequenceServiceJdbiImpl.this.typeNames, string, bl);
            }
        });
        return n;
    }

    @Override
    public synchronized String getTypeName(final Integer n) throws KazukiException {
        if (this.typeNames.containsKey(n)) {
            return this.typeNames.get(n);
        }
        this.availabilityManager.assertAvailable();
        return (String)this.dataSource.inTransaction((TransactionCallback)new TransactionCallback<String>(){

            public String inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                try {
                    return SequenceServiceJdbiImpl.this.sequenceHelper.getTypeName(handle, SequenceServiceJdbiImpl.this.typeNames, n);
                }
                catch (KazukiException kazukiException) {
                    return null;
                }
            }
        });
    }

    @Override
    public synchronized void clear(final boolean bl, final boolean bl2) {
        this.log.debug("Clearing SequenceService {}", (Object)this);
        this.availabilityManager.doProtected(new AvailabilityManager.ProtectedCommand<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute(Releasable releasable) throws Exception {
                try {
                    if (!bl) {
                        SequenceServiceJdbiImpl.this.typeCodes.clear();
                        SequenceServiceJdbiImpl.this.typeNames.clear();
                    }
                    if (!bl2) {
                        SequenceServiceJdbiImpl.this.counters.clear();
                    }
                    SequenceServiceJdbiImpl.this.dataSource.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

                        public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                            if (!bl2) {
                                SequenceServiceJdbiImpl.this.log.debug("Truncating SequenceService {} table {}", (Object)this, (Object)SequenceServiceJdbiImpl.this.sequenceHelper.getSequenceTableName());
                                JDBIHelper.getBoundStatement(handle, SequenceServiceJdbiImpl.this.sequenceHelper.getDbPrefix(), "sequence_table_name", SequenceServiceJdbiImpl.this.sequenceHelper.getSequenceTableName(), "seq_seq_truncate").execute();
                            }
                            if (!bl) {
                                SequenceServiceJdbiImpl.this.log.debug("Truncating SequenceService {} table {}", (Object)this, (Object)SequenceServiceJdbiImpl.this.sequenceHelper.getKeyTypesTableName());
                                JDBIHelper.getBoundStatement(handle, SequenceServiceJdbiImpl.this.sequenceHelper.getDbPrefix(), "key_types_table_name", SequenceServiceJdbiImpl.this.sequenceHelper.getKeyTypesTableName(), "seq_types_truncate").execute();
                            }
                            return null;
                        }
                    });
                    SequenceServiceJdbiImpl.this.initialize();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    releasable.release();
                }
            }
        });
        this.log.debug("Cleared SequenceService {}", (Object)this);
    }

    @Override
    public synchronized void resetCounter(final String string) throws KazukiException {
        final Integer n = this.getTypeId(string, false);
        this.dataSource.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                SequenceServiceJdbiImpl.this.sequenceHelper.setNextId(handle, n, 0L);
                SequenceServiceJdbiImpl.this.counters.remove(string);
                return null;
            }
        });
    }

    public Map<String, Counter> getCurrentCounters() {
        return Collections.unmodifiableMap(this.counters);
    }

    private Counter createCounter(final String string) {
        final int n = (Integer)this.dataSource.inTransaction((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                return SequenceServiceJdbiImpl.this.sequenceHelper.validateType(handle, SequenceServiceJdbiImpl.this.typeCodes, SequenceServiceJdbiImpl.this.typeNames, string, true);
            }
        });
        long l = (Long)this.dataSource.inTransaction((TransactionCallback)new TransactionCallback<Long>(){

            public Long inTransaction(Handle handle, TransactionStatus transactionStatus) throws Exception {
                return SequenceServiceJdbiImpl.this.sequenceHelper.getNextId(handle, n, SequenceServiceJdbiImpl.this.incrementBlockSize);
            }
        });
        return new Counter(n, string, l, l + this.incrementBlockSize);
    }

    public class Counter {
        private final int typeId;
        private final String type;
        private final long base;
        private final long max;
        private final AtomicLong offset = new AtomicLong();

        public Counter(int n, String string, long l, long l2) {
            this.typeId = n;
            this.type = string;
            this.base = l;
            this.max = l2;
        }

        public void bumpKey(long l) throws KazukiException {
            long l2 = this.base + this.offset.get();
            long l3 = l - l2;
            if (l3 <= 0L) {
                return;
            }
            if (l >= this.max) {
                throw new IllegalStateException("cannot move counter from " + l2 + " to desired position " + l + " past " + this.max);
            }
            this.offset.addAndGet(l3);
        }

        @Nullable
        public Key getNext() throws KazukiException {
            long l = this.base + this.offset.incrementAndGet();
            if (l <= this.max) {
                return KeyImpl.createInternal(this.type, l);
            }
            return null;
        }

        @Nullable
        public Key peekNext() throws KazukiException {
            long l = this.base + this.offset.get() + 1L;
            if (l <= this.max) {
                return KeyImpl.createInternal(this.type, l);
            }
            return null;
        }

        public String toString() {
            return "Counter[type=" + this.type + ",base=" + this.base + ",offset=" + this.offset.get() + ",max=" + this.max + "]";
        }
    }
}

