/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Scheduler;
import io.kcache.CacheLoader;
import io.kcache.utils.InMemoryCache;
import java.time.Duration;
import java.util.Comparator;
import java.util.Map;

public class CaffeineCache<K, V>
extends InMemoryCache<K, V> {
    private final Cache<K, V> cache;
    private final CacheLoader<K, V> loader;

    public CaffeineCache(Comparator<? super K> comparator) {
        this(null, null, null, comparator);
    }

    public CaffeineCache(Integer maximumSize, Duration expireAfterWrite, CacheLoader<K, V> loader) {
        this.loader = loader;
        this.cache = this.createCache(maximumSize, expireAfterWrite);
    }

    public CaffeineCache(Integer maximumSize, Duration expireAfterWrite, CacheLoader<K, V> loader, Comparator<? super K> comparator) {
        super(comparator);
        this.loader = loader;
        this.cache = this.createCache(maximumSize, expireAfterWrite);
    }

    private Cache<K, V> createCache(Integer maximumSize, Duration expireAfterWrite) {
        Caffeine caffeine = Caffeine.newBuilder().writer(new CacheWriter<K, V>(){

            public void write(K key, V value) {
                CaffeineCache.this.delegate().put(key, value);
            }

            public void delete(K key, V value, RemovalCause cause) {
                CaffeineCache.this.delegate().remove(key, value);
            }
        });
        if (maximumSize != null && maximumSize >= 0) {
            caffeine = caffeine.maximumSize((long)maximumSize.intValue());
        }
        if (expireAfterWrite != null && !expireAfterWrite.isNegative()) {
            caffeine = caffeine.scheduler(Scheduler.systemScheduler()).expireAfterWrite(expireAfterWrite);
        }
        if (this.loader != null) {
            return caffeine.build(key -> {
                Object value = this.loader.load(key);
                if (value != null) {
                    this.delegate().put(key, value);
                }
                return value;
            });
        }
        return caffeine.build();
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public V get(Object key) {
        if (this.loader != null) {
            return (V)((LoadingCache)this.cache).get(key);
        }
        return (V)super.get(key);
    }

    public V put(K key, V value) {
        V originalValue = this.get(key);
        this.cache.put(key, value);
        return originalValue;
    }

    public void putAll(Map<? extends K, ? extends V> entries) {
        this.cache.putAll(entries);
    }

    public V remove(Object key) {
        V originalValue = this.get(key);
        if (key != null) {
            this.cache.invalidate(key);
        }
        return originalValue;
    }

    public void clear() {
        this.cache.invalidateAll();
    }
}

