/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java.http;

import io.keen.client.java.KeenUtils;
import io.keen.client.java.KeenVersion;
import io.keen.client.java.http.HttpHandler;
import io.keen.client.java.http.Request;
import io.keen.client.java.http.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

public class UrlConnectionHttpHandler
implements HttpHandler {
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_READ_TIMEOUT = 30000;

    @Override
    public Response execute(Request request) throws IOException {
        HttpURLConnection connection = this.openConnection(request);
        this.sendRequest(connection, request);
        return this.readResponse(connection);
    }

    protected HttpURLConnection openConnection(Request request) throws IOException {
        HttpURLConnection result = request.proxy != null ? (HttpURLConnection)request.url.openConnection(request.proxy) : (HttpURLConnection)request.url.openConnection();
        result.setConnectTimeout(30000);
        result.setReadTimeout(30000);
        return result;
    }

    protected void sendRequest(HttpURLConnection connection, Request request) throws IOException {
        connection.setRequestMethod(request.method);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Authorization", request.authorization);
        connection.setRequestProperty("Keen-Sdk", "java-" + KeenVersion.getSdkVersion());
        if (request.body != null) {
            if ("GET".equals(request.method) || "DELETE".equals(request.method)) {
                throw new IllegalStateException("Trying to send a GET request with a request body, which would result in sending a POST.");
            }
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            request.body.writeTo(connection.getOutputStream());
        } else {
            connection.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response readResponse(HttpURLConnection connection) throws IOException {
        InputStream in;
        try {
            in = connection.getInputStream();
        }
        catch (IOException e) {
            in = connection.getErrorStream();
        }
        String body = "";
        if (in != null) {
            try {
                body = KeenUtils.convertStreamToString(in);
            }
            finally {
                KeenUtils.closeQuietly(in);
            }
        }
        return new Response(connection.getResponseCode(), body);
    }
}

