package io.keeppro

import androidx.compose.foundation.Canvas
import androidx.compose.foundation.layout.BoxScope
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp

@Composable
fun BoxScope.SudokuGrid() {
    Canvas(modifier = Modifier.matchParentSize()) {
        val gridSize = 3 // For a 3x3 grid
        val lineThickness = 2.dp.toPx()
        val cellSizeX = size.width / gridSize
        val cellSizeY = size.height / gridSize

        // Draw the grid lines
        for (i in 1 until gridSize) {
            val x = i * cellSizeX
            val y = i * cellSizeY

            // Vertical lines, stop before the last line to avoid overlapping with the right edge
            if (i < gridSize) {
                drawLine(
                    color = Color.Black,
                    start = Offset(x, 0f),
                    end = Offset(x, size.height),
                    strokeWidth = lineThickness
                )
            }

            // Horizontal lines
            drawLine(
                color = Color.Black,
                start = Offset(0f, y),
                end = Offset(size.width, y),
                strokeWidth = lineThickness
            )
        }

        // Draw the last right and bottom borders explicitly to avoid any gaps
//        drawLine(
//            color = Color.Black,
//            start = Offset(size.width, 0f),
//            end = Offset(size.width, size.height),
//            strokeWidth = lineThickness
//        )
//
//        drawLine(
//            color = Color.Black,
//            start = Offset(0f, size.height),
//            end = Offset(size.width, size.height),
//            strokeWidth = lineThickness
//        )
    }
}