/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.ksql;

import io.keploy.ksql.KConnection;
import io.keploy.regression.Mode;
import io.keploy.regression.context.Context;
import io.keploy.regression.context.Kcontext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.OracleDriver;
import org.apache.logging.log4j.LogManager;
import org.h2.Driver;

public class KDriver
implements java.sql.Driver {
    public java.sql.Driver wrappedDriver;
    public final Kcontext kctx = Context.getCtx();
    static Mode.ModeType mode = null;
    public static String DriverName = "";
    public static String Dialect = "";
    public static Mode.ModeType testMode = Mode.ModeType.MODE_TEST;
    public static Mode.ModeType recordMode = Mode.ModeType.MODE_RECORD;
    private static final org.apache.logging.log4j.Logger logger = LogManager.getLogger(KDriver.class);
    private static final String CROSS = new String(Character.toChars(10060));

    public KDriver(java.sql.Driver driver) {
        if (Objects.equals(System.getenv("KEPLOY_MODE"), "record")) {
            mode = Mode.ModeType.MODE_RECORD;
        } else if (Objects.equals(System.getenv("KEPLOY_MODE"), "test")) {
            mode = Mode.ModeType.MODE_TEST;
        }
        logger.debug("KEPLOY DRIVER INITIALIZE");
        this.wrappedDriver = driver;
    }

    public static void WrapDriver() throws SQLException {
        Enumeration<java.sql.Driver> drivers = DriverManager.getDrivers();
        ArrayList<java.sql.Driver> list = Collections.list(drivers);
        logger.debug("Number of Drivers to wrap:{}", (Object)list.size());
        for (java.sql.Driver dr : list) {
            logger.debug("wrapping and registering driver:{}", (Object)dr);
            DriverManager.deregisterDriver(dr);
            DriverManager.registerDriver(new KDriver(dr));
        }
    }

    public KDriver() throws SQLException {
        if (Objects.equals(System.getenv("KEPLOY_MODE"), "record")) {
            mode = Mode.ModeType.MODE_RECORD;
        } else if (Objects.equals(System.getenv("KEPLOY_MODE"), "test")) {
            mode = Mode.ModeType.MODE_TEST;
        }
        this.wrappedDriver = this.getWrappedDriver();
        if (Objects.equals(DriverName, "org.h2.Driver")) {
            logger.info("starting test connection for H2 ");
            mode = recordMode;
        }
    }

    private java.sql.Driver getWrappedDriver() throws SQLException {
        org.postgresql.Driver d;
        String driver;
        switch (driver = DriverName) {
            case "org.postgresql.Driver": {
                d = new org.postgresql.Driver();
                break;
            }
            case "com.mysql.cj.jdbc.Driver": {
                d = new com.mysql.cj.jdbc.Driver();
                break;
            }
            case "com.mysql.jdbc.Driver": {
                d = new com.mysql.jdbc.Driver();
                break;
            }
            case "org.h2.Driver": {
                d = new Driver();
                break;
            }
            case "oracle.jdbc.driver.OracleDriver": {
                d = new oracle.jdbc.driver.OracleDriver();
                break;
            }
            case "oracle.jdbc.OracleDriver": {
                d = new OracleDriver();
                break;
            }
            case "org.mariadb.jdbc.Driver": {
                d = new org.mariadb.jdbc.Driver();
                break;
            }
            default: {
                d = null;
            }
        }
        return d;
    }

    @Override
    public Connection connect(String url, Properties info) {
        if (mode == testMode) {
            try {
                return new KConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        Connection conn = null;
        try {
            conn = this.wrappedDriver.connect(url, info);
        }
        catch (SQLException e) {
            logger.error(CROSS + " Keploy cannot establish connection with default DB \n" + e);
        }
        return new KConnection(conn);
    }

    @Override
    public boolean acceptsURL(String url) {
        if (mode == testMode) {
            return true;
        }
        try {
            return this.wrappedDriver.acceptsURL(url);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        if (mode == testMode) {
            return 1;
        }
        return this.wrappedDriver.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        if (mode == testMode) {
            return 0;
        }
        return this.wrappedDriver.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        if (mode == testMode) {
            return true;
        }
        return this.wrappedDriver.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        if (mode == testMode) {
            return (Logger)logger;
        }
        return this.wrappedDriver.getParentLogger();
    }
}

