/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.redis.jedis;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.keploy.grpc.stubs.Service;
import io.keploy.redis.jedis.RedisCustomSerializer;
import io.keploy.regression.KeployInstance;
import io.keploy.regression.Mock;
import io.keploy.regression.Mode;
import io.keploy.regression.context.Context;
import io.keploy.regression.context.Kcontext;
import java.lang.reflect.Type;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.util.SafeEncoder;

public class KConnection
extends Connection {
    static final Logger logger = LoggerFactory.getLogger(KConnection.class);
    private final Mode.ModeType keployMode = Context.getCtx().getMode().getModeFromContext();
    private Map<String, String> meta = new HashMap<String, String>(){
        {
            this.put("name", "redis");
            this.put("type", "NoSqlDB");
        }
    };
    private static final RedisCustomSerializer redisCustomSerializer = new RedisCustomSerializer();
    private static final Gson gson = new Gson();
    private static final String CROSS = new String(Character.toChars(10060));
    private static final byte[][] EMPTY_ARGS = new byte[0][];

    public KConnection() {
        if (this.keployMode == Mode.ModeType.MODE_TEST) {
            this.fillMock();
        }
    }

    public KConnection(String host) {
        super(host);
        if (this.keployMode == Mode.ModeType.MODE_TEST) {
            this.fillMock();
        }
    }

    public KConnection(String host, int port) {
        super(host, port);
        if (this.keployMode == Mode.ModeType.MODE_TEST) {
            this.fillMock();
        }
    }

    public KConnection(String host, int port, boolean ssl) {
        super(host, port, ssl);
        if (this.keployMode == Mode.ModeType.MODE_TEST) {
            this.fillMock();
        }
    }

    public KConnection(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        if (this.keployMode == Mode.ModeType.MODE_TEST) {
            this.fillMock();
        }
    }

    @Override
    public Socket getSocket() {
        return super.getSocket();
    }

    @Override
    public int getConnectionTimeout() {
        return super.getConnectionTimeout();
    }

    @Override
    public int getSoTimeout() {
        return super.getSoTimeout();
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        super.setConnectionTimeout(connectionTimeout);
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        super.setSoTimeout(soTimeout);
    }

    @Override
    public void setTimeoutInfinite() {
        super.setTimeoutInfinite();
    }

    @Override
    public void rollbackTimeout() {
        super.rollbackTimeout();
    }

    @Override
    protected Connection sendCommand(Protocol.Command cmd, String ... args) {
        switch (this.keployMode) {
            case MODE_RECORD: {
                this.meta.put("serializer", SerializationType.REDIS_SERIALIZATION.toString());
                this.meta.put("command", cmd.toString());
                int argCount = 1;
                for (String arg : args) {
                    this.meta.put("arg".concat(Integer.toString(argCount)), arg);
                    ++argCount;
                }
                return super.sendCommand(cmd, args);
            }
            case MODE_TEST: {
                byte[][] bargs = new byte[args.length][];
                for (int i = 0; i < args.length; ++i) {
                    bargs[i] = SafeEncoder.encode(args[i]);
                }
                return this.sendCommand(cmd, bargs);
            }
        }
        return super.sendCommand(cmd, args);
    }

    @Override
    protected Connection sendCommand(Protocol.Command cmd) {
        return this.sendCommand(cmd, EMPTY_ARGS);
    }

    @Override
    protected Connection sendCommand(Protocol.Command cmd, byte[] ... args) {
        switch (this.keployMode) {
            case MODE_RECORD: {
                if (!this.meta.containsKey("serializer") || !Objects.equals(this.meta.get("serializer"), SerializationType.REDIS_SERIALIZATION.toString())) {
                    this.meta.put("serializer", SerializationType.REDIS_CUSTOM_SERIALIZATION.toString());
                    this.meta.put("command", cmd.toString());
                    int argCount = 1;
                    for (byte[] arg : args) {
                        Object deserializedObject = redisCustomSerializer.deserialize(arg);
                        this.meta.put("arg".concat(Integer.toString(argCount)), gson.toJson(deserializedObject));
                        ++argCount;
                    }
                }
                return super.sendCommand(cmd, args);
            }
            case MODE_TEST: {
                return this;
            }
        }
        return super.sendCommand(cmd, args);
    }

    @Override
    public String getHost() {
        return super.getHost();
    }

    @Override
    public void setHost(String host) {
        super.setHost(host);
    }

    @Override
    public int getPort() {
        return super.getPort();
    }

    @Override
    public void setPort(int port) {
        super.setPort(port);
    }

    @Override
    public void connect() {
        switch (this.keployMode) {
            case MODE_TEST: {
                break;
            }
            default: {
                super.connect();
            }
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    @Override
    public void disconnect() {
        switch (this.keployMode) {
            case MODE_TEST: {
                break;
            }
            default: {
                super.disconnect();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return super.isConnected();
    }

    @Override
    public String getStatusCodeReply() {
        switch (this.keployMode) {
            case MODE_RECORD: {
                String statusCodeReply = super.getStatusCodeReply();
                this.meta.put("response", statusCodeReply);
                this.sendToServer();
                return statusCodeReply;
            }
            case MODE_TEST: {
                return this.meta.get("response");
            }
        }
        return super.getStatusCodeReply();
    }

    @Override
    public String getBulkReply() {
        switch (this.keployMode) {
            case MODE_RECORD: {
                String bulkReply = super.getBulkReply();
                this.meta.put("response", bulkReply);
                this.sendToServer();
                return bulkReply;
            }
            case MODE_TEST: {
                return this.meta.get("response");
            }
        }
        return super.getBulkReply();
    }

    @Override
    public byte[] getBinaryBulkReply() {
        switch (this.keployMode) {
            case MODE_RECORD: {
                if (Objects.equals(this.meta.get("serializer"), SerializationType.REDIS_SERIALIZATION.toString())) {
                    return super.getBinaryBulkReply();
                }
                byte[] binaryBulkReply = super.getBinaryBulkReply();
                Object deserializedObject = redisCustomSerializer.deserialize(binaryBulkReply);
                this.meta.put("response", gson.toJson(deserializedObject));
                this.sendToServer();
                return binaryBulkReply;
            }
            case MODE_TEST: {
                if (!Objects.equals(this.meta.get("serializer"), SerializationType.REDIS_SERIALIZATION.toString())) {
                    return redisCustomSerializer.serialize(gson.fromJson(this.meta.get("response"), Object.class));
                }
                return super.getBinaryBulkReply();
            }
        }
        return super.getBinaryBulkReply();
    }

    @Override
    public Long getIntegerReply() {
        switch (this.keployMode) {
            case MODE_RECORD: {
                Long integerReply = super.getIntegerReply();
                this.meta.put("response", integerReply.toString());
                this.sendToServer();
                return integerReply;
            }
            case MODE_TEST: {
                return Long.parseLong(this.meta.get("response"));
            }
        }
        return super.getIntegerReply();
    }

    @Override
    public List<String> getMultiBulkReply() {
        switch (this.keployMode) {
            case MODE_RECORD: {
                List<String> multiBulkReply = super.getMultiBulkReply();
                this.meta.put("response", multiBulkReply.toString());
                this.sendToServer();
                return multiBulkReply;
            }
            case MODE_TEST: {
                return new ArrayList<String>(Arrays.asList(this.meta.get("response").split(",")));
            }
        }
        return super.getMultiBulkReply();
    }

    @Override
    public List<byte[]> getBinaryMultiBulkReply() {
        switch (this.keployMode) {
            case MODE_RECORD: {
                if (Objects.equals(this.meta.get("serializer"), SerializationType.REDIS_SERIALIZATION.toString())) {
                    return super.getBinaryMultiBulkReply();
                }
                List<byte[]> binaryMultiBulkReply = super.getBinaryMultiBulkReply();
                ArrayList response = new ArrayList();
                for (byte[] i : binaryMultiBulkReply) {
                    Object deserializedObject = redisCustomSerializer.deserialize(i);
                    response.add(deserializedObject);
                }
                this.meta.put("response", gson.toJson(response));
                this.sendToServer();
                return binaryMultiBulkReply;
            }
            case MODE_TEST: {
                ArrayList<byte[]> response = new ArrayList<byte[]>();
                Type listOfObject = new TypeToken<List<Object>>(){}.getType();
                List lObj = (List)gson.fromJson(this.meta.get("response"), listOfObject);
                for (Object i : lObj) {
                    response.add(redisCustomSerializer.serialize(i));
                }
                return response;
            }
        }
        return super.getBinaryMultiBulkReply();
    }

    @Override
    public void resetPipelinedCount() {
        super.resetPipelinedCount();
    }

    @Override
    public List<Object> getRawObjectMultiBulkReply() {
        switch (this.keployMode) {
            case MODE_RECORD: {
                List<Object> rawObjectMultiBulkReply = super.getRawObjectMultiBulkReply();
                this.meta.put("response", gson.toJson(rawObjectMultiBulkReply));
                this.sendToServer();
                return rawObjectMultiBulkReply;
            }
            case MODE_TEST: {
                Type listOfObject = new TypeToken<List<Object>>(){}.getType();
                return (List)gson.fromJson(this.meta.get("response"), listOfObject);
            }
        }
        return super.getRawObjectMultiBulkReply();
    }

    @Override
    public List<Object> getObjectMultiBulkReply() {
        switch (this.keployMode) {
            case MODE_RECORD: {
                List<Object> objectMultiBulkReply = super.getObjectMultiBulkReply();
                this.meta.put("response", gson.toJson(objectMultiBulkReply));
                this.sendToServer();
                return objectMultiBulkReply;
            }
            case MODE_TEST: {
                Type listOfObject = new TypeToken<List<Object>>(){}.getType();
                return (List)gson.fromJson(this.meta.get("response"), listOfObject);
            }
        }
        return super.getObjectMultiBulkReply();
    }

    @Override
    public List<Long> getIntegerMultiBulkReply() {
        switch (this.keployMode) {
            case MODE_RECORD: {
                List<Long> integerMultiBulkReply = super.getIntegerMultiBulkReply();
                this.meta.put("response", gson.toJson(integerMultiBulkReply));
                this.sendToServer();
                return integerMultiBulkReply;
            }
            case MODE_TEST: {
                Type listOfLong = new TypeToken<List<Long>>(){}.getType();
                return (List)gson.fromJson(this.meta.get("response"), listOfLong);
            }
        }
        return super.getIntegerMultiBulkReply();
    }

    @Override
    public List<Object> getAll() {
        switch (this.keployMode) {
            case MODE_RECORD: {
                List<Object> getAll = super.getAll();
                this.meta.put("response", gson.toJson(getAll));
                this.sendToServer();
                return getAll;
            }
            case MODE_TEST: {
                Type listOfObject = new TypeToken<List<Object>>(){}.getType();
                return (List)gson.fromJson(this.meta.get("response"), listOfObject);
            }
        }
        return super.getAll();
    }

    @Override
    public List<Object> getAll(int except) {
        switch (this.keployMode) {
            case MODE_RECORD: {
                List<Object> getAll = super.getAll(except);
                this.meta.put("response", gson.toJson(getAll));
                this.sendToServer();
                return getAll;
            }
            case MODE_TEST: {
                Type listOfObject = new TypeToken<List<Object>>(){}.getType();
                return (List)gson.fromJson(this.meta.get("response"), listOfObject);
            }
        }
        return super.getAll(except);
    }

    @Override
    public Object getOne() {
        switch (this.keployMode) {
            case MODE_RECORD: {
                Object getOne = super.getOne();
                this.meta.put("response", gson.toJson(getOne));
                this.sendToServer();
                return getOne;
            }
            case MODE_TEST: {
                return gson.fromJson(this.meta.get("response"), Object.class);
            }
        }
        return super.getOne();
    }

    @Override
    public boolean isBroken() {
        return super.isBroken();
    }

    @Override
    protected void flush() {
        super.flush();
    }

    @Override
    protected Object readProtocolWithCheckingBroken() {
        return super.readProtocolWithCheckingBroken();
    }

    private void sendToServer() {
        Kcontext kctx = Context.getCtx();
        logger.debug("meta:{}", (Object)this.meta.toString());
        if (Objects.equals(this.meta.get("command"), Protocol.Command.PING.toString()) || Objects.equals(this.meta.get("command"), Protocol.Command.QUIT.toString())) {
            return;
        }
        Service.Mock.SpecSchema specSchema = Service.Mock.SpecSchema.newBuilder().putAllMetadata(this.meta).build();
        Service.Mock redisMock = Service.Mock.newBuilder().setVersion(Mock.Version.V1_BETA1.value).setKind(Mock.Kind.GENERIC_EXPORT.value).setSpec(specSchema).build();
        kctx.getMock().add(redisMock);
    }

    private void fillMock() {
        Kcontext kctx = Context.getCtx();
        if (kctx.getMock().size() <= 0 || !kctx.getMock().get(0).getKind().equals(Mock.Kind.GENERIC_EXPORT.value)) {
            logger.error(CROSS + " mocks not present in " + KeployInstance.getInstance().getKeploy().getCfg().getApp().getMockPath() + " directory.");
            throw new RuntimeException("unable to read mocks from keploy context");
        }
        List<Service.Mock> mocks = kctx.getMock();
        this.meta = mocks.get(0).getSpec().getMetadataMap();
        mocks.remove(0);
    }

    public static enum SerializationType {
        REDIS_SERIALIZATION,
        REDIS_CUSTOM_SERIALIZATION;

    }
}

