/*
 * Decompiled with CFR 0.152.
 */
package io.keploy.servlet;

import io.grpc.netty.shaded.io.netty.util.internal.InternalThreadLocalMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.runtime.RemoteControlReader;
import org.jacoco.core.runtime.RemoteControlWriter;
import org.jacoco.core.tools.ExecFileLoader;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class KeployMiddleware
implements Filter {
    private final ExecutorService executorService = Executors.newFixedThreadPool(10);
    public static int Lines_covered = 0;
    public static int Branch_covered = 0;
    public static int Lines_total = 0;
    public static int Branch_total = 0;
    public static int Methods_covered = 0;
    public static int Methods_total = 0;
    public static int Classes_covered = 0;
    public static int Classes_total = 0;
    public static String Line_Path = "";
    private static final Logger logger = LogManager.getLogger(KeployMiddleware.class);
    private static final String CROSS = new String(Character.toChars(10060));
    public static ArrayList<String> stackTraceArr = new ArrayList();
    private static boolean EnableDedup = false;
    public static AtomicInteger metCount = new AtomicInteger(0);
    public static AtomicInteger reqCount = new AtomicInteger(0);
    public static AtomicInteger cnt = new AtomicInteger(0);
    private static final String ADDRESS = "localhost";
    private static final int PORT = 36320;
    private static final String SET_PLAIN_TEXT = "\u001b[0;0m";
    private static final String SET_BOLD_TEXT = "\u001b[0;1m";

    public void init(FilterConfig filterConfig) {
        logger.debug("Keploy Middleware initialized");
    }

    private static String bold(String str) {
        return SET_BOLD_TEXT + str + SET_PLAIN_TEXT;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String keploy_test_id = request.getHeader("KEPLOY-TEST-ID");
        String keploy_test_set_id = request.getHeader("KEPLOY-TEST-SET-ID");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (System.getenv("ENABLE_DEDUP") != null) {
            String bool = System.getenv("ENABLE_DEDUP").trim();
            EnableDedup = bool.equals("true");
        }
        if (keploy_test_id != null && EnableDedup) {
            try {
                this.getCoverage(keploy_test_id, keploy_test_set_id);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void destroy() {
        InternalThreadLocalMap.destroy();
    }

    public void execWriter(String keploy_test_id) throws IOException {
        File directory = new File(System.getProperty("user.dir") + "/target");
        File file = new File(directory, "jacoco-client" + keploy_test_id + ".exec");
        FileOutputStream localFile = new FileOutputStream(file);
        ExecutionDataWriter localWriter = new ExecutionDataWriter(localFile);
        Socket socket = new Socket(InetAddress.getByName(ADDRESS), 36320);
        RemoteControlWriter writer = new RemoteControlWriter(socket.getOutputStream());
        RemoteControlReader reader = new RemoteControlReader(socket.getInputStream());
        reader.setSessionInfoVisitor(localWriter);
        reader.setExecutionDataVisitor(localWriter);
        writer.visitDumpCommand(true, true);
        if (!reader.read()) {
            throw new IOException("Socket closed unexpectedly.");
        }
        socket.close();
        localFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execWriter2(String keploy_test_id) throws IOException {
        File directory = new File(System.getProperty("user.dir") + "/target");
        File file = new File(directory, "jacoco-client" + keploy_test_id + ".exec");
        FileOutputStream localFile = null;
        ExecutionDataWriter localWriter = null;
        Socket socket = null;
        RemoteControlWriter writer = null;
        RemoteControlReader reader = null;
        try {
            localFile = new FileOutputStream(file);
            BufferedOutputStream bufferedLocalFile = new BufferedOutputStream(localFile);
            localWriter = new ExecutionDataWriter(bufferedLocalFile);
            socket = new Socket(InetAddress.getByName(ADDRESS), 36320);
            writer = new RemoteControlWriter(socket.getOutputStream());
            reader = new RemoteControlReader(socket.getInputStream());
            reader.setSessionInfoVisitor(localWriter);
            reader.setExecutionDataVisitor(localWriter);
            writer.visitDumpCommand(true, true);
            if (!reader.read()) {
                throw new IOException("Socket closed unexpectedly.");
            }
        }
        finally {
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
            if (localFile != null) {
                localFile.close();
            }
        }
    }

    public void getCoverage(String keploy_test_id, String keploy_test_set_id) throws IOException, InterruptedException {
        try {
            this.execWriter(keploy_test_id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.execReader(keploy_test_id, keploy_test_set_id);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void shutdownExecutor() {
        this.executorService.shutdown();
    }

    private void execReader(String keploy_test_id, String keploy_test_set_id) throws IOException {
        System.out.println("------------------------------------------");
        Line_Path = "";
        ExecFileLoader loader = new ExecFileLoader();
        ArrayList dataList = new ArrayList();
        File coverageFile = new File(System.getProperty("user.dir") + "/target/jacoco-client" + keploy_test_id + ".exec");
        loader.load(coverageFile);
        File binDir = new File(System.getProperty("user.dir") + "/target/classes");
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(loader.getExecutionDataStore(), coverageBuilder);
        analyzer.analyzeAll(binDir);
        boolean x = false;
        HashMap executedLinesByFile = new HashMap();
        for (IClassCoverage cc : coverageBuilder.getClasses()) {
            String ClassName2 = cc.getName();
            Collection<IMethodCoverage> method = cc.getMethods();
            cc.getInstructionCounter().getTotalCount();
            ArrayList<Integer> ls = new ArrayList<Integer>();
            for (int i = cc.getFirstLine(); i <= cc.getLastLine(); ++i) {
                if (!this.getColor(cc.getLine(i).getStatus()).equals("green")) continue;
                Line_Path = Line_Path + ClassName2 + i + ",";
                ls.add(i);
            }
            if (ls.size() == 0) continue;
            executedLinesByFile.put(ClassName2, ls);
        }
        HashMap<String, Object> testData = new HashMap<String, Object>();
        testData.put("id", keploy_test_set_id + "/" + keploy_test_id);
        testData.put("executedLinesByFile", executedLinesByFile);
        dataList.add(testData);
        List<Map<String, Object>> existingData = KeployMiddleware.readYamlFile("dedupData.yaml");
        existingData.addAll(dataList);
        KeployMiddleware.writeYamlFile(existingData, "dedupData.yaml");
    }

    private void printCounter(String unit, ICounter counter) {
        Integer missed = counter.getMissedCount();
        Integer total = counter.getTotalCount();
        System.out.printf("%s of %s %s missed%n", missed, total, unit);
        Lines_covered = total - missed;
        Lines_total = total;
    }

    private String getColor(int status) {
        switch (status) {
            case 1: {
                return "red";
            }
            case 3: {
                return "yellow";
            }
            case 2: {
                return "green";
            }
        }
        return "";
    }

    private static List<Map<String, Object>> readYamlFile(String fileName) {
        List existingData = new ArrayList();
        try (FileInputStream input = new FileInputStream(fileName);
             UnicodeReader reader = new UnicodeReader(input);){
            Yaml yaml = new Yaml();
            existingData = (List)yaml.load(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return existingData != null ? existingData : new ArrayList();
    }

    public static String base64Encode(String input) {
        byte[] encodedBytes = Base64.getEncoder().encode(input.getBytes());
        return new String(encodedBytes);
    }

    private static void writeYamlFile(List<Map<String, Object>> dataList, String fileName) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        try (FileWriter writer = new FileWriter(fileName);){
            yaml.dump(dataList, writer);
            System.out.println("Dedup YAML file updated successfully:- " + fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

