/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.agent;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.btrace.agent.ClientContext;
import org.openjdk.btrace.agent.RemoteClient;
import org.openjdk.btrace.agent.TraceOutputWriter;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.SharedSettings;
import org.openjdk.btrace.core.comm.Command;
import org.openjdk.btrace.core.comm.CommandListener;
import org.openjdk.btrace.core.comm.ErrorCommand;
import org.openjdk.btrace.core.comm.ExitCommand;
import org.openjdk.btrace.core.comm.InstrumentCommand;
import org.openjdk.btrace.core.comm.MessageCommand;
import org.openjdk.btrace.core.comm.RenameCommand;
import org.openjdk.btrace.core.comm.RetransformationStartNotification;
import org.openjdk.btrace.core.comm.StatusCommand;
import org.openjdk.btrace.instr.BTraceProbe;
import org.openjdk.btrace.instr.BTraceProbeFactory;
import org.openjdk.btrace.instr.BTraceProbePersisted;
import org.openjdk.btrace.instr.BTraceTransformer;
import org.openjdk.btrace.instr.ClassCache;
import org.openjdk.btrace.instr.ClassFilter;
import org.openjdk.btrace.instr.ClassInfo;
import org.openjdk.btrace.instr.HandlerRepositoryImpl;
import org.openjdk.btrace.instr.InstrumentUtils;
import org.openjdk.btrace.instr.Instrumentor;
import org.openjdk.btrace.instr.templates.impl.MethodTrackingExpander;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassReader;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassWriter;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;
import org.openjdk.btrace.runtime.BTraceRuntimeAccess;
import org.openjdk.btrace.runtime.BTraceRuntimes;

abstract class Client
implements CommandListener {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private static final Map<UUID, Client> CLIENTS = new ConcurrentHashMap<UUID, Client>();
    private static final Map<String, PrintWriter> WRITER_MAP = new HashMap<String, PrintWriter>();
    private static final Pattern SYSPROP_PTN = Pattern.compile("\\$\\{(.+?)}");
    private final Instrumentation inst;
    final SharedSettings settings;
    final ArgsMap argsMap;
    private final BTraceTransformer transformer;
    volatile PrintWriter out;
    private volatile BTraceRuntime.Impl runtime;
    private volatile String outputName;
    private BTraceProbe probe;
    private Timer flusher;
    private volatile boolean initialized = false;
    private volatile boolean shuttingDown = false;
    final UUID id = UUID.randomUUID();

    Client(ClientContext ctx) {
        this(ctx.getInstr(), ctx.getArguments(), ctx.getSettings(), ctx.getTransformer());
    }

    private Client(Instrumentation inst, ArgsMap argsMap, SharedSettings s2, BTraceTransformer t) {
        this.inst = inst;
        this.argsMap = argsMap;
        this.settings = s2 != null ? s2 : SharedSettings.GLOBAL;
        this.transformer = t;
        this.setupWriter();
        CLIENTS.put(this.id, this);
    }

    private static String pid() {
        String[] parts;
        String pName = ManagementFactory.getRuntimeMXBean().getName();
        if (pName != null && pName.length() > 0 && (parts = pName.split("@")).length == 2) {
            return parts[0];
        }
        return "-1";
    }

    protected final void initialize() {
        this.initialized = true;
    }

    private final void setupWriter() {
        String outputFile = this.settings.getOutputFile();
        if (outputFile == null || outputFile.equals("::null") || outputFile.equals("/dev/null")) {
            return;
        }
        if (!outputFile.equals("::stdout")) {
            String outputDir = this.settings.getScriptDir();
            String output = (outputDir != null ? outputDir + File.separator : "") + outputFile;
            outputFile = this.templateOutputFileName(output);
            log.info("Redirecting output to {}", (Object)outputFile);
        }
        this.out = WRITER_MAP.get(outputFile);
        if (this.out == null) {
            this.out = outputFile.equals("::stdout") ? new PrintWriter(System.out) : (this.settings.getFileRollMilliseconds() > 0 ? new PrintWriter(new BufferedWriter(TraceOutputWriter.rollingFileWriter(new File(outputFile), this.settings))) : new PrintWriter(new BufferedWriter(TraceOutputWriter.fileWriter(new File(outputFile)))));
            WRITER_MAP.put(outputFile, this.out);
            this.out.append("### BTrace Log: ").append(DateFormat.getInstance().format(new Date())).append("\n\n");
            this.startFlusher();
        }
        this.outputName = outputFile;
    }

    private void startFlusher() {
        int flushInterval;
        String flushIntervalStr = System.getProperty("org.openjdk.btrace.FileClient.flush");
        if (flushIntervalStr == null) {
            flushIntervalStr = System.getProperty("com.sun.btrace.FileClient.flush", "5");
        }
        try {
            flushInterval = Integer.parseInt(flushIntervalStr);
        }
        catch (NumberFormatException e) {
            flushInterval = 5;
        }
        int flushSec = flushInterval;
        if (flushSec > -1) {
            this.flusher = new Timer("BTrace FileClient Flusher", true);
            this.flusher.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    block6: {
                        try {
                            if (Client.this.out == null) break block6;
                            boolean entered = BTraceRuntime.enter();
                            try {
                                Client.this.out.flush();
                            }
                            finally {
                                if (entered) {
                                    BTraceRuntime.leave();
                                }
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }, flushSec, (long)flushSec);
        } else {
            this.flusher = null;
        }
    }

    private String templateOutputFileName(String fName) {
        if (fName != null) {
            boolean dflt = fName.contains("[default]");
            String agentName = System.getProperty("btrace.agent", "default");
            String clientName = this.settings.getClientName();
            fName = fName.replace("${client}", clientName != null ? clientName : "").replace("${ts}", String.valueOf(System.currentTimeMillis())).replace("${pid}", Client.pid()).replace("${agent}", agentName != null ? "." + agentName : "").replace("[default]", "");
            fName = this.replaceSysProps(fName);
            if (dflt && log.isDebugEnabled()) {
                log.debug("scriptOutputFile not specified. defaulting to {}", (Object)fName);
            }
        }
        return fName;
    }

    private String replaceSysProps(String str) {
        int replaced = 0;
        do {
            StringBuffer sb = new StringBuffer();
            replaced = this.replaceSysProps(str, sb);
            str = sb.toString();
        } while (replaced > 0);
        return str;
    }

    private int replaceSysProps(String str, StringBuffer sb) {
        int cnt = 0;
        Matcher m3 = SYSPROP_PTN.matcher(str);
        while (m3.find()) {
            String key = m3.group(1);
            String val = System.getProperty(key);
            if (val != null) {
                ++cnt;
                m3.appendReplacement(sb, val);
                continue;
            }
            m3.appendReplacement(sb, m3.group(0));
        }
        m3.appendTail(sb);
        return cnt;
    }

    static Collection<String> listProbes() {
        ArrayList<String> probes = new ArrayList<String>(CLIENTS.size());
        for (Client client : CLIENTS.values()) {
            if (!(client instanceof RemoteClient) || !((RemoteClient)client).isDisconnected()) continue;
            probes.add(client.id + " [" + client.getClassName() + "]");
        }
        return probes;
    }

    synchronized void onExit(int exitCode) {
        if (!this.shuttingDown) {
            this.shuttingDown = true;
            if (this.out != null) {
                this.out.flush();
            }
            BTraceRuntime.leave();
            try {
                log.debug("onExit:");
                log.debug("cleaning up transformers");
                this.cleanupTransformers();
                log.debug("removing instrumentation");
                this.retransformLoaded();
                log.debug("closing all I/O");
                Thread.sleep(300L);
                try {
                    this.closeAll();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                log.debug("done");
            }
            catch (Throwable th) {
                if (!th.getClass().getName().equals("ExitException")) {
                    log.debug("Failed to gracefully exit BTrace probe", th);
                    BTraceRuntime.handleException(th);
                }
            }
            finally {
                this.runtime.shutdownCmdLine();
                CLIENTS.remove(this.id);
                HandlerRepositoryImpl.unregisterProbe(this.probe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Class<?> loadClass(InstrumentCommand instr) throws IOException {
        ArgsMap args = instr.getArguments();
        byte[] btraceCode = instr.getCode();
        try {
            this.probe = this.load(btraceCode, ArgsMap.merge(this.argsMap, args));
            if (this.probe == null) {
                log.debug("Failed to load BTrace probe code");
                return null;
            }
            if (!this.settings.isTrusted()) {
                this.probe.checkVerified();
            }
        }
        catch (Throwable th) {
            log.debug("Filed to load BTrace probe code", th);
            this.errorExit(th);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("creating BTraceRuntime instance for {}", (Object)this.probe.getClassName());
        }
        this.runtime = BTraceRuntimes.getRuntime(this.probe.getClassName(), args, this, this.inst);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.runtime != null) {
                this.runtime.handleExit(0);
            }
        }));
        if (this.probe.isClassRenamed()) {
            if (log.isDebugEnabled()) {
                log.debug("class renamed to {}", (Object)this.probe.getClassName());
            }
            this.sendCommand(new RenameCommand(this.probe.getClassName()));
        }
        if (log.isDebugEnabled()) {
            log.debug("created BTraceRuntime instance for {}", (Object)this.probe.getClassName());
            log.debug("sending Okay command");
        }
        this.sendCommand(new StatusCommand());
        boolean entered = false;
        try {
            entered = BTraceRuntimeAccess.enter(this.runtime);
            Class<?> clazz = this.probe.register(this.runtime, this.transformer);
            return clazz;
        }
        catch (Throwable th) {
            log.debug("Failed to load BTrace probe", th);
            this.errorExit(th);
            Class<?> clazz = null;
            return clazz;
        }
        finally {
            if (entered) {
                BTraceRuntime.leave();
            }
        }
    }

    protected void closeAll() throws IOException {
        if (this.flusher != null) {
            this.flusher.cancel();
        }
        if (this.out != null) {
            this.out.close();
        }
        WRITER_MAP.remove(this.outputName);
    }

    private void errorExit(Throwable th) throws IOException {
        log.debug("sending error command");
        this.sendCommand(new ErrorCommand(th));
        log.debug("sending exit command");
        this.sendCommand(new ExitCommand(1));
        this.closeAll();
    }

    private void cleanupTransformers() {
        if (this.probe != null) {
            this.probe.unregister();
        }
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    final BTraceRuntime.Impl getRuntime() {
        return this.runtime;
    }

    final String getClassName() {
        return this.probe != null ? this.probe.getClassName() : "<unknown>";
    }

    private final boolean isCandidate(Class<?> c) {
        String cname = c.getName().replace('.', '/');
        if (c.isInterface() || c.isPrimitive() || c.isArray()) {
            return false;
        }
        if (ClassFilter.isSensitiveClass(cname)) {
            return false;
        }
        return this.probe.willInstrument(c);
    }

    private final void startRetransformClasses(int numClasses) {
        this.sendCommand(new RetransformationStartNotification(numClasses));
        if (log.isDebugEnabled()) {
            log.debug("calling retransformClasses ({} classes to be retransformed)", (Object)numClasses);
        }
    }

    final void endRetransformClasses() {
        this.sendCommand(new StatusCommand());
        log.debug("finished retransformClasses");
    }

    private BTraceProbe load(byte[] buf, ArgsMap args) {
        BTraceProbeFactory f = new BTraceProbeFactory(this.settings);
        log.debug("loading BTrace class");
        BTraceProbe cn = f.createProbe(buf, args);
        if (cn != null) {
            if (cn.isVerified()) {
                if (log.isDebugEnabled()) {
                    log.debug("loaded '{}' successfully", (Object)cn.getClassName());
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("{} failed verification", (Object)cn.getClassName());
                }
                return null;
            }
        }
        return BTraceProbePersisted.from(cn);
    }

    boolean retransformLoaded() throws UnmodifiableClassException {
        block14: {
            if (this.runtime == null) {
                return false;
            }
            if (!this.probe.isTransforming() || !this.settings.isRetransformStartup()) break block14;
            ArrayList<Class> list = new ArrayList<Class>();
            log.debug("retransforming loaded classes");
            log.debug("filtering loaded classes");
            ClassCache cc = ClassCache.getInstance();
            for (Class c : this.inst.getAllLoadedClasses()) {
                if (c == null || !this.inst.isModifiableClass(c) || !this.isCandidate(c)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("candidate {} added", (Object)c);
                }
                list.add(c);
            }
            list.trimToSize();
            int size = list.size();
            if (size > 0) {
                Class[] classes = new Class[size];
                list.toArray(classes);
                this.startRetransformClasses(size);
                if (log.isDebugEnabled()) {
                    for (Class c : classes) {
                        try {
                            log.debug("Attempting to retransform class: {}", (Object)c.getName());
                            this.inst.retransformClasses(c);
                        }
                        catch (ClassFormatError | VerifyError e) {
                            log.debug("Class '{}' verification failed", (Object)c.getName(), (Object)e);
                            this.sendCommand(new MessageCommand("[BTRACE WARN] Class verification failed: " + c.getName() + " (" + e.getMessage() + ")"));
                        }
                    }
                } else {
                    try {
                        this.inst.retransformClasses(classes);
                    }
                    catch (ClassFormatError | VerifyError e) {
                        for (Class c : classes) {
                            try {
                                this.inst.retransformClasses(c);
                            }
                            catch (ClassFormatError | VerifyError e1) {
                                log.debug("Class '{}' verification failed", (Object)c.getName(), (Object)e);
                                this.sendCommand(new MessageCommand("[BTRACE WARN] Class verification failed: " + c.getName() + " (" + e.getMessage() + ")"));
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    protected void sendCommand(Command command) {
        this.runtime.send(command);
    }

    static Client findClient(String uuid) {
        try {
            UUID id = UUID.fromString(uuid);
            return CLIENTS.get(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return "BTrace Client: " + this.id + "[" + this.probe.getClassName() + "]";
    }

    static {
        ClassFilter.class.getClassLoader();
        InstrumentUtils.class.getClassLoader();
        Instrumentor.class.getClassLoader();
        ClassReader.class.getClassLoader();
        ClassWriter.class.getClassLoader();
        Annotation.class.getClassLoader();
        MethodTrackingExpander.class.getClassLoader();
        ClassCache.class.getClassLoader();
        ClassInfo.class.getClassLoader();
    }
}

