/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.agent;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.openjdk.btrace.agent.Client;
import org.openjdk.btrace.agent.ClientContext;
import org.openjdk.btrace.agent.FileClient;
import org.openjdk.btrace.agent.RemoteClient;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.DebugSupport;
import org.openjdk.btrace.core.Messages;
import org.openjdk.btrace.core.SharedSettings;
import org.openjdk.btrace.core.comm.ErrorCommand;
import org.openjdk.btrace.core.comm.StatusCommand;
import org.openjdk.btrace.instr.BTraceProbeFactory;
import org.openjdk.btrace.instr.BTraceTransformer;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;
import org.openjdk.btrace.runtime.BTraceRuntimes;

public final class Main {
    public static final int BTRACE_DEFAULT_PORT = 2020;
    private static final Pattern KV_PATTERN = Pattern.compile(",");
    private static final SharedSettings settings = SharedSettings.GLOBAL;
    private static final BTraceTransformer transformer = new BTraceTransformer(new DebugSupport(settings));
    private static final ThreadFactory qProcessorThreadFactory = r -> {
        Thread result = new Thread(r, "BTrace Command Queue Processor");
        result.setDaemon(true);
        return result;
    };
    private static final ExecutorService serializedExecutor = Executors.newSingleThreadExecutor(qProcessorThreadFactory);
    private static final long ts = System.nanoTime();
    private static volatile ArgsMap argMap;
    private static volatile Instrumentation inst;
    private static volatile Long fileRollMilliseconds;
    private static final Logger log;

    public static void premain(String args, Instrumentation inst) {
        Main.main(args, inst);
    }

    public static void agentmain(String args, Instrumentation inst) {
        Main.main(args, inst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void main(String args, Instrumentation inst) {
        if (Main.inst != null) {
            return;
        }
        Main.inst = inst;
        try {
            boolean noServer;
            Main.loadArgs(args);
            boolean isDebug = Boolean.parseBoolean(argMap.get("debug"));
            settings.setDebug(isDebug);
            DebugSupport.initLoggers(isDebug, log);
            log.debug("parsed command line arguments");
            Main.parseArgs();
            DebugSupport.initLoggers(settings.isDebug(), log);
            log.debug("Adding class transformer");
            inst.addTransformer(transformer, true);
            int startedScripts = Main.startScripts();
            String tmp = argMap.get("noServer");
            boolean bl = noServer = tmp != null ? Boolean.parseBoolean(tmp) : Main.hasScripts();
            if (noServer) {
                log.debug("noServer is true, server not started");
                return;
            }
            Thread agentThread = new Thread(() -> {
                BTraceRuntime.enter();
                try {
                    Main.startServer();
                }
                finally {
                    BTraceRuntime.leave();
                }
            });
            BTraceRuntimes.getDefault();
            BTraceRuntime.initUnsafe();
            BTraceRuntime.enter();
            try {
                agentThread.setDaemon(true);
                log.debug("starting agent thread");
                agentThread.start();
            }
            finally {
                BTraceRuntime.leave();
            }
        }
        finally {
            log.debug("Agent init took: {}", (Object)(System.nanoTime() - ts + "ns"));
        }
    }

    private static boolean hasScripts() {
        return argMap.containsKey("script") || argMap.containsKey("scriptdir");
    }

    private static void loadDefaultArguments(String config) {
        block25: {
            try {
                String propTarget = "META-INF/btrace/agent.properties";
                InputStream is = ClassLoader.getSystemResourceAsStream(propTarget);
                if (is != null) {
                    Properties ps = new Properties();
                    ps.load(is);
                    StringBuilder logMsg = new StringBuilder();
                    block14: for (Map.Entry<Object, Object> entry : ps.entrySet()) {
                        String keyConfig = "";
                        String argKey = (String)entry.getKey();
                        int configPos = argKey.lastIndexOf(35);
                        if (configPos > -1) {
                            keyConfig = argKey.substring(0, configPos);
                            argKey = argKey.substring(configPos + 1);
                        }
                        if (config != null && !keyConfig.isEmpty() && !config.equals(keyConfig)) continue;
                        String argVal = (String)entry.getValue();
                        switch (argKey) {
                            case "script": {
                                boolean replace = false;
                                String scriptVal = argVal;
                                if (scriptVal.startsWith("!")) {
                                    scriptVal = scriptVal.substring(1);
                                    replace = true;
                                } else {
                                    String oldVal = argMap.get(argKey);
                                    if (oldVal != null && !oldVal.isEmpty()) {
                                        scriptVal = oldVal + ":" + scriptVal;
                                    } else {
                                        replace = true;
                                    }
                                }
                                if (replace) {
                                    logMsg.append("setting default agent argument '").append(argKey).append("' to '").append(scriptVal).append("'\n");
                                } else {
                                    logMsg.append("augmenting default agent argument '").append(argKey).append("':'").append(argMap.get(argKey)).append("' with '").append(argVal).append("'\n");
                                }
                                argMap.put(argKey, scriptVal);
                                continue block14;
                            }
                            case "allowedCalls": {
                                if (Boolean.parseBoolean(argMap.get(argKey))) {
                                    String oldVal = argMap.get(argKey);
                                    String newVal = oldVal + "|" + argVal;
                                    logMsg.append("merging default agent argument '").append(argKey).append("':'").append(oldVal).append("' with '").append(argVal).append("'");
                                    argMap.put(argKey, newVal);
                                    continue block14;
                                }
                                logMsg.append("argument '").append(argKey).append("' is applicable only in sandboxed mode");
                                continue block14;
                            }
                            case "systemClassPath": 
                            case "bootClassPath": 
                            case "config": {
                                logMsg.append("argument '").append(argKey).append("' is not overridable\n");
                                continue block14;
                            }
                        }
                        if (argMap.containsKey(argKey)) continue;
                        logMsg.append("applying default agent argument '").append(argKey).append("'='").append(argVal).append("'\n");
                        argMap.put(argKey, argVal);
                    }
                    DebugSupport.initLoggers(Boolean.parseBoolean(argMap.get("debug")), log);
                    if (log.isDebugEnabled()) {
                        log.debug(logMsg.toString());
                    }
                }
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block25;
                log.debug(e.toString(), e);
            }
        }
    }

    private static int startScripts() {
        boolean traceToStdOut;
        int scriptCount = 0;
        String p = argMap.get("stdout");
        boolean bl = traceToStdOut = p != null && !"false".equals(p);
        if (log.isDebugEnabled()) {
            log.debug("stdout is {}", (Object)traceToStdOut);
        }
        List<String> scripts = Main.locateScripts(argMap);
        for (String script : scripts) {
            if (!Main.loadBTraceScript(script, traceToStdOut)) continue;
            ++scriptCount;
        }
        return scriptCount;
    }

    static List<String> locateScripts(ArgsMap argsMap) {
        File dir;
        String script = argsMap.get("script");
        String scriptDir = argsMap.get("scriptdir");
        ArrayList<String> scripts = new ArrayList<String>();
        if (script != null) {
            StringTokenizer tokenizer = new StringTokenizer(script, ":");
            if (log.isDebugEnabled()) {
                log.debug(tokenizer.countTokens() == 1 ? "initial script is {}" : "initial scripts are {}", (Object)script);
            }
            while (tokenizer.hasMoreTokens()) {
                scripts.add(tokenizer.nextToken());
            }
        }
        if (scriptDir != null && (dir = new File(scriptDir)).isDirectory()) {
            File[] files;
            if (log.isDebugEnabled()) {
                log.debug("found scriptdir: {}", (Object)dir.getAbsolutePath());
            }
            if ((files = dir.listFiles()) != null) {
                for (File file : files) {
                    scripts.add(file.getAbsolutePath());
                }
            }
        }
        return scripts;
    }

    private static void usage() {
        System.out.println(Messages.get("btrace.agent.usage"));
        System.exit(0);
    }

    private static void loadArgs(String args) {
        if (args == null) {
            args = "";
        }
        String[] pairs = KV_PATTERN.split(args);
        argMap = new ArgsMap();
        for (String s2 : pairs) {
            String key;
            int i = s2.indexOf(61);
            String value = "";
            if (i != -1) {
                key = s2.substring(0, i).trim();
                if (i + 1 < s2.length()) {
                    value = s2.substring(i + 1).trim();
                }
            } else {
                key = s2;
            }
            argMap.put(key, value);
        }
    }

    private static void parseArgs() {
        String p = argMap.get("help");
        if (p != null) {
            Main.usage();
        }
        String libs = argMap.get("libs");
        String config = argMap.get("config");
        Main.loadDefaultArguments(config);
        Main.processClasspaths(libs);
        p = argMap.get("debug");
        settings.setDebug(p != null && !"false".equals(p));
        DebugSupport.initLoggers(settings.isDebug(), log);
        log.debug("debugMode is {}", (Object)settings.isDebug());
        block34: for (Map.Entry<String, String> e : argMap) {
            String key = e.getKey();
            p = e.getValue();
            switch (key) {
                case "startupRetransform": {
                    if (p.isEmpty()) continue block34;
                    settings.setRetransformStartup(Boolean.parseBoolean(p));
                    log.debug("startupRetransform is {}", (Object)settings.isRetransformStartup());
                    break;
                }
                case "dumpDir": {
                    String dumpClassesVal = argMap.get("dumpClasses");
                    if (dumpClassesVal == null) continue block34;
                    boolean dumpClasses = Boolean.parseBoolean(dumpClassesVal);
                    log.debug("dumpClasses is {}", (Object)dumpClasses);
                    if (!dumpClasses) continue block34;
                    String dumpDir = argMap.get("dumpDir");
                    settings.setDumpDir(dumpDir != null ? dumpDir : ".");
                    if (!Main.isDebug()) continue block34;
                    log.debug("dumpDir is {}", (Object)dumpDir);
                    break;
                }
                case "cmdQueueLimit": {
                    if (p.isEmpty()) continue block34;
                    System.setProperty("org.openjdk.btrace.core.cmdQueueLimit", p);
                    log.debug("cmdQueueLimit provided: {}", (Object)p);
                    break;
                }
                case "trackRetransforms": {
                    if (p.isEmpty()) continue block34;
                    settings.setTrackRetransforms(Boolean.parseBoolean(p));
                    if (!settings.isTrackRetransforms()) continue block34;
                    log.debug("trackRetransforms is on");
                    break;
                }
                case "scriptOutputFile": {
                    if (p.isEmpty()) continue block34;
                    settings.setOutputFile(p);
                    log.debug("scriptOutputFile is {}", (Object)p);
                    break;
                }
                case "scriptOutputDir": {
                    if (p.isEmpty()) continue block34;
                    settings.setScriptOutputDir(p);
                    log.debug("scriptOutputDir is {}", (Object)p);
                    break;
                }
                case "fileRollMilliseconds": {
                    if (p.isEmpty()) continue block34;
                    Long msParsed = null;
                    try {
                        fileRollMilliseconds = msParsed = Long.valueOf(Long.parseLong(p));
                    }
                    catch (NumberFormatException nfe) {
                        fileRollMilliseconds = null;
                    }
                    if (fileRollMilliseconds == null) continue block34;
                    settings.setFileRollMilliseconds(fileRollMilliseconds.intValue());
                    log.debug("fileRollMilliseconds is {}", (Object)fileRollMilliseconds);
                    break;
                }
                case "fileRollMaxRolls": {
                    if (p.isEmpty()) continue block34;
                    Integer rolls = null;
                    try {
                        rolls = Integer.parseInt(p);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (rolls == null) continue block34;
                    settings.setFileRollMaxRolls(rolls);
                    break;
                }
                case "trusted": {
                    if (p.isEmpty()) continue block34;
                    settings.setTrusted(Boolean.parseBoolean(p));
                    log.debug("trustedMode is {}", (Object)settings.isTrusted());
                    break;
                }
                case "statsd": {
                    if (p.isEmpty()) continue block34;
                    String[] parts = p.split(":");
                    if (parts.length == 2) {
                        settings.setStatsdHost(parts[0].trim());
                        try {
                            settings.setStatsdPort(Integer.parseInt(parts[1].trim()));
                        }
                        catch (NumberFormatException ex) {
                            log.warn("Invalid statsd port number: {}", (Object)parts[1]);
                        }
                        break;
                    }
                    if (parts.length != 1) continue block34;
                    settings.setStatsdHost(parts[0].trim());
                    break;
                }
                case "probeDescPath": {
                    settings.setProbeDescPath(!p.isEmpty() ? p : ".");
                    log.debug("probe descriptor path is {}", (Object)settings.getProbeDescPath());
                    break;
                }
                case "bootClassPath": {
                    settings.setBootClassPath(!p.isEmpty() ? p : "");
                    log.debug("probe boot class path is {}", (Object)settings.getBootClassPath());
                    break;
                }
                default: {
                    if (!key.startsWith("$")) continue block34;
                    String pKey = key.substring(1);
                    System.setProperty(pKey, p);
                    log.debug("Setting system property: {}={}", (Object)pKey, (Object)p);
                }
            }
        }
    }

    private static void processClasspaths(String libs) {
        String bootClassPath;
        URL agentJar = Main.class.getResource("Main.class");
        String bootPath = agentJar.toString().replace("jar:file:", "");
        int idx = bootPath.indexOf("btrace-agent.jar");
        if (idx > -1) {
            bootPath = bootPath.substring(0, idx) + "btrace-boot.jar";
        }
        bootClassPath = (bootClassPath = argMap.get("bootClassPath")) == null ? bootPath : (".".equals(bootClassPath) ? bootPath : bootPath + File.pathSeparator + bootClassPath);
        log.debug("Bootstrap ClassPath: {}", (Object)bootClassPath);
        StringTokenizer tokenizer = new StringTokenizer(bootClassPath, File.pathSeparator);
        try {
            while (tokenizer.hasMoreTokens()) {
                String path = tokenizer.nextToken();
                File f = new File(path);
                if (!f.exists()) {
                    log.warn("BTrace bootstrap classpath resource [{}] does not exist", (Object)path);
                    continue;
                }
                if (f.isFile() && f.getName().toLowerCase().endsWith(".jar")) {
                    JarFile jf = Main.asJarFile(f);
                    log.debug("Adding jar: {}", (Object)jf);
                    inst.appendToBootstrapClassLoaderSearch(jf);
                    continue;
                }
                log.debug("ignoring boot classpath element '{}' - only jar files allowed", (Object)path);
            }
        }
        catch (IOException ex) {
            log.debug("adding to boot classpath failed!", ex);
            return;
        }
        String systemClassPath = argMap.get("systemClassPath");
        if (systemClassPath != null) {
            log.debug("System ClassPath: {}", (Object)systemClassPath);
            tokenizer = new StringTokenizer(systemClassPath, File.pathSeparator);
            try {
                while (tokenizer.hasMoreTokens()) {
                    String path = tokenizer.nextToken();
                    File f = new File(path);
                    if (!f.exists()) {
                        log.warn("BTrace system classpath resource [{}] does not exist.", (Object)path);
                        continue;
                    }
                    if (f.isFile() && f.getName().toLowerCase().endsWith(".jar")) {
                        JarFile jf = Main.asJarFile(f);
                        inst.appendToSystemClassLoaderSearch(jf);
                        continue;
                    }
                    log.debug("ignoring system classpath element '{}' - only jar files allowed", (Object)path);
                }
            }
            catch (IOException ex) {
                log.debug("adding to boot classpath failed!", ex);
                return;
            }
        }
        Main.addPreconfLibs(libs);
    }

    private static JarFile asJarFile(File path) throws IOException {
        try {
            Class.forName("java.lang.Module");
            Class<Runtime> rtClass = Runtime.class;
            Method m3 = rtClass.getMethod("version", new Class[0]);
            Object version = m3.invoke(null, new Object[0]);
            return (JarFile)JarFile.class.getConstructor(File.class, Boolean.TYPE, Integer.TYPE, version.getClass()).newInstance(path, true, 1, version);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new JarFile(path);
        }
    }

    private static void addPreconfLibs(String libs) {
        String path;
        int delimiterPos;
        URL u = Main.class.getClassLoader().getResource(Main.class.getName().replace('.', '/') + ".class");
        if (u != null && (delimiterPos = (path = u.toString()).lastIndexOf(33)) > -1) {
            Path libFolder;
            String jar = path.substring(9, delimiterPos);
            File jarFile = new File(jar);
            Path libRoot = new File(jarFile.getParent() + File.separator + "btrace-libs").toPath();
            Path path2 = libFolder = libs != null ? libRoot.resolve(libs) : libRoot;
            if (Files.exists(libFolder, new LinkOption[0])) {
                Main.appendToBootClassPath(libFolder);
                Main.appendToSysClassPath(libFolder);
            } else if (libs != null && !libs.isEmpty()) {
                log.warn("Invalid 'libs' configuration [{}]. Path '{}' does not exist.", (Object)libs, (Object)libFolder.toAbsolutePath());
            }
        }
    }

    private static void appendToBootClassPath(Path libFolder) {
        Path bootLibs = libFolder.resolve("boot");
        if (Files.exists(bootLibs, new LinkOption[0])) {
            try {
                Files.walkFileTree(bootLibs, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.toString().toLowerCase().endsWith(".jar")) {
                            if (log.isDebugEnabled()) {
                                log.debug("Adding {} to bootstrap classpath", (Object)file);
                            }
                            inst.appendToBootstrapClassLoaderSearch(new JarFile(file.toFile()));
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                log.debug("Failed to enhance bootstrap classpath", e);
            }
        }
    }

    private static void appendToSysClassPath(Path libFolder) {
        Path sysLibs = libFolder.resolve("system");
        if (Files.exists(sysLibs, new LinkOption[0])) {
            try {
                Files.walkFileTree(sysLibs, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.toString().toLowerCase().endsWith(".jar")) {
                            if (log.isDebugEnabled()) {
                                log.debug("Adding {} to system classpath", (Object)file);
                            }
                            inst.appendToSystemClassLoaderSearch(new JarFile(file.toFile()));
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                log.debug("Failed to enhance sytem classpath", e);
            }
        }
    }

    private static boolean loadBTraceScript(String filePath, boolean traceToStdOut) {
        if (!BTraceProbeFactory.canLoad(filePath)) {
            return false;
        }
        try {
            String scriptName = "";
            String scriptParent = "";
            File traceScript = new File(filePath);
            scriptName = traceScript.getName();
            scriptParent = traceScript.getParent();
            if (!traceScript.exists()) {
                traceScript = new File("META-INF/btrace/" + filePath);
            }
            if (scriptName.endsWith(".java")) {
                if (log.isDebugEnabled()) {
                    log.debug("refusing {} - script should be a pre-compiled class file", (Object)filePath);
                }
                return false;
            }
            SharedSettings clientSettings = new SharedSettings();
            clientSettings.from(settings);
            clientSettings.setClientName(scriptName);
            if (traceToStdOut) {
                clientSettings.setOutputFile("::stdout");
            } else {
                String traceOutput = clientSettings.getOutputFile();
                String outDir = clientSettings.getScriptOutputDir();
                if (traceOutput == null || traceOutput.length() == 0) {
                    clientSettings.setOutputFile("${client}-${agent}.${ts}.btrace[default]");
                    if (outDir == null || outDir.length() == 0) {
                        clientSettings.setScriptOutputDir(scriptParent);
                    }
                }
            }
            ClientContext ctx = new ClientContext(inst, transformer, argMap, clientSettings);
            FileClient client = new FileClient(ctx, traceScript);
            if (client.isInitialized()) {
                Main.handleNewClient(client).get();
                return true;
            }
        }
        catch (NullPointerException e) {
            if (log.isDebugEnabled()) {
                log.debug("script {} does not exist!", (Object)filePath, (Object)e);
            }
        }
        catch (IOException | RuntimeException | ExecutionException re) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to load BTrace script {}", (Object)filePath, (Object)re);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    private static void startServer() {
        ServerSocket ss;
        int port = 2020;
        String p = argMap.get("port");
        if (p != null) {
            try {
                port = Integer.parseInt(p);
            }
            catch (NumberFormatException exp) {
                Main.error("invalid port assuming default..");
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("starting server at port {}", (Object)port);
            }
            System.setProperty("btrace.wireio", String.valueOf(1));
            String scriptOutputFile = settings.getOutputFile();
            if (scriptOutputFile != null && scriptOutputFile.length() > 0) {
                System.setProperty("btrace.output", scriptOutputFile);
            }
            ss = new ServerSocket(port);
            System.setProperty("btrace.port", String.valueOf(ss.getLocalPort()));
        }
        catch (IOException ioexp) {
            ioexp.printStackTrace();
            return;
        }
        while (true) {
            try {
                while (true) {
                    log.debug("waiting for clients");
                    Socket sock = ss.accept();
                    if (log.isDebugEnabled()) {
                        log.debug("client accepted {}", (Object)sock);
                    }
                    ClientContext ctx = new ClientContext(inst, transformer, argMap, settings);
                    Client client = RemoteClient.getClient(ctx, sock, value -> Main.handleNewClient(value));
                }
            }
            catch (IOException | RuntimeException re) {
                if (!log.isDebugEnabled()) continue;
                log.debug("BTrace server failed", re);
                continue;
            }
            break;
        }
    }

    private static Future<?> handleNewClient(Client client) {
        return serializedExecutor.submit(() -> {
            try {
                boolean entered = BTraceRuntime.enter();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("new Client created {}", (Object)client);
                    }
                    if (client.retransformLoaded()) {
                        client.getRuntime().send(new StatusCommand(1));
                    }
                }
                catch (UnmodifiableClassException uce) {
                    log.debug("BTrace class retransformation failed", uce);
                    client.getRuntime().send(new ErrorCommand(uce));
                    client.getRuntime().send(new StatusCommand(-1));
                }
                finally {
                    if (entered) {
                        BTraceRuntime.leave();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
    }

    private static void error(String msg) {
        System.err.println("btrace ERROR: " + msg);
    }

    private static boolean isDebug() {
        return settings.isDebug();
    }

    static {
        log = LoggerFactory.getLogger(Main.class);
    }

    private static final class LogValue {
        final String logLine;
        final Throwable throwable;

        public LogValue(String logLine, Throwable throwable) {
            this.logLine = logLine;
            this.throwable = throwable;
        }
    }
}

