/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.agent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.openjdk.btrace.agent.Client;
import org.openjdk.btrace.agent.ClientContext;
import org.openjdk.btrace.core.BTraceRuntime;
import org.openjdk.btrace.core.CircularBuffer;
import org.openjdk.btrace.core.Function;
import org.openjdk.btrace.core.SharedSettings;
import org.openjdk.btrace.core.comm.Command;
import org.openjdk.btrace.core.comm.DisconnectCommand;
import org.openjdk.btrace.core.comm.EventCommand;
import org.openjdk.btrace.core.comm.ExitCommand;
import org.openjdk.btrace.core.comm.InstrumentCommand;
import org.openjdk.btrace.core.comm.ListProbesCommand;
import org.openjdk.btrace.core.comm.PrintableCommand;
import org.openjdk.btrace.core.comm.ReconnectCommand;
import org.openjdk.btrace.core.comm.SetSettingsCommand;
import org.openjdk.btrace.core.comm.StatusCommand;
import org.openjdk.btrace.core.comm.WireIO;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;

class RemoteClient
extends Client {
    private static final Logger log = LoggerFactory.getLogger(RemoteClient.class);
    private volatile Socket sock;
    private volatile ObjectInputStream ois;
    private volatile ObjectOutputStream oos;
    private final AtomicReferenceFieldUpdater<RemoteClient, Socket> sockUpdater = AtomicReferenceFieldUpdater.newUpdater(RemoteClient.class, Socket.class, "sock");
    private final AtomicReferenceFieldUpdater<RemoteClient, ObjectInputStream> oisUpdater = AtomicReferenceFieldUpdater.newUpdater(RemoteClient.class, ObjectInputStream.class, "ois");
    private final AtomicReferenceFieldUpdater<RemoteClient, ObjectOutputStream> oosUpdater = AtomicReferenceFieldUpdater.newUpdater(RemoteClient.class, ObjectOutputStream.class, "oos");
    private final CircularBuffer<Command> delayedCommands = new CircularBuffer(5000);

    static Client getClient(ClientContext ctx, Socket sock, Function<Client, Future<?>> initCallback) throws IOException {
        Command cmd;
        SharedSettings settings = ctx.getSettings();
        ObjectInputStream ois = new ObjectInputStream(sock.getInputStream());
        ObjectOutputStream oos = new ObjectOutputStream(sock.getOutputStream());
        block9: while (true) {
            cmd = WireIO.read(ois);
            switch (cmd.getType()) {
                case 13: {
                    settings.from(((SetSettingsCommand)cmd).getParams());
                    continue block9;
                }
                case 3: {
                    log.debug("got instrument command");
                    try {
                        RemoteClient client = new RemoteClient(ctx, ois, oos, sock, (InstrumentCommand)cmd);
                        initCallback.apply(client).get();
                        client.sendCommand(new StatusCommand(1));
                        return client;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        WireIO.write(oos, new StatusCommand(-1));
                        throw new IOException(e);
                    }
                }
                case 16: {
                    String probeId = ((ReconnectCommand)cmd).getProbeId();
                    log.debug("Attempting to reconnect client for probe {}", (Object)probeId);
                    Client client = Client.findClient(probeId);
                    log.debug("Found client {}", (Object)client);
                    if (client instanceof RemoteClient) {
                        ((RemoteClient)client).reconnect(ois, oos, sock);
                        client.sendCommand(new StatusCommand(8));
                        return client;
                    }
                    WireIO.write(oos, new StatusCommand(-8));
                    throw new IOException("Can not reconnect to non-remote session");
                }
                case 14: {
                    ListProbesCommand listProbesCommand = (ListProbesCommand)cmd;
                    listProbesCommand.setProbes(Client.listProbes());
                    WireIO.write(oos, listProbesCommand);
                    continue block9;
                }
                case 2: {
                    return null;
                }
            }
            break;
        }
        throw new IOException("expecting instrument, reconnect or settings command! (" + cmd.getClass() + ")");
    }

    private RemoteClient(ClientContext ctx, ObjectInputStream ois, ObjectOutputStream oos, Socket sock, InstrumentCommand cmd) throws IOException {
        super(ctx);
        this.sock = sock;
        this.ois = ois;
        this.oos = oos;
        this.settings.from(ctx.getSettings());
        Class<?> btraceClazz = this.loadClass(cmd);
        if (btraceClazz == null) {
            throw new RuntimeException("can not load BTrace class");
        }
        this.initClient();
    }

    private void initClient() {
        BTraceRuntime.initUnsafe();
        Thread cmdHandler = new Thread(() -> {
            try {
                BTraceRuntime.enter();
                try {
                    block13: while (true) {
                        if (this.ois == null) {
                            LockSupport.parkNanos(500000000L);
                            continue;
                        }
                        Command cmd = WireIO.read(this.ois);
                        switch (cmd.getType()) {
                            case 2: {
                                log.debug("received exit command");
                                this.onCommand(cmd);
                                return;
                            }
                            case 15: {
                                log.debug("received disconnect command");
                                this.onCommand(cmd);
                                continue block13;
                            }
                            case 14: {
                                this.onCommand(cmd);
                                continue block13;
                            }
                            case 1: {
                                this.getRuntime().handleEvent((EventCommand)cmd);
                                continue block13;
                            }
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug("received {}", (Object)cmd);
                    }
                }
                catch (Exception exp) {
                    log.debug("Error while processing BTrace command", exp);
                    BTraceRuntime.leave();
                    return;
                }
            }
            finally {
                BTraceRuntime.leave();
            }
        });
        cmdHandler.setDaemon(true);
        log.debug("starting client command handler thread");
        cmdHandler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommand(Command cmd) throws IOException {
        ObjectOutputStream output = this.oos;
        if (output == null) {
            if (!cmd.isUrgent()) {
                this.delayedCommands.add(cmd);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("client {}: got {}", (Object)this.getClassName(), (Object)cmd);
        }
        try {
            boolean isConnected = true;
            try {
                ObjectOutputStream objectOutputStream = output;
                synchronized (objectOutputStream) {
                    output.reset();
                }
            }
            catch (SocketException e) {
                isConnected = false;
            }
            this.delayedCommands.forEach(new DelayedCommandExecutor(isConnected));
            if (!this.dispatchCommand(cmd, isConnected) && !cmd.isUrgent()) {
                this.delayedCommands.add(cmd);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchCommand(Command cmd, boolean isConnected) {
        if (cmd == Command.NULL) {
            return true;
        }
        ObjectOutputStream output = this.oos;
        ObjectInputStream input = this.ois;
        Socket socket = this.sock;
        if (output == null) {
            return false;
        }
        try {
            switch (cmd.getType()) {
                case 2: {
                    if (isConnected) {
                        WireIO.write(output, cmd);
                    }
                    this.onExit(((ExitCommand)cmd).getExitCode());
                    break;
                }
                case 14: {
                    if (!isConnected) break;
                    ((ListProbesCommand)cmd).setProbes(RemoteClient.listProbes());
                    WireIO.write(output, cmd);
                    break;
                }
                case 15: {
                    ((DisconnectCommand)cmd).setProbeId(this.id.toString());
                    ObjectOutputStream objectOutputStream = output;
                    synchronized (objectOutputStream) {
                        WireIO.write(output, cmd);
                        output.flush();
                        output.close();
                    }
                    this.oosUpdater.compareAndSet(this, output, null);
                    if (input != null) {
                        input.close();
                        this.oisUpdater.compareAndSet(this, input, null);
                    }
                    if (socket == null) break;
                    socket.close();
                    this.sockUpdater.compareAndSet(this, socket, null);
                    break;
                }
                default: {
                    if (this.out != null && cmd instanceof PrintableCommand) {
                        ((PrintableCommand)((Object)cmd)).print(this.out);
                        break;
                    }
                    if (!isConnected) break;
                    WireIO.write(this.oos, cmd);
                }
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isDisconnected() {
        return this.sock == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAll() throws IOException {
        Socket socket;
        ObjectInputStream input;
        super.closeAll();
        ObjectOutputStream output = this.oos;
        if (output != null) {
            ObjectOutputStream objectOutputStream = output;
            synchronized (objectOutputStream) {
                output.close();
            }
            this.oosUpdater.compareAndSet(this, output, null);
        }
        if ((input = this.ois) != null) {
            input.close();
            this.oisUpdater.compareAndSet(this, input, null);
        }
        if ((socket = this.sock) != null) {
            socket.close();
            this.sockUpdater.compareAndSet(this, socket, null);
        }
    }

    void reconnect(ObjectInputStream ois, ObjectOutputStream oos, Socket socket) throws IOException {
        this.sock = socket;
        this.ois = ois;
        this.oos = oos;
        this.onCommand(Command.NULL);
    }

    private final class DelayedCommandExecutor
    implements Function<Command, Boolean> {
        private final boolean isConnected;

        public DelayedCommandExecutor(boolean isConnected) {
            this.isConnected = isConnected;
        }

        @Override
        public Boolean apply(Command value) {
            return RemoteClient.this.dispatchCommand(value, this.isConnected);
        }
    }
}

