/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.compiler;

import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.openjdk.btrace.libs.org.objectweb.asm.ClassWriter;

class CompilerClassWriter
extends ClassWriter {
    private final URLClassLoader cl;

    public CompilerClassWriter(String classPath, PrintWriter perr) {
        super(2);
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classPath != null) {
            for (String e : classPath.split(File.pathSeparator)) {
                File f = new File(e);
                try {
                    urls.add(f.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    perr.printf("%s is not a valid classpath entry\n", e);
                }
            }
        }
        this.cl = new URLClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader());
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        Class<?> d;
        Class<?> c;
        try {
            c = this.cl.loadClass(type1.replace('/', '.'));
            d = this.cl.loadClass(type2.replace('/', '.'));
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        if (c.isAssignableFrom(d)) {
            return type1;
        }
        if (d.isAssignableFrom(c)) {
            return type2;
        }
        if (c.isInterface() || d.isInterface()) {
            return "java/lang/Object";
        }
        while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
        }
        return c.getName().replace('.', '/');
    }
}

