/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.compiler;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.openjdk.btrace.compiler.Verifier;
import org.openjdk.btrace.core.Messages;
import org.openjdk.btrace.core.annotations.BTrace;
import org.openjdk.btrace.core.annotations.Injected;
import org.openjdk.btrace.core.annotations.Kind;
import org.openjdk.btrace.core.annotations.OnError;
import org.openjdk.btrace.core.annotations.OnExit;
import org.openjdk.btrace.core.annotations.OnMethod;
import org.openjdk.btrace.core.annotations.Sampled;

public class VerifierVisitor
extends TreeScanner<Void, Void> {
    private static final String ON_ERROR_TYPE = OnError.class.getName();
    private static final String ON_EXIT_TYPE = OnExit.class.getName();
    private static final String THROWABLE_TYPE = Throwable.class.getName();
    private final Verifier verifier;
    private String className;
    private String fqn;
    private boolean insideMethod;
    private boolean shortSyntax = false;
    private TypeMirror btraceServiceTm = null;
    private TypeMirror runtimeServiceTm = null;
    private TypeMirror simpleServiceTm = null;
    private TypeMirror serviceInjectorTm = null;
    private boolean isInAnnotation = false;
    private final Set<String> eventFieldNames = new HashSet<String>();
    private final TreeScanner<Void, Void> jfrFieldNameCollector = new TreeScanner<Void, Void>(){

        @Override
        public Void visitAnnotation(AnnotationTree node, Void o) {
            String annType = node.getAnnotationType().toString();
            if (annType.endsWith("Event")) {
                for (ExpressionTree expressionTree : node.getArguments()) {
                    AssignmentTree t = (AssignmentTree)expressionTree;
                    String name = t.getVariable().toString();
                    if (!name.equals("fields")) continue;
                    VerifierVisitor.this.processEventFields(t);
                }
            }
            return (Void)super.visitAnnotation(node, o);
        }
    };

    public VerifierVisitor(Verifier verifier, Element clzElement) {
        this.verifier = verifier;
        this.btraceServiceTm = verifier.getElementUtils().getTypeElement("org.openjdk.btrace.services.spi.BTraceService").asType();
        this.runtimeServiceTm = verifier.getElementUtils().getTypeElement("org.openjdk.btrace.services.spi.RuntimeService").asType();
        this.simpleServiceTm = verifier.getElementUtils().getTypeElement("org.openjdk.btrace.services.spi.SimpleService").asType();
        this.serviceInjectorTm = verifier.getElementUtils().getTypeElement("org.openjdk.btrace.services.api.Service").asType();
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void v) {
        Element e = this.getElement(node);
        if (e != null && (e.getKind() == ElementKind.METHOD || e.getKind() == ElementKind.CONSTRUCTOR)) {
            String name = e.getSimpleName().toString();
            if (name.equals("<init>")) {
                return (Void)super.visitMethodInvocation(node, v);
            }
            TypeElement parent = null;
            while ((parent = (TypeElement)e.getEnclosingElement()) != null && parent.getKind() != ElementKind.CLASS && parent.getKind() != ElementKind.INTERFACE) {
            }
            if (parent != null) {
                TypeMirror tm = parent.asType();
                String typeName = tm.toString();
                if (this.isSameClass(typeName)) {
                    return (Void)super.visitMethodInvocation(node, v);
                }
                if (this.isBTraceClass(typeName)) {
                    String nameValue;
                    if (typeName.contains("BTraceUtils") && e.getSimpleName().contentEquals("setEventField") && !this.eventFieldNames.contains(nameValue = node.getArguments().get(1).toString())) {
                        this.reportError("jfr.event.invalid.field", node.getArguments().get(1));
                    }
                    return (Void)super.visitMethodInvocation(node, v);
                }
                if (this.verifier.getTypeUtils().isSubtype(tm, this.btraceServiceTm)) {
                    return (Void)super.visitMethodInvocation(node, v);
                }
                if (this.verifier.getTypeUtils().isSubtype(tm, this.serviceInjectorTm)) {
                    if (!this.validateInjectionParams(node)) {
                        this.reportError("service.injector.literals", node);
                    }
                    return (Void)super.visitMethodInvocation(node, v);
                }
            }
        }
        this.reportError("no.method.calls", node);
        return (Void)super.visitMethodInvocation(node, v);
    }

    private boolean isSameClass(String typeName) {
        return this.fqn.equals(typeName);
    }

    private boolean isBTraceClass(String typeName) {
        return typeName.equals("org.openjdk.btrace.core.BTraceUtils") || typeName.startsWith("org.openjdk.btrace.core.BTraceUtils.");
    }

    @Override
    public Void visitAssert(AssertTree node, Void v) {
        this.reportError("no.asserts", node);
        return (Void)super.visitAssert(node, v);
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void v) {
        this.checkLValue(node.getVariable());
        return (Void)super.visitAssignment(node, v);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void v) {
        this.checkLValue(node.getVariable());
        return (Void)super.visitCompoundAssignment(node, v);
    }

    @Override
    public Void visitCatch(CatchTree node, Void v) {
        this.reportError("no.catch", node);
        return (Void)super.visitCatch(node, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClass(ClassTree node, Void v) {
        List<? extends AnnotationTree> anno;
        List<? extends Tree> list;
        String string;
        Set<Modifier> mods;
        if (this.insideMethod) {
            this.reportError("no.local.class", node);
        }
        if (!((mods = node.getModifiers().getFlags()).contains((Object)Modifier.PRIVATE) || mods.contains((Object)Modifier.PROTECTED) || mods.contains((Object)Modifier.PUBLIC))) {
            this.shortSyntax = true;
        }
        List<? extends Tree> members = node.getMembers();
        for (Tree tree : members) {
            if (tree.getKind() == Tree.Kind.CLASS) {
                this.reportError("no.nested.class", tree);
            }
            if (tree.getKind() != Tree.Kind.VARIABLE) continue;
            VariableTree vt = (VariableTree)tree;
            boolean isStatic = this.isStatic(vt.getModifiers().getFlags());
            if (this.shortSyntax) {
                if (!isStatic) continue;
                this.reportError("no.static.variables", tree);
                continue;
            }
            if (isStatic) continue;
            this.reportError("no.instance.variables", tree);
        }
        Tree superClass = node.getExtendsClause();
        if (superClass != null && !(string = superClass.toString()).equals("Object") && !string.equals("java.lang.Object")) {
            this.reportError("object.superclass.required", superClass);
        }
        if ((list = node.getImplementsClause()) != null && list.size() > 0) {
            this.reportError("no.interface.implementation", list.get(0));
        }
        ModifiersTree mt = node.getModifiers();
        if (!this.shortSyntax && !this.isPublic(mt.getFlags())) {
            this.reportError("class.should.be.public", node);
        }
        if ((anno = mt.getAnnotations()) != null && !anno.isEmpty()) {
            String btrace = BTrace.class.getName();
            for (AnnotationTree annotationTree : anno) {
                String name2 = annotationTree.getAnnotationType().toString();
                if (!name2.equals(btrace) && !name2.equals("BTrace")) continue;
                String oldClassName = this.className;
                try {
                    this.className = node.getSimpleName().toString();
                    this.fqn = this.getElement(node).asType().toString();
                    Void void_ = (Void)super.visitClass(node, v);
                    return void_;
                }
                finally {
                    this.className = oldClassName;
                }
            }
        }
        this.reportError("not.a.btrace.program", node);
        return null;
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree node, Void v) {
        this.reportError("no.do.while", node);
        return (Void)super.visitDoWhileLoop(node, v);
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void v) {
        this.reportError("no.enhanced.for", node);
        return (Void)super.visitEnhancedForLoop(node, v);
    }

    @Override
    public Void visitForLoop(ForLoopTree node, Void v) {
        this.reportError("no.for.loop", node);
        return (Void)super.visitForLoop(node, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethod(MethodTree node, Void v) {
        boolean oldInsideMethod = this.insideMethod;
        this.insideMethod = true;
        try {
            Name name = node.getName();
            if (name.contentEquals("<init>")) {
                Void void_ = (Void)super.visitMethod(node, v);
                return void_;
            }
            this.checkSampling(node);
            if (this.isExitHandler(node) && (node.getParameters().size() != 1 || !"int".equals(node.getParameters().get(0).getType().toString()))) {
                this.reportError("onexit.invalid", node);
                Void void_ = (Void)super.visitMethod(node, v);
                return void_;
            }
            if (this.isErrorHandler(node)) {
                Element thrElement = this.getElement(node.getParameters().get(0).getType());
                if (node.getParameters().size() != 1 || !THROWABLE_TYPE.equals(thrElement.toString())) {
                    this.reportError("onerror.invalid", node);
                }
            }
            for (VariableTree variableTree : node.getParameters()) {
                variableTree.accept(new TreeScanner<Void, Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void visitAnnotation(AnnotationTree at, Void p) {
                        VerifierVisitor.this.isInAnnotation = true;
                        try {
                            Void void_ = (Void)super.visitAnnotation(at, p);
                            return void_;
                        }
                        finally {
                            VerifierVisitor.this.isInAnnotation = false;
                        }
                    }
                }, null);
            }
            Set<Modifier> flags = node.getModifiers().getFlags();
            if (this.shortSyntax) {
                if (this.isStatic(flags)) {
                    this.reportError("no.static.method", node);
                }
                if (this.isSynchronized(flags)) {
                    this.reportError("no.synchronized.methods", node);
                }
            } else {
                boolean bl = this.isStatic(flags);
                if (bl) {
                    boolean isPublic = this.isPublic(node.getModifiers().getFlags());
                    if (isPublic) {
                        if (this.isSynchronized(flags)) {
                            this.reportError("no.synchronized.methods", node);
                        }
                    } else if (this.isAnnotated(node)) {
                        this.reportError("method.should.be.public", node);
                    }
                } else {
                    this.reportError("no.instance.method", node);
                }
            }
            node.accept(this.jfrFieldNameCollector, null);
            Void void_ = (Void)super.visitMethod(node, v);
            return void_;
        }
        finally {
            this.insideMethod = oldInsideMethod;
        }
    }

    private void addEventFieldNames(AnnotationTree at) {
        for (ExpressionTree expressionTree : at.getArguments()) {
            this.addEventFieldName((AssignmentTree)expressionTree);
        }
    }

    private void addEventFieldName(AssignmentTree assignmentTree) {
        String varName = assignmentTree.getVariable().toString();
        if (varName.equals("name")) {
            this.eventFieldNames.add(assignmentTree.getExpression().toString());
        }
    }

    @Override
    public Void visitNewArray(NewArrayTree node, Void v) {
        if (!this.isInAnnotation) {
            this.reportError("no.array.creation", node);
        }
        return (Void)super.visitNewArray(node, v);
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void v) {
        Element e = this.getElement(node);
        TypeElement te = (TypeElement)e.getEnclosingElement();
        this.reportError("no.new.object", node);
        return (Void)super.visitNewClass(node, v);
    }

    @Override
    public Void visitReturn(ReturnTree node, Void v) {
        if (node.getExpression() != null) {
            TreePath tp = this.verifier.getTreeUtils().getPath(this.verifier.getCompilationUnit(), node);
            while (tp != null) {
                Tree leaf = (tp = tp.getParentPath()).getLeaf();
                if (leaf.getKind() != Tree.Kind.METHOD) continue;
                if (this.isAnnotated((MethodTree)leaf)) {
                    this.reportError("return.type.should.be.void", node);
                    continue;
                }
                return (Void)super.visitReturn(node, v);
            }
        }
        return (Void)super.visitReturn(node, v);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void v) {
        if (!this.isInAnnotation && node.getIdentifier().contentEquals("class")) {
            TypeMirror tm = this.getType(node.getExpression());
            if (!this.verifier.getTypeUtils().isSubtype(tm, this.btraceServiceTm)) {
                this.reportError("no.class.literals", node);
            }
        }
        return (Void)super.visitMemberSelect(node, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitAnnotation(AnnotationTree node, Void unused) {
        try {
            this.isInAnnotation = true;
            Void void_ = (Void)super.visitAnnotation(node, unused);
            return void_;
        }
        finally {
            this.isInAnnotation = false;
        }
    }

    @Override
    public Void visitSynchronized(SynchronizedTree node, Void v) {
        this.reportError("no.synchronized.blocks", node);
        return (Void)super.visitSynchronized(node, v);
    }

    @Override
    public Void visitThrow(ThrowTree node, Void v) {
        this.reportError("no.throw", node);
        return (Void)super.visitThrow(node, v);
    }

    @Override
    public Void visitTry(TryTree node, Void v) {
        this.reportError("no.try", node);
        return (Void)super.visitTry(node, v);
    }

    @Override
    public Void visitVariable(VariableTree vt, Void p) {
        VariableElement ve = (VariableElement)this.getElement(vt);
        if (ve.getEnclosingElement().getKind() == ElementKind.CLASS) {
            if (this.verifier.getTypeUtils().isSubtype(ve.asType(), this.btraceServiceTm)) {
                Injected i = ve.getAnnotation(Injected.class);
                if (i == null) {
                    this.reportError("missing.injected", vt);
                } else {
                    switch (i.value()) {
                        case RUNTIME: {
                            if (this.verifier.getTypeUtils().isSubtype(ve.asType(), this.runtimeServiceTm)) break;
                            this.reportError("injected.no.runtime", vt);
                            break;
                        }
                        case SIMPLE: {
                            if (this.verifier.getTypeUtils().isSubtype(ve.asType(), this.simpleServiceTm)) break;
                            this.reportError("injected.no.simple", vt);
                        }
                    }
                }
                if (vt.getInitializer() != null) {
                    this.reportError("injected.no.initializer", vt.getInitializer());
                }
            } else {
                vt.accept(this.jfrFieldNameCollector, null);
            }
        }
        return (Void)super.visitVariable(vt, p);
    }

    private void processEventFields(AssignmentTree t) {
        if (t.getExpression() instanceof AnnotationTree) {
            AnnotationTree at = (AnnotationTree)t.getExpression();
            this.addEventFieldNames(at);
        } else if (t.getExpression() instanceof NewArrayTree) {
            for (ExpressionTree expressionTree : ((NewArrayTree)t.getExpression()).getInitializers()) {
                AnnotationTree at = (AnnotationTree)expressionTree;
                this.addEventFieldNames(at);
            }
        }
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree node, Void v) {
        this.reportError("no.while.loop", node);
        return (Void)super.visitWhileLoop(node, v);
    }

    @Override
    public Void visitOther(Tree node, Void v) {
        this.reportError("no.other", node);
        return (Void)super.visitOther(node, v);
    }

    private boolean isStatic(Set<Modifier> modifiers) {
        for (Modifier m3 : modifiers) {
            if (m3 != Modifier.STATIC) continue;
            return true;
        }
        return false;
    }

    private boolean isSynchronized(Set<Modifier> modifiers) {
        for (Modifier m3 : modifiers) {
            if (m3 != Modifier.SYNCHRONIZED) continue;
            return true;
        }
        return false;
    }

    private boolean isPublic(Set<Modifier> modifiers) {
        for (Modifier m3 : modifiers) {
            if (m3 != Modifier.PUBLIC) continue;
            return true;
        }
        return false;
    }

    private boolean isErrorHandler(MethodTree node) {
        ModifiersTree mt = node.getModifiers();
        List<? extends AnnotationTree> annos = mt.getAnnotations();
        for (AnnotationTree annotationTree : annos) {
            String annFqn = this.verifier.annotationName(annotationTree);
            if (!ON_ERROR_TYPE.equals(annFqn)) continue;
            return true;
        }
        return false;
    }

    private boolean isExitHandler(MethodTree node) {
        ModifiersTree mt = node.getModifiers();
        List<? extends AnnotationTree> annos = mt.getAnnotations();
        for (AnnotationTree annotationTree : annos) {
            String annFqn = this.verifier.annotationName(annotationTree);
            if (!ON_EXIT_TYPE.equals(annFqn)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnnotated(MethodTree node) {
        ModifiersTree mt = node.getModifiers();
        List<? extends AnnotationTree> annos = mt.getAnnotations();
        for (AnnotationTree annotationTree : annos) {
            String annFqn = this.verifier.annotationName(annotationTree);
            if (annFqn == null || !annFqn.startsWith("org.openjdk.btrace.core.annotations")) continue;
            return true;
        }
        return false;
    }

    private void checkSampling(MethodTree node) {
        ExecutableElement ee = (ExecutableElement)this.getElement(node);
        Sampled s2 = ee.getAnnotation(Sampled.class);
        OnMethod om = ee.getAnnotation(OnMethod.class);
        if (s2 != null && om != null) {
            Kind k = om.location().value();
            switch (k) {
                case ENTRY: 
                case RETURN: 
                case ERROR: 
                case CALL: {
                    return;
                }
            }
            this.reportError("sampler.invalid.location", node);
        }
    }

    private void checkLValue(Tree variable) {
        if (variable.getKind() == Tree.Kind.ARRAY_ACCESS) {
            this.reportError("no.assignment", variable);
            return;
        }
        if (variable.getKind() != Tree.Kind.IDENTIFIER) {
            if (this.className != null) {
                String name = variable.toString();
                if (!this.className.equals(name = name.substring(0, name.lastIndexOf(46)))) {
                    this.reportError("no.assignment", variable);
                }
            } else {
                this.reportError("no.assignment", variable);
            }
        }
    }

    private void reportError(String msg, Tree node) {
        SourcePositions srcPos = this.verifier.getSourcePositions();
        CompilationUnitTree compUnit = this.verifier.getCompilationUnit();
        if (compUnit != null) {
            long pos = srcPos.getStartPosition(compUnit, node);
            long line = compUnit.getLineMap().getLineNumber(pos);
            String name = compUnit.getSourceFile().getName();
            Element e = this.getElement(node);
            msg = String.format("%s:%d:%s [%s]", name, line, Messages.get(msg), e);
            this.verifier.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
        } else {
            this.verifier.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        }
    }

    private Element getElement(Tree t) {
        TreePath tp = this.verifier.getTreeUtils().getPath(this.verifier.getCompilationUnit(), t);
        Element e = this.verifier.getTreeUtils().getElement(tp);
        if (e == null) {
            if (t.getKind() == Tree.Kind.NEW_CLASS) {
                e = this.verifier.getTreeUtils().getElement(new TreePath(tp, ((NewClassTree)t).getIdentifier()));
            }
            if (t.getKind() == Tree.Kind.THROW) {
                e = this.verifier.getTreeUtils().getElement(new TreePath(tp, ((ThrowTree)t).getExpression()));
            }
            if (e == null) {
                this.verifier.getMessager().printMessage(Diagnostic.Kind.ERROR, t.toString());
            }
        }
        return e;
    }

    private TypeMirror getType(Tree t) {
        TreePath tp = this.verifier.getTreeUtils().getPath(this.verifier.getCompilationUnit(), t);
        return this.verifier.getTreeUtils().getTypeMirror(tp);
    }

    private boolean validateInjectionParams(MethodInvocationTree node) {
        boolean allLiterals = true;
        block4: for (ExpressionTree expressionTree : node.getArguments()) {
            switch (expressionTree.getKind()) {
                case MEMBER_SELECT: {
                    if (expressionTree.toString().endsWith(".class")) continue block4;
                    allLiterals = false;
                    break;
                }
                case STRING_LITERAL: {
                    continue block4;
                }
                default: {
                    allLiterals = false;
                    break;
                }
            }
            break;
        }
        return allLiterals;
    }
}

