/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ArgsMap
implements Iterable<Map.Entry<String, String>> {
    private final LinkedHashMap<String, String> map;

    public ArgsMap(Map<String, String> args) {
        this.map = args != null ? new LinkedHashMap<String, String>(args) : new LinkedHashMap();
    }

    public ArgsMap(String[] argLine) {
        this.map = new LinkedHashMap();
        if (argLine != null) {
            for (String arg : argLine) {
                String[] kv = arg.split("=");
                if (kv.length != 2) {
                    this.map.put(arg, "");
                    continue;
                }
                this.map.put(kv[0], kv[1]);
            }
        }
    }

    public ArgsMap() {
        this((Map<String, String>)null);
    }

    public ArgsMap(int initialCapacity) {
        this.map = new LinkedHashMap(initialCapacity);
    }

    public static ArgsMap merge(ArgsMap ... maps) {
        LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>();
        for (ArgsMap map : maps) {
            propMap.putAll(map.map);
        }
        return new ArgsMap(propMap);
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public String get(int idx) {
        if (idx >= 0 && idx < this.map.size()) {
            Iterator<Map.Entry<String, String>> argsIterator = this.map.entrySet().iterator();
            for (int i = 0; i < idx; ++i) {
                argsIterator.next();
            }
            Map.Entry<String, String> e = argsIterator.next();
            return e.getValue() != null ? e.getKey() + "=" + e.getValue() : e.getKey();
        }
        return null;
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String put(String key, String value) {
        return this.map.put(key, value);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entrySet().iterator();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return "ArgsMap{map=" + this.map + '}';
    }

    public String template(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return value;
        }
        Matcher matcher = PatternSingleton.INSTANCE.matcher(value);
        StringBuffer buffer = new StringBuffer(value.length());
        while (matcher.find()) {
            String val = this.get(matcher.group(1));
            matcher.appendReplacement(buffer, val != null ? val : "$0");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static final class PatternSingleton {
        private static final Pattern INSTANCE = Pattern.compile("\\$\\{(.*?)}");

        private PatternSingleton() {
        }
    }
}

