/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.openjdk.btrace.core.BTraceUtils;
import org.openjdk.btrace.core.Profiler;
import org.openjdk.btrace.core.aggregation.Aggregation;
import org.openjdk.btrace.core.aggregation.AggregationFunction;
import org.openjdk.btrace.core.aggregation.AggregationKey;
import org.openjdk.btrace.core.comm.Command;
import org.openjdk.btrace.core.comm.EventCommand;
import org.openjdk.btrace.core.comm.GridDataCommand;
import org.openjdk.btrace.core.comm.NumberDataCommand;
import org.openjdk.btrace.core.comm.NumberMapDataCommand;
import org.openjdk.btrace.core.comm.StringMapDataCommand;
import org.openjdk.btrace.core.jfr.JfrEvent;
import org.openjdk.btrace.core.types.AnyType;
import org.openjdk.btrace.core.types.BTraceCollection;
import org.openjdk.btrace.core.types.BTraceDeque;
import org.openjdk.btrace.core.types.BTraceMap;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;
import sun.misc.Unsafe;
import sun.security.action.GetPropertyAction;

public final class BTraceRuntime {
    private static final Logger log = LoggerFactory.getLogger(BTraceRuntime.class);
    public static final String CMD_QUEUE_LIMIT_KEY = "org.openjdk.btrace.core.cmdQueueLimit";
    private static final boolean messageTimestamp = false;
    private static final String LINE_SEPARATOR;
    private static final int V_Variable = 3;
    private static final int V_None = 1;
    private static final int V_String = 5;
    private static final int PERF_STRING_LIMIT = 256;
    private static final int THRD_DUMP_FRAMES = 1;
    private static volatile Unsafe unsafe;
    private static Properties dotWriterProps;
    private static volatile BTraceRuntimeAccessor rtAccessor;
    private static final String INDENT = "    ";

    private BTraceRuntime() {
    }

    private static Impl getRt() {
        Impl rt = rtAccessor.getRt();
        return rt;
    }

    public static long parseLong(String value, long deflt) {
        if (value == null) {
            return deflt;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return deflt;
        }
    }

    public static int parseInt(String value, int deflt) {
        if (value == null) {
            return deflt;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return deflt;
        }
    }

    public static Unsafe initUnsafe() {
        try {
            if (unsafe == null) {
                unsafe = Unsafe.getUnsafe();
            }
        }
        catch (SecurityException e) {
            log.warn("Unable to initialize Unsafe. BTrace will not function properly");
        }
        return unsafe;
    }

    static int getInstrumentationLevel() {
        return BTraceRuntime.getRt().getInstrumentationLevel();
    }

    static void setInstrumentationLevel(int level) {
        BTraceRuntime.getRt().setInstrumentationLevel(level);
    }

    public static boolean enter() {
        Impl rt = BTraceRuntime.getRt();
        return rt == null || rt.enter();
    }

    public static void leave() {
        Impl rt = BTraceRuntime.getRt();
        if (rt != null) {
            rt.leave();
        }
    }

    public static void handleException(Throwable th) {
        BTraceRuntime.getRt().handleException(th);
    }

    private static String identityStr(Object obj) {
        int hashCode = System.identityHashCode(obj);
        return obj.getClass().getName() + "@" + Integer.toHexString(hashCode);
    }

    static int speculation() {
        return BTraceRuntime.getRt().speculation();
    }

    static void speculate(int id) {
        BTraceRuntime.getRt().speculate(id);
    }

    static void discard(int id) {
        BTraceRuntime.getRt().discard(id);
    }

    static void commit(int id) {
        BTraceRuntime.getRt().commit(id);
    }

    static boolean compare(Object obj1, Object obj2) {
        if (obj1 instanceof String) {
            return obj1.equals(obj2);
        }
        if (obj1.getClass().getClassLoader() == null && (obj2 == null || obj2.getClass().getClassLoader() == null)) {
            return obj1.equals(obj2);
        }
        return obj1 == obj2;
    }

    static <K, V> Map<K, V> newHashMap() {
        return new BTraceMap(new HashMap());
    }

    static <K, V> Map<K, V> newWeakMap() {
        return new BTraceMap(new WeakHashMap());
    }

    static <V> Deque<V> newDeque() {
        return new BTraceDeque(new ArrayDeque());
    }

    static Appendable newStringBuilder(boolean threadSafe) {
        return threadSafe ? new StringBuffer() : new StringBuilder();
    }

    static Appendable newStringBuilder() {
        return BTraceRuntime.newStringBuilder(false);
    }

    static <E> int size(Collection<E> coll) {
        if (coll instanceof BTraceCollection || coll.getClass().getClassLoader() == null) {
            return coll.size();
        }
        throw new IllegalArgumentException();
    }

    public static <E> boolean isEmpty(Collection<E> coll) {
        if (coll instanceof BTraceCollection || coll.getClass().getClassLoader() == null) {
            return coll.isEmpty();
        }
        throw new IllegalArgumentException();
    }

    static <E> boolean contains(Collection<E> coll, Object obj) {
        if (coll instanceof BTraceCollection || coll.getClass().getClassLoader() == null) {
            for (E e : coll) {
                if (!BTraceRuntime.compare(e, obj)) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException();
    }

    static <E> Object[] toArray(Collection<E> collection) {
        if (collection == null) {
            return new Object[0];
        }
        return collection.toArray();
    }

    static <K, V> V get(Map<K, V> map, K key) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            return map.get(key);
        }
        throw new IllegalArgumentException();
    }

    static <K, V> boolean containsKey(Map<K, V> map, K key) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            return map.containsKey(key);
        }
        throw new IllegalArgumentException();
    }

    static <K, V> boolean containsValue(Map<K, V> map, V value) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            return map.containsValue(value);
        }
        throw new IllegalArgumentException();
    }

    static <K, V> V put(Map<K, V> map, K key, V value) {
        if (map instanceof BTraceMap) {
            return map.put(key, value);
        }
        throw new IllegalArgumentException("not a btrace map");
    }

    static <K, V> V remove(Map<K, V> map, K key) {
        if (map instanceof BTraceMap) {
            return map.remove(key);
        }
        throw new IllegalArgumentException("not a btrace map");
    }

    static <K, V> void clear(Map<K, V> map) {
        if (!(map instanceof BTraceMap)) {
            throw new IllegalArgumentException("not a btrace map");
        }
        map.clear();
    }

    static <K, V> int size(Map<K, V> map) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            return map.size();
        }
        throw new IllegalArgumentException();
    }

    static <K, V> boolean isEmpty(Map<K, V> map) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            return map.isEmpty();
        }
        throw new IllegalArgumentException();
    }

    static <K, V> void putAll(Map<K, V> src, Map<K, V> dst) {
        dst.putAll(src);
    }

    static <K, V> void copy(Map<K, V> src, Map<K, V> dst) {
        dst.clear();
        dst.putAll(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printMap(Map map) {
        if (map instanceof BTraceMap || map.getClass().getClassLoader() == null) {
            Map map2 = map;
            synchronized (map2) {
                HashMap<String, String> m3 = new HashMap<String, String>();
                Set entries = map.entrySet();
                for (Map.Entry e : entries) {
                    m3.put(BTraceUtils.Strings.str(e.getKey()), BTraceUtils.Strings.str(e.getValue()));
                }
                BTraceRuntime.printStringMap(null, m3);
            }
        } else {
            BTraceRuntime.print(BTraceUtils.Strings.str(map));
        }
    }

    public static <V> void push(Deque<V> queue, V value) {
        if (!(queue instanceof BTraceDeque) && queue.getClass().getClassLoader() != null) {
            throw new IllegalArgumentException();
        }
        queue.push(value);
    }

    public static <V> void addLast(Deque<V> queue, V value) {
        if (!(queue instanceof BTraceDeque) && queue.getClass().getClassLoader() != null) {
            throw new IllegalArgumentException();
        }
        queue.addLast(value);
    }

    public static <V> V peekFirst(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.peekFirst();
        }
        throw new IllegalArgumentException();
    }

    public static <V> V peekLast(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.peekLast();
        }
        throw new IllegalArgumentException();
    }

    public static <V> V removeLast(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.removeLast();
        }
        throw new IllegalArgumentException();
    }

    public static <V> V removeFirst(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.removeFirst();
        }
        throw new IllegalArgumentException();
    }

    public static <V> V poll(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.poll();
        }
        throw new IllegalArgumentException();
    }

    public static <V> V peek(Deque<V> queue) {
        if (queue instanceof BTraceDeque || queue.getClass().getClassLoader() == null) {
            return queue.peek();
        }
        throw new IllegalArgumentException();
    }

    public static <V> void clear(Deque<V> queue) {
        if (!(queue instanceof BTraceDeque) && queue.getClass().getClassLoader() != null) {
            throw new IllegalArgumentException();
        }
        queue.clear();
    }

    public static Appendable append(Appendable buffer, String strToAppend) {
        try {
            if (buffer != null && strToAppend != null) {
                return buffer.append(strToAppend);
            }
            throw new IllegalArgumentException();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int length(Appendable buffer) {
        if (buffer instanceof CharSequence) {
            return ((CharSequence)((Object)buffer)).length();
        }
        throw new IllegalArgumentException();
    }

    static void printNumber(String name, Number value) {
        BTraceRuntime.getRt().send(new NumberDataCommand(name, value));
    }

    static void printNumberMap(String name, Map<String, ? extends Number> data) {
        BTraceRuntime.getRt().send(new NumberMapDataCommand(name, data));
    }

    static void printStringMap(String name, Map<String, String> data) {
        BTraceRuntime.getRt().send(new StringMapDataCommand(name, data));
    }

    static void exit(int exitCode) {
        BTraceRuntime.getRt().exit(exitCode);
    }

    static long sizeof(Object obj) {
        return BTraceRuntime.getRt().sizeof(obj);
    }

    static int $length() {
        return BTraceRuntime.getRt().$length();
    }

    static String $(int n) {
        return BTraceRuntime.getRt().$(n);
    }

    static String $(String key) {
        return BTraceRuntime.getRt().$(key);
    }

    static boolean instanceOf(Object obj, String className) {
        if (obj instanceof AnyType) {
            if (className.equalsIgnoreCase("void")) {
                return obj.equals(AnyType.VOID);
            }
            return false;
        }
        Class<?> objClass = obj.getClass();
        ClassLoader cl = objClass.getClassLoader();
        cl = cl != null ? cl : ClassLoader.getSystemClassLoader();
        try {
            Class<?> target = cl.loadClass(className);
            return target.isAssignableFrom(objClass);
        }
        catch (ClassNotFoundException e) {
            log.debug("Class {} can not be found by classloader {}", className, cl, e);
            return false;
        }
    }

    static AtomicInteger newAtomicInteger(int initVal) {
        return new BTraceAtomicInteger(initVal);
    }

    static int get(AtomicInteger ai) {
        if (ai instanceof BTraceAtomicInteger || ai.getClass().getClassLoader() == null) {
            return ai.get();
        }
        throw new IllegalArgumentException();
    }

    static void set(AtomicInteger ai, int i) {
        if (!(ai instanceof BTraceAtomicInteger)) {
            throw new IllegalArgumentException();
        }
        ai.set(i);
    }

    static void lazySet(AtomicInteger ai, int i) {
        if (!(ai instanceof BTraceAtomicInteger)) {
            throw new IllegalArgumentException();
        }
        ai.lazySet(i);
    }

    static boolean compareAndSet(AtomicInteger ai, int i, int j) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.compareAndSet(i, j);
        }
        throw new IllegalArgumentException();
    }

    static boolean weakCompareAndSet(AtomicInteger ai, int i, int j) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.weakCompareAndSet(i, j);
        }
        throw new IllegalArgumentException();
    }

    static int getAndIncrement(AtomicInteger ai) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.getAndIncrement();
        }
        throw new IllegalArgumentException();
    }

    static int getAndDecrement(AtomicInteger ai) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.getAndDecrement();
        }
        throw new IllegalArgumentException();
    }

    static int incrementAndGet(AtomicInteger ai) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.incrementAndGet();
        }
        throw new IllegalArgumentException();
    }

    static int decrementAndGet(AtomicInteger ai) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.decrementAndGet();
        }
        throw new IllegalArgumentException();
    }

    static int getAndAdd(AtomicInteger ai, int i) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.getAndAdd(i);
        }
        throw new IllegalArgumentException();
    }

    static int addAndGet(AtomicInteger ai, int i) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.addAndGet(i);
        }
        throw new IllegalArgumentException();
    }

    static int getAndSet(AtomicInteger ai, int i) {
        if (ai instanceof BTraceAtomicInteger) {
            return ai.getAndSet(i);
        }
        throw new IllegalArgumentException();
    }

    static AtomicLong newAtomicLong(long initVal) {
        return new BTraceAtomicLong(initVal);
    }

    static long get(AtomicLong al) {
        if (al instanceof BTraceAtomicLong || al.getClass().getClassLoader() == null) {
            return al.get();
        }
        throw new IllegalArgumentException();
    }

    static void set(AtomicLong al, long i) {
        if (!(al instanceof BTraceAtomicLong)) {
            throw new IllegalArgumentException();
        }
        al.set(i);
    }

    static void lazySet(AtomicLong al, long i) {
        if (!(al instanceof BTraceAtomicLong)) {
            throw new IllegalArgumentException();
        }
        al.lazySet(i);
    }

    static boolean compareAndSet(AtomicLong al, long i, long j) {
        if (al instanceof BTraceAtomicLong) {
            return al.compareAndSet(i, j);
        }
        throw new IllegalArgumentException();
    }

    static boolean weakCompareAndSet(AtomicLong al, long i, long j) {
        if (al instanceof BTraceAtomicLong) {
            return al.weakCompareAndSet(i, j);
        }
        throw new IllegalArgumentException();
    }

    static long getAndIncrement(AtomicLong al) {
        if (al instanceof BTraceAtomicLong) {
            return al.getAndIncrement();
        }
        throw new IllegalArgumentException();
    }

    static long getAndDecrement(AtomicLong al) {
        if (al instanceof BTraceAtomicLong) {
            return al.getAndDecrement();
        }
        throw new IllegalArgumentException();
    }

    static long incrementAndGet(AtomicLong al) {
        if (al instanceof BTraceAtomicLong) {
            return al.incrementAndGet();
        }
        throw new IllegalArgumentException();
    }

    static long decrementAndGet(AtomicLong al) {
        if (al instanceof BTraceAtomicLong) {
            return al.decrementAndGet();
        }
        throw new IllegalArgumentException();
    }

    static long getAndAdd(AtomicLong al, long i) {
        if (al instanceof BTraceAtomicLong) {
            return al.getAndAdd(i);
        }
        throw new IllegalArgumentException();
    }

    static long addAndGet(AtomicLong al, long i) {
        if (al instanceof BTraceAtomicLong) {
            return al.addAndGet(i);
        }
        throw new IllegalArgumentException();
    }

    static long getAndSet(AtomicLong al, long i) {
        if (al instanceof BTraceAtomicLong) {
            return al.getAndSet(i);
        }
        throw new IllegalArgumentException();
    }

    static int perfInt(String name) {
        return BTraceRuntime.getRt().perfInt(name);
    }

    static long perfLong(String name) {
        return BTraceRuntime.getRt().perfLong(name);
    }

    static String perfString(String name) {
        return BTraceRuntime.getRt().perfString(name);
    }

    private static String stackTraceAllStr(int numFrames, boolean printWarning) {
        Set<Map.Entry<Thread, StackTraceElement[]>> traces = Thread.getAllStackTraces().entrySet();
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> t : traces) {
            buf.append(t.getKey());
            buf.append(LINE_SEPARATOR);
            buf.append(LINE_SEPARATOR);
            StackTraceElement[] st = t.getValue();
            buf.append(BTraceRuntime.stackTraceStr("\t", st, 0, numFrames, printWarning));
            buf.append(LINE_SEPARATOR);
        }
        return buf.toString();
    }

    static String stackTraceAllStr(int numFrames) {
        return BTraceRuntime.stackTraceAllStr(numFrames, false);
    }

    static void stackTraceAll(int numFrames) {
        BTraceRuntime.getRt().send(BTraceRuntime.stackTraceAllStr(numFrames, true));
    }

    static String stackTraceStr(StackTraceElement[] st, int strip, int numFrames) {
        return BTraceRuntime.stackTraceStr(null, st, strip, numFrames, false);
    }

    static String stackTraceStr(String prefix, StackTraceElement[] st, int strip, int numFrames) {
        return BTraceRuntime.stackTraceStr(prefix, st, strip, numFrames, false);
    }

    private static String stackTraceStr(String prefix, StackTraceElement[] st, int strip, int numFrames, boolean printWarning) {
        strip = strip > 0 ? strip + 1 : 0;
        numFrames = numFrames > 0 ? numFrames : st.length - strip;
        int limit = strip + numFrames;
        limit = Math.min(limit, st.length);
        if (prefix == null) {
            prefix = "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = strip; i < limit; ++i) {
            buf.append(prefix);
            buf.append(st[i]);
            buf.append(LINE_SEPARATOR);
        }
        if (printWarning && limit < st.length) {
            buf.append(prefix);
            buf.append(st.length - limit);
            buf.append(" more frame(s) ...");
            buf.append(LINE_SEPARATOR);
        }
        return buf.toString();
    }

    static void stackTrace(StackTraceElement[] st, int strip, int numFrames) {
        BTraceRuntime.stackTrace(null, st, strip, numFrames);
    }

    static void stackTrace(String prefix, StackTraceElement[] st, int strip, int numFrames) {
        BTraceRuntime.getRt().send(BTraceRuntime.stackTraceStr(prefix, st, strip, numFrames, true));
    }

    static void print(String str) {
        BTraceRuntime.getRt().send(str);
    }

    static void println(String str) {
        BTraceRuntime.getRt().send(str + LINE_SEPARATOR);
    }

    static void println() {
        BTraceRuntime.getRt().send(LINE_SEPARATOR);
    }

    static String property(String name) {
        return AccessController.doPrivileged(new GetPropertyAction(name));
    }

    static Properties properties() {
        return AccessController.doPrivileged(() -> System.getProperties());
    }

    static String getenv(String name) {
        return AccessController.doPrivileged(() -> System.getenv(name));
    }

    static Map<String, String> getenv() {
        return AccessController.doPrivileged(() -> System.getenv());
    }

    static MemoryUsage heapUsage() {
        return BTraceRuntime.getRt().getMemoryMXBean().getHeapMemoryUsage();
    }

    static MemoryUsage nonHeapUsage() {
        return BTraceRuntime.getRt().getMemoryMXBean().getNonHeapMemoryUsage();
    }

    static long finalizationCount() {
        return BTraceRuntime.getRt().getMemoryMXBean().getObjectPendingFinalizationCount();
    }

    static long vmStartTime() {
        return BTraceRuntime.getRt().getRuntimeMXBean().getStartTime();
    }

    static long vmUptime() {
        return BTraceRuntime.getRt().getRuntimeMXBean().getUptime();
    }

    static List<String> getInputArguments() {
        return BTraceRuntime.getRt().getRuntimeMXBean().getInputArguments();
    }

    static String getVmVersion() {
        return BTraceRuntime.getRt().getRuntimeMXBean().getVmVersion();
    }

    static boolean isBootClassPathSupported() {
        return BTraceRuntime.getRt().getRuntimeMXBean().isBootClassPathSupported();
    }

    static String getBootClassPath() {
        return BTraceRuntime.getRt().getRuntimeMXBean().getBootClassPath();
    }

    static long getThreadCount() {
        return BTraceRuntime.getRt().getThreadMXBean().getThreadCount();
    }

    static long getPeakThreadCount() {
        return BTraceRuntime.getRt().getThreadMXBean().getPeakThreadCount();
    }

    static long getTotalStartedThreadCount() {
        return BTraceRuntime.getRt().getThreadMXBean().getTotalStartedThreadCount();
    }

    static long getDaemonThreadCount() {
        return BTraceRuntime.getRt().getThreadMXBean().getDaemonThreadCount();
    }

    static long getCurrentThreadCpuTime() {
        ThreadMXBean threadMXBean = BTraceRuntime.getRt().getThreadMXBean();
        threadMXBean.setThreadCpuTimeEnabled(true);
        return threadMXBean.getCurrentThreadCpuTime();
    }

    static long getCurrentThreadUserTime() {
        ThreadMXBean threadMXBean = BTraceRuntime.getRt().getThreadMXBean();
        threadMXBean.setThreadCpuTimeEnabled(true);
        return threadMXBean.getCurrentThreadUserTime();
    }

    static void dumpHeap(String fileName, boolean live) {
        try {
            String name = BTraceRuntime.getRt().resolveFileName(fileName);
            BTraceRuntime.getRt().getHotspotMBean().dumpHeap(name, live);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    static long getTotalGcTime() {
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean gcBean : BTraceRuntime.getRt().getGCMBeans()) {
            totalGcTime += gcBean.getCollectionTime();
        }
        return totalGcTime;
    }

    static String getMemoryPoolUsage(String poolFormat) {
        if (poolFormat == null) {
            poolFormat = "%1$s;%2$d;%3$d;%4$d;%5$d";
        }
        List<MemoryPoolMXBean> memPoolList = BTraceRuntime.getRt().getMemoryPoolMXBeans();
        Object[][] poolOutput = new Object[memPoolList.size()][5];
        StringBuilder membuffer = new StringBuilder();
        for (int i = 0; i < memPoolList.size(); ++i) {
            MemoryPoolMXBean memPool = memPoolList.get(i);
            poolOutput[i][0] = memPool.getName();
            poolOutput[i][1] = memPool.getUsage().getMax();
            poolOutput[i][2] = memPool.getUsage().getUsed();
            poolOutput[i][3] = memPool.getUsage().getCommitted();
            poolOutput[i][4] = memPool.getUsage().getInit();
        }
        for (Object[] memPoolOutput : poolOutput) {
            membuffer.append(String.format(poolFormat, memPoolOutput)).append("\n");
        }
        return membuffer.toString();
    }

    static double getSystemLoadAverage() {
        return BTraceRuntime.getRt().getOperatingSystemMXBean().getSystemLoadAverage();
    }

    static long getProcessCPUTime() {
        OperatingSystemMXBean mbean = BTraceRuntime.getRt().getOperatingSystemMXBean();
        if (mbean instanceof com.sun.management.OperatingSystemMXBean) {
            return ((com.sun.management.OperatingSystemMXBean)mbean).getProcessCpuTime();
        }
        return -1L;
    }

    static void serialize(Object obj, String fileName) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(BTraceRuntime.getRt().resolveFileName(fileName)));
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(obj);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    static String toXML(Object obj) {
        return BTraceRuntime.getRt().toXML(obj);
    }

    static void writeXML(Object obj, String fileName) {
        BTraceRuntime.getRt().writeXML(obj, fileName);
    }

    static void writeDOT(Object obj, String fileName) {
        BTraceRuntime.getRt().writeDOT(obj, fileName);
    }

    static void deadlocks(boolean stackTrace) {
        long[] tids;
        ThreadMXBean mbean = BTraceRuntime.getRt().getThreadMXBean();
        if (mbean.isSynchronizerUsageSupported() && (tids = mbean.findDeadlockedThreads()) != null && tids.length > 0) {
            ThreadInfo[] infos = mbean.getThreadInfo(tids, true, true);
            StringBuilder sb = new StringBuilder();
            for (ThreadInfo ti : infos) {
                sb.append("\"").append(ti.getThreadName()).append("\" Id=").append(ti.getThreadId()).append(" in ").append((Object)ti.getThreadState());
                if (ti.getLockName() != null) {
                    sb.append(" on lock=").append(ti.getLockName());
                }
                if (ti.isSuspended()) {
                    sb.append(" (suspended)");
                }
                if (ti.isInNative()) {
                    sb.append(" (running in native)");
                }
                if (ti.getLockOwnerName() != null) {
                    sb.append(INDENT).append(" owned by ").append(ti.getLockOwnerName()).append(" Id=").append(ti.getLockOwnerId());
                    sb.append(LINE_SEPARATOR);
                }
                if (stackTrace) {
                    StackTraceElement[] stacktrace = ti.getStackTrace();
                    MonitorInfo[] monitors = ti.getLockedMonitors();
                    for (int i = 0; i < stacktrace.length; ++i) {
                        StackTraceElement ste = stacktrace[i];
                        sb.append(INDENT).append("at ").append(ste);
                        sb.append(LINE_SEPARATOR);
                        for (MonitorInfo mi : monitors) {
                            if (mi.getLockedStackDepth() != i) continue;
                            sb.append(INDENT).append("  - locked ").append(mi);
                            sb.append(LINE_SEPARATOR);
                        }
                    }
                    sb.append(LINE_SEPARATOR);
                }
                LockInfo[] locks = ti.getLockedSynchronizers();
                sb.append(INDENT).append("Locked synchronizers: count = ").append(locks.length);
                sb.append(LINE_SEPARATOR);
                for (LockInfo li : locks) {
                    sb.append(INDENT).append("  - ").append(li);
                    sb.append(LINE_SEPARATOR);
                }
                sb.append(LINE_SEPARATOR);
            }
            BTraceRuntime.getRt().send(sb.toString());
        }
    }

    static int dtraceProbe(String s1, String s2, int i1, int i2) {
        if (BTraceRuntime.getRt().isDTraceEnabled()) {
            return BTraceRuntime.dtraceProbe0(s1, s2, i1, i2);
        }
        return 0;
    }

    public static JfrEvent.Factory createEventFactory(JfrEvent.Template template) {
        return BTraceRuntime.getRt().createEventFactory(template);
    }

    static Aggregation newAggregation(AggregationFunction type) {
        return new Aggregation(type);
    }

    static AggregationKey newAggregationKey(Object ... elements) {
        return new AggregationKey(elements);
    }

    static void addToAggregation(Aggregation aggregation, long value) {
        aggregation.add(value);
    }

    static void addToAggregation(Aggregation aggregation, AggregationKey key, long value) {
        aggregation.add(key, value);
    }

    static void clearAggregation(Aggregation aggregation) {
        aggregation.clear();
    }

    static void truncateAggregation(Aggregation aggregation, int count) {
        aggregation.truncate(count);
    }

    static void printAggregation(String name, Aggregation aggregation) {
        BTraceRuntime.getRt().send(new GridDataCommand(name, aggregation.getData()));
    }

    static void printSnapshot(String name, Profiler.Snapshot snapshot) {
        BTraceRuntime.getRt().send(new GridDataCommand(name, snapshot.getGridData()));
    }

    static void printSnapshot(String name, Profiler.Snapshot snapshot, String format) {
        BTraceRuntime.getRt().send(new GridDataCommand(name, snapshot.getGridData(), format));
    }

    static void printAggregation(String name, String format, Aggregation[] aggregationArray) {
        if (aggregationArray.length > 1 && aggregationArray[0].getKeyData().size() > 1) {
            int aggregationDataSize = aggregationArray[0].getKeyData().get(0).getElements().length + aggregationArray.length;
            ArrayList<Object[]> aggregationData = new ArrayList<Object[]>();
            for (AggregationKey aggKey : aggregationArray[0].getKeyData()) {
                int aggDataIndex = 0;
                Object[] currAggregationData = new Object[aggregationDataSize];
                Object[] objectArray = aggKey.getElements();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object obj;
                    currAggregationData[aggDataIndex] = obj = objectArray[i];
                    ++aggDataIndex;
                }
                for (Aggregation agg : aggregationArray) {
                    currAggregationData[aggDataIndex] = agg.getValueForKey(aggKey);
                    ++aggDataIndex;
                }
                aggregationData.add(currAggregationData);
            }
            BTraceRuntime.getRt().send(new GridDataCommand(name, aggregationData, format));
        }
    }

    static void printAggregation(String name, Aggregation aggregation, String format) {
        BTraceRuntime.getRt().send(new GridDataCommand(name, aggregation.getData(), format));
    }

    static Profiler newProfiler() {
        return BTraceRuntime.getRt().newProfiler();
    }

    static Profiler newProfiler(int expectedMethodCnt) {
        return BTraceRuntime.getRt().newProfiler(expectedMethodCnt);
    }

    static void recordEntry(Profiler profiler, String methodName) {
        profiler.recordEntry(methodName);
    }

    static void recordExit(Profiler profiler, String methodName, long duration) {
        profiler.recordExit(methodName, duration);
    }

    static Profiler.Snapshot snapshot(Profiler profiler) {
        return profiler.snapshot();
    }

    static Profiler.Snapshot snapshotAndReset(Profiler profiler) {
        return profiler.snapshot(true);
    }

    static void resetProfiler(Profiler profiler) {
        profiler.reset();
    }

    static ClassLoader getCallerClassloader(int stackDec) {
        return BTraceRuntime.getRt().getCallerClassLoader(stackDec + 1);
    }

    public static Class<?> getCallerClass(int stackDec) {
        return BTraceRuntime.getRt().getCallerClass(stackDec + 1);
    }

    private static native int dtraceProbe0(String var0, String var1, int var2, int var3);

    static {
        unsafe = null;
        rtAccessor = () -> null;
        LINE_SEPARATOR = System.getProperty("line.separator");
    }

    private static final class BTraceAtomicLong
    extends AtomicLong {
        BTraceAtomicLong(long initVal) {
            super(initVal);
        }
    }

    private static final class BTraceAtomicInteger
    extends AtomicInteger {
        BTraceAtomicInteger(int initVal) {
            super(initVal);
        }
    }

    public static interface BTraceRuntimeAccessor {
        public Impl getRt();
    }

    public static interface Impl {
        public void send(String var1);

        public void send(Command var1);

        public boolean enter();

        public void leave();

        public int getInstrumentationLevel();

        public void setInstrumentationLevel(int var1);

        public void handleException(Throwable var1);

        public int speculation();

        public void speculate(int var1);

        public void commit(int var1);

        public void discard(int var1);

        public void exit(int var1);

        public long sizeof(Object var1);

        public int $length();

        public String $(int var1);

        public String $(String var1);

        public String toXML(Object var1);

        public void writeXML(Object var1, String var2);

        public void writeDOT(Object var1, String var2);

        public Profiler newProfiler();

        public Profiler newProfiler(int var1);

        public int perfInt(String var1);

        public long perfLong(String var1);

        public String perfString(String var1);

        public String resolveFileName(String var1);

        public boolean isDTraceEnabled();

        public void handleEvent(EventCommand var1);

        public void handleExit(int var1);

        public void shutdownCmdLine();

        public List<MemoryPoolMXBean> getMemoryPoolMXBeans();

        public HotSpotDiagnosticMXBean getHotspotMBean();

        public MemoryMXBean getMemoryMXBean();

        public RuntimeMXBean getRuntimeMXBean();

        public ThreadMXBean getThreadMXBean();

        public OperatingSystemMXBean getOperatingSystemMXBean();

        public List<GarbageCollectorMXBean> getGCMBeans();

        public Class<?> defineClass(byte[] var1, boolean var2);

        public ClassLoader getCallerClassLoader(int var1);

        public Class<?> getCallerClass(int var1);

        public JfrEvent.Factory createEventFactory(JfrEvent.Template var1);

        public int version();
    }
}

