/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core.aggregation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openjdk.btrace.core.aggregation.AggregationFunction;
import org.openjdk.btrace.core.aggregation.AggregationKey;
import org.openjdk.btrace.core.aggregation.AggregationValue;

public class Aggregation
implements Cloneable {
    private static final AggregationKey NULL_AGGREGATION_KEY = new AggregationKey(new Object[0]);
    private final AggregationFunction type;
    private final ConcurrentHashMap<AggregationKey, AggregationValue> values = new ConcurrentHashMap();

    public Aggregation(AggregationFunction type) {
        this.type = type;
    }

    public void add(long data) {
        this.add(NULL_AGGREGATION_KEY, data);
    }

    public void add(AggregationKey key, long data) {
        AggregationValue existing;
        AggregationValue aggregationValue = this.values.get(key);
        if (aggregationValue == null && (existing = this.values.putIfAbsent(key, aggregationValue = this.type.newValue())) != null) {
            aggregationValue = existing;
        }
        aggregationValue.add(data);
    }

    public void clear() {
        for (AggregationValue value : this.values.values()) {
            value.clear();
        }
    }

    public void truncate(int count) {
        if (count == 0) {
            this.values.clear();
        } else {
            List<Map.Entry<AggregationKey, AggregationValue>> sortedContents = this.sort();
            int collectionSize = sortedContents.size();
            int numberToRemove = collectionSize - Math.abs(count);
            if (numberToRemove < 0) {
                return;
            }
            List<Map.Entry<AggregationKey, AggregationValue>> removeContents = count > 0 ? sortedContents.subList(0, numberToRemove) : sortedContents.subList(collectionSize - numberToRemove, collectionSize);
            for (Map.Entry<AggregationKey, AggregationValue> removeContent : removeContents) {
                this.values.remove(removeContent.getKey());
            }
        }
    }

    public List<Object[]> getData() {
        List<Map.Entry<AggregationKey, AggregationValue>> sortedContents = this.sort();
        ArrayList<Object[]> result = new ArrayList<Object[]>(sortedContents.size());
        for (Map.Entry<AggregationKey, AggregationValue> item : sortedContents) {
            Object[] keyElements = item.getKey().getElements();
            int rowSize = keyElements.length + 1;
            Object[] row = new Object[rowSize];
            System.arraycopy(keyElements, 0, row, 0, keyElements.length);
            row[rowSize - 1] = item.getValue().getData();
            result.add(row);
        }
        return result;
    }

    public List<AggregationKey> getKeyData() {
        ArrayList<AggregationKey> keyList = new ArrayList<AggregationKey>();
        List<Map.Entry<AggregationKey, AggregationValue>> sortedContents = this.sort();
        for (Map.Entry<AggregationKey, AggregationValue> item : sortedContents) {
            keyList.add(item.getKey());
        }
        return keyList;
    }

    public Long getValueForKey(AggregationKey key) {
        AggregationValue aggregationValue = this.values.get(key);
        if (aggregationValue != null) {
            return aggregationValue.getValue();
        }
        return 0L;
    }

    private List<Map.Entry<AggregationKey, AggregationValue>> sort() {
        ArrayList<Map.Entry<AggregationKey, AggregationValue>> result = new ArrayList<Map.Entry<AggregationKey, AggregationValue>>(this.values.entrySet());
        result.sort((o1, o2) -> {
            long i2;
            long i1 = ((AggregationValue)o1.getValue()).getValue();
            if (i1 < (i2 = ((AggregationValue)o2.getValue()).getValue())) {
                return -1;
            }
            if (i1 == i2) {
                return 0;
            }
            return 1;
        });
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        return new Aggregation(this.type);
    }
}

