/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core.aggregation;

import java.util.concurrent.atomic.AtomicLong;
import org.openjdk.btrace.core.aggregation.AggregationValue;
import org.openjdk.btrace.core.aggregation.HistogramData;

class Quantize
implements AggregationValue {
    private static final int ZERO_INDEX = 64;
    private final AtomicLong[] buckets = new AtomicLong[128];

    public Quantize() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new AtomicLong();
        }
    }

    static int logBase2(long value) {
        int pos = 0;
        for (int off = 32; off > 0; off >>= 1) {
            if (value < 1L << off) continue;
            value >>= off;
            pos += off;
        }
        return pos;
    }

    private static int getBucketIndex(long data) {
        if (data == 0L) {
            return 64;
        }
        if (data > 0L) {
            return 65 + Quantize.logBase2(data);
        }
        if (data == Integer.MIN_VALUE) {
            return 0;
        }
        return 63 - Quantize.logBase2(-data);
    }

    private static long getBucketLabel(int index) {
        if (index == 64) {
            return 0L;
        }
        if (index == 0) {
            return Long.MIN_VALUE;
        }
        if (index > 64) {
            index = index - 64 - 1;
            return 1L << index;
        }
        index = 64 - index - 1;
        return -(1L << index);
    }

    @Override
    public void add(long data) {
        int pos = Quantize.getBucketIndex(data);
        this.buckets[pos].incrementAndGet();
    }

    @Override
    public long getValue() {
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            long value = this.buckets[i].get();
            if (value <= 0L) continue;
            return Quantize.getBucketLabel(i);
        }
        return 0L;
    }

    @Override
    public void clear() {
        for (AtomicLong bucket : this.buckets) {
            bucket.set(0L);
        }
    }

    @Override
    public HistogramData getData() {
        int minIndex = this.buckets.length;
        int maxIndex = -1;
        for (int i = 0; i < this.buckets.length; ++i) {
            if (this.buckets[i].get() == 0L) continue;
            minIndex = Math.min(i, minIndex);
            maxIndex = Math.max(i, maxIndex);
        }
        if (minIndex > maxIndex) {
            return null;
        }
        if (maxIndex < this.buckets.length - 1) {
            ++maxIndex;
        }
        if (minIndex > 0) {
            --minIndex;
        }
        int rows = maxIndex - minIndex + 1;
        long[] values = new long[rows];
        long[] counts = new long[rows];
        for (int i = 0; i < rows; ++i) {
            values[i] = Quantize.getBucketLabel(minIndex + i);
            counts[i] = this.buckets[minIndex + i].get();
        }
        return new HistogramData(values, counts);
    }
}

