/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core.comm;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.comm.Command;

public class InstrumentCommand
extends Command {
    private byte[] code;
    private ArgsMap args;

    public InstrumentCommand(byte[] code, ArgsMap args) {
        super((byte)3, true);
        this.code = code;
        this.args = args;
    }

    public InstrumentCommand(byte[] code, String[] args) {
        this(code, new ArgsMap(args));
    }

    public InstrumentCommand(byte[] code, Map<String, String> args) {
        this(code, new ArgsMap(args));
    }

    protected InstrumentCommand() {
        this(null, (Map<String, String>)null);
    }

    @Override
    protected void write(ObjectOutput out) throws IOException {
        out.writeInt(this.code.length);
        out.write(this.code);
        out.writeInt(this.args.size());
        for (Map.Entry<String, String> e : this.args) {
            out.writeUTF(e.getKey());
            String val = e.getValue();
            out.writeUTF(val != null ? val : "");
        }
    }

    @Override
    protected void read(ObjectInput in) throws IOException {
        int len = in.readInt();
        this.code = new byte[len];
        in.readFully(this.code);
        len = in.readInt();
        this.args = new ArgsMap(len);
        for (int i = 0; i < len; ++i) {
            String key = in.readUTF();
            String val = in.readUTF();
            this.args.put(key, val);
        }
    }

    public byte[] getCode() {
        return this.code;
    }

    public ArgsMap getArguments() {
        return this.args;
    }
}

