/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.core.comm;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openjdk.btrace.core.comm.Command;
import org.openjdk.btrace.core.comm.DisconnectCommand;
import org.openjdk.btrace.core.comm.ErrorCommand;
import org.openjdk.btrace.core.comm.EventCommand;
import org.openjdk.btrace.core.comm.ExitCommand;
import org.openjdk.btrace.core.comm.GridDataCommand;
import org.openjdk.btrace.core.comm.InstrumentCommand;
import org.openjdk.btrace.core.comm.ListProbesCommand;
import org.openjdk.btrace.core.comm.MessageCommand;
import org.openjdk.btrace.core.comm.NumberDataCommand;
import org.openjdk.btrace.core.comm.NumberMapDataCommand;
import org.openjdk.btrace.core.comm.ReconnectCommand;
import org.openjdk.btrace.core.comm.RenameCommand;
import org.openjdk.btrace.core.comm.RetransformClassNotification;
import org.openjdk.btrace.core.comm.RetransformationStartNotification;
import org.openjdk.btrace.core.comm.SetSettingsCommand;
import org.openjdk.btrace.core.comm.StatusCommand;
import org.openjdk.btrace.core.comm.StringMapDataCommand;

public class WireIO {
    public static final int VERSION = 1;

    private WireIO() {
    }

    public static Command read(ObjectInput in) throws IOException {
        Command cmd;
        byte type = in.readByte();
        switch (type) {
            case 0: {
                cmd = new ErrorCommand();
                break;
            }
            case 1: {
                cmd = new EventCommand();
                break;
            }
            case 2: {
                cmd = new ExitCommand();
                break;
            }
            case 3: {
                cmd = new InstrumentCommand();
                break;
            }
            case 4: {
                cmd = new MessageCommand();
                break;
            }
            case 5: {
                cmd = new RenameCommand();
                break;
            }
            case 6: {
                cmd = new StatusCommand();
                break;
            }
            case 7: {
                cmd = new NumberMapDataCommand();
                break;
            }
            case 8: {
                cmd = new StringMapDataCommand();
                break;
            }
            case 9: {
                cmd = new NumberDataCommand();
                break;
            }
            case 10: {
                cmd = new GridDataCommand();
                break;
            }
            case 11: {
                cmd = new RetransformationStartNotification();
                break;
            }
            case 12: {
                cmd = new RetransformClassNotification();
                break;
            }
            case 13: {
                cmd = new SetSettingsCommand();
                break;
            }
            case 14: {
                cmd = new ListProbesCommand();
                break;
            }
            case 15: {
                cmd = new DisconnectCommand();
                break;
            }
            case 16: {
                cmd = new ReconnectCommand();
                break;
            }
            default: {
                throw new RuntimeException("invalid command: " + type);
            }
        }
        try {
            cmd.read(in);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ObjectOutput out, Command cmd) throws IOException {
        ObjectOutput objectOutput = out;
        synchronized (objectOutput) {
            out.writeByte(cmd.getType());
            cmd.write(out);
            if (cmd.isUrgent()) {
                out.flush();
            }
        }
    }
}

