/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.instr.InstrumentUtils;
import org.openjdk.btrace.instr.MethodInstrumentor;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;

public class ArrayAllocInstrumentor
extends MethodInstrumentor {
    public ArrayAllocInstrumentor(ClassLoader cl, MethodVisitor mv, MethodInstrumentorHelper mHelper, String parentClz, String superClz, int access, String name, String desc) {
        super(cl, mv, mHelper, parentClz, superClz, access, name, desc);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        String desc = null;
        if (opcode == 188) {
            desc = InstrumentUtils.arrayDescriptorFor(operand);
            this.onBeforeArrayNew(this.getPlainType(desc), 1);
        }
        super.visitIntInsn(opcode, operand);
        if (opcode == 188) {
            this.onAfterArrayNew(this.getPlainType(desc), 1);
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        if (opcode == 189) {
            this.onBeforeArrayNew("L" + desc + ";", 1);
        }
        super.visitTypeInsn(opcode, desc);
        if (opcode == 189) {
            this.onAfterArrayNew("L" + desc + ";", 1);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        String type = this.getPlainType(desc);
        this.onBeforeArrayNew(type, dims);
        super.visitMultiANewArrayInsn(desc, dims);
        this.onAfterArrayNew(type, dims);
    }

    protected void onBeforeArrayNew(String desc, int dims) {
        this.asm.println("before allocating " + desc);
    }

    protected void onAfterArrayNew(String desc, int dims) {
        this.asm.dup().printObject();
    }

    private String getPlainType(String desc) {
        int index = desc.lastIndexOf(91) + 1;
        if (index > 0) {
            return desc.substring(index);
        }
        return desc;
    }
}

