/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.openjdk.btrace.instr.BTraceClassReader;
import org.openjdk.btrace.instr.ClassCache;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;

public final class ClassInfo {
    private static final Logger log = LoggerFactory.getLogger(ClassInfo.class);
    private static final ClassLoader SYS_CL = ClassLoader.getSystemClassLoader();
    private static volatile Method BSTRP_CHECK_MTD;
    private final String cLoaderId;
    private final ClassName classId;
    private final Collection<ClassInfo> supertypes = new ArrayList<ClassInfo>();
    private final ClassCache cache;
    private boolean isInterface = false;
    private boolean isAvailable = false;

    ClassInfo(ClassCache cache, Class<?> clz) {
        this.cache = cache;
        ClassLoader cl = clz.getClassLoader();
        this.cLoaderId = cl != null ? cl.toString() : "<null>";
        this.classId = new ClassName(clz.getName());
        Class<?> supr = clz.getSuperclass();
        if (supr != null) {
            this.supertypes.add(cache.get(supr));
        }
        for (Class<?> itfc : clz.getInterfaces()) {
            if (itfc == null) continue;
            this.supertypes.add(cache.get(itfc));
        }
        this.isInterface = clz.isInterface();
        this.isAvailable = true;
    }

    ClassInfo(ClassCache cache, ClassLoader cl, ClassName cName) {
        this.cache = cache;
        this.cLoaderId = cl != null ? cl.toString() : "<null>";
        this.classId = cName;
        this.loadExternalClass(cl, cName);
    }

    private static ClassLoader inferClassLoader(ClassLoader initiating, ClassName className) {
        if (className == null) {
            return initiating;
        }
        String jClassName = className.getJavaClassName().toString();
        if (initiating == null || ClassInfo.isBootstrap(jClassName)) {
            return null;
        }
        String rsrcName = className.getResourcePath();
        ClassLoader prev = initiating;
        for (ClassLoader cl = initiating; cl != null; cl = cl.getParent()) {
            try {
                if (cl.getResource(rsrcName) == null) {
                    return prev;
                }
            }
            catch (Throwable t) {
                log.warn("Failed to get resource {}", (Object)rsrcName, (Object)t);
            }
            prev = cl;
        }
        return initiating;
    }

    private static boolean isBootstrap(String className) {
        try {
            Method m3 = ClassInfo.getCheckBootstrap();
            if (m3 != null) {
                return m3.invoke((Object)SYS_CL, className) != null;
            }
        }
        catch (Throwable t) {
            log.warn("Unable to check for class {} being loaded by bootstrap classloader", (Object)className, (Object)t);
        }
        return false;
    }

    private static Method getCheckBootstrap() {
        if (BSTRP_CHECK_MTD != null) {
            return BSTRP_CHECK_MTD;
        }
        Method m3 = null;
        try {
            m3 = ClassLoader.class.getDeclaredMethod("findBootstrapClassOrNull", String.class);
            m3.setAccessible(true);
        }
        catch (Throwable t) {
            log.warn("Can not resolve method 'findBootstrapClassOrNull'", t);
        }
        BSTRP_CHECK_MTD = m3;
        return BSTRP_CHECK_MTD;
    }

    public Collection<ClassInfo> getSupertypes(boolean onlyDirect) {
        if (onlyDirect) {
            return this.supertypes;
        }
        LinkedHashSet<ClassInfo> supers = new LinkedHashSet<ClassInfo>(this.supertypes);
        for (ClassInfo ci : this.supertypes) {
            supers.addAll(ci.getSupertypes(onlyDirect));
        }
        return supers;
    }

    public String getLoaderId() {
        return this.cLoaderId;
    }

    public String getClassName() {
        return this.classId.getInternalClassName().toString();
    }

    public String getJavaClassName() {
        return this.classId.getJavaClassName().toString();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    private void loadExternalClass(ClassLoader cl, ClassName className) {
        String resourcePath = className.getResourcePath();
        try {
            InputStream typeIs;
            InputStream inputStream = typeIs = cl == null ? SYS_CL.getResourceAsStream(resourcePath) : cl.getResourceAsStream(resourcePath);
            if (typeIs != null) {
                try {
                    BTraceClassReader cr = new BTraceClassReader(cl, typeIs);
                    this.isInterface = cr.isInterface();
                    String[] info = cr.readClassSupers();
                    String superName = info[0];
                    if (superName != null) {
                        ClassName superClassName = new ClassName(superName);
                        this.supertypes.add(this.cache.get(ClassInfo.inferClassLoader(cl, superClassName), superClassName));
                    }
                    if (info.length > 1) {
                        for (int i = 1; i < info.length; ++i) {
                            String ifc = info[i];
                            if (ifc == null) continue;
                            ClassName ifcClassName = new ClassName(ifc);
                            this.supertypes.add(this.cache.get(ClassInfo.inferClassLoader(cl, ifcClassName), ifcClassName));
                        }
                    }
                    this.isAvailable = true;
                }
                catch (IOException | IllegalArgumentException e) {
                    log.warn("Unable to load class: {}", (Object)className, (Object)e);
                }
            }
        }
        catch (Throwable t) {
            log.warn("Failed to load class {}", (Object)className, (Object)t);
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.cLoaderId);
        hash = 37 * hash + Objects.hashCode(this.classId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassInfo other = (ClassInfo)obj;
        if (!Objects.equals(this.cLoaderId, other.cLoaderId)) {
            return false;
        }
        return Objects.equals(this.classId, other.classId);
    }

    public String toString() {
        return "ClassInfo{cLoaderId=" + this.cLoaderId + ", classId=" + this.classId + ", supertypes=" + this.supertypes + '}';
    }

    static final class ClassName {
        private final CharSequence cName;
        private final JavaClassName jcName;
        private final InternalClassName icName;
        private String rsrcName = null;

        public ClassName(CharSequence cName) {
            this.cName = cName;
            this.jcName = new JavaClassName(cName);
            this.icName = new InternalClassName(cName);
        }

        public CharSequence getJavaClassName() {
            return this.jcName;
        }

        public CharSequence getInternalClassName() {
            return this.icName;
        }

        public String getResourcePath() {
            if (this.rsrcName == null) {
                this.rsrcName = this.icName + ".class";
            }
            return this.rsrcName;
        }

        public String toString() {
            return String.valueOf(this.cName);
        }

        public int hashCode() {
            int h2 = 7;
            int len = this.cName.length();
            for (int i = 0; i < len; ++i) {
                char c = this.cName.charAt(i);
                h2 = 31 * h2 + (c == '.' ? 47 : (int)c);
            }
            return h2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassName other = (ClassName)obj;
            if (this.cName.length() != other.cName.length()) {
                return false;
            }
            block3: for (int i = 0; i < this.cName.length(); ++i) {
                char c1 = this.cName.charAt(i);
                char c2 = other.cName.charAt(i);
                switch (c1) {
                    case '.': 
                    case '/': {
                        if (c2 == '.' || c2 == '/') continue block3;
                        return false;
                    }
                    default: {
                        if (c1 == c2) continue block3;
                        return false;
                    }
                }
            }
            return true;
        }
    }

    private static final class InternalClassName
    extends BaseClassName {
        public InternalClassName(CharSequence wrapped) {
            super(wrapped);
        }

        @Override
        public char charAt(int index) {
            char c = this.wrapped.charAt(index);
            return c == '.' ? (char)'/' : (char)c;
        }
    }

    private static final class JavaClassName
    extends BaseClassName {
        public JavaClassName(CharSequence wrapped) {
            super(wrapped);
        }

        @Override
        public char charAt(int index) {
            char c = this.wrapped.charAt(index);
            return c == '/' ? (char)'.' : (char)c;
        }
    }

    private static abstract class BaseClassName
    implements CharSequence {
        protected final CharSequence wrapped;
        private String str = null;

        protected BaseClassName(CharSequence wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int length() {
            return this.wrapped.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            if (this.str == null) {
                char[] val = new char[this.wrapped.length()];
                for (int i = 0; i < this.wrapped.length(); ++i) {
                    val[i] = this.charAt(i);
                }
                this.str = new String(val);
            }
            return this.str;
        }
    }
}

