/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openjdk.btrace.core.annotations.Sampled;
import org.openjdk.btrace.instr.BTraceMethodNode;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.instr.OnMethod;
import org.openjdk.btrace.instr.StackTrackingMethodVisitor;
import org.openjdk.btrace.instr.Verifier;
import org.openjdk.btrace.libs.org.objectweb.asm.Label;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;
import org.openjdk.btrace.services.api.Service;

final class MethodVerifier
extends StackTrackingMethodVisitor {
    private static final Set<String> PRIMITIVE_WRAPPER_TYPES = new HashSet<String>();
    private static final Set<String> UNBOX_METHODS = new HashSet<String>();
    private final String className;
    private final String methodName;
    private final String methodDesc;
    private final int access;
    private final Map<Label, Label> labels;
    private Object delayedClzLoad = null;

    public MethodVerifier(BTraceMethodNode parent, int access, String className, String methodName, String desc, ClassLoader ctxClassLoader) {
        super(parent, className, desc, (access & 8) == 8);
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = desc;
        this.access = access;
        this.labels = new HashMap<Label, Label>();
    }

    static boolean isPrimitiveWrapper(String type) {
        return PRIMITIVE_WRAPPER_TYPES.contains(type);
    }

    static boolean isUnboxMethod(String name) {
        return UNBOX_METHODS.contains(name);
    }

    private BTraceMethodNode getParent() {
        return (BTraceMethodNode)this.mv;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.getParent().isBTraceHandler()) {
            if ((this.access & 1) == 0 && !this.methodName.equals("<clinit>")) {
                Verifier.reportError("method.should.be.public", this.methodName + this.methodDesc);
            }
            if (!Type.getReturnType(this.methodDesc).equals(Type.VOID_TYPE)) {
                Verifier.reportError("return.type.should.be.void", this.methodName + this.methodDesc);
            }
        }
        this.validateSamplerLocation();
        this.labels.clear();
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 181) {
            Verifier.reportError("no.assignment");
        }
        if (opcode == 179 && !owner.equals(this.className)) {
            Verifier.reportError("no.assignment");
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                Verifier.reportError("no.assignment");
                break;
            }
            case 191: {
                Verifier.reportError("no.throw");
                break;
            }
            case 194: 
            case 195: {
                Verifier.reportError("no.synchronized.blocks");
            }
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (opcode == 188) {
            Verifier.reportError("no.array.creation");
        }
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        if (this.labels.get(label) != null) {
            Verifier.reportError("no.loops");
        }
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.labels.put(label, label);
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            this.delayedClzLoad = cst;
        }
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (!this.isJfrEventType(owner)) {
            switch (opcode) {
                case 182: {
                    List<StackTrackingMethodVisitor.StackItem> args;
                    if (MethodVerifier.isPrimitiveWrapper(owner) && MethodVerifier.isUnboxMethod(name) || owner.equals(Type.getInternalName(StringBuilder.class)) || this.isServiceTarget((args = this.getMethodParams(desc, false)).get(0))) break;
                    Verifier.reportError("no.method.calls", owner + "." + name + desc);
                    break;
                }
                case 185: {
                    Verifier.reportError("no.method.calls", owner + "." + name + desc);
                    break;
                }
                case 183: {
                    if (owner.equals("java/lang/Object") && name.equals("<init>") || owner.equals(Type.getInternalName(StringBuilder.class))) break;
                    Verifier.reportError("no.method.calls", owner + "." + name + desc);
                    break;
                }
                case 184: {
                    if (owner.equals(Constants.SERVICE)) {
                        this.delayedClzLoad = null;
                        break;
                    }
                    if (owner.equals(Constants.BTRACE_UTILS) || owner.startsWith(Constants.BTRACE_UTILS + "$") || owner.equals(this.className) || "valueOf".equals(name) && MethodVerifier.isPrimitiveWrapper(owner)) break;
                    Verifier.reportError("no.method.calls", owner + "." + name + desc);
                }
            }
        }
        if (this.delayedClzLoad != null) {
            Verifier.reportError("no.class.literals", this.delayedClzLoad.toString());
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        Verifier.reportError("no.array.creation");
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        Verifier.reportError("no.catch");
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        if (opcode == 189) {
            Verifier.reportError("no.array.creation", desc);
        }
        if (opcode == 187) {
            if (desc.equals(Type.getInternalName(StringBuilder.class))) {
                super.visitTypeInsn(187, desc);
                return;
            }
            Verifier.reportError("no.new.object", desc);
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (opcode == 169) {
            Verifier.reportError("no.try");
        }
        super.visitVarInsn(opcode, var);
    }

    private boolean isServiceTarget(StackTrackingMethodVisitor.StackItem si) {
        if (si instanceof StackTrackingMethodVisitor.ResultItem) {
            StackTrackingMethodVisitor.ResultItem ri = (StackTrackingMethodVisitor.ResultItem)si;
            if (ri.getOwner().equals(Type.getInternalName(Service.class))) {
                return true;
            }
            if (ri.getOwner().equals(this.className) && this.getParent().isFieldInjected(ri.getName())) {
                return true;
            }
        }
        for (StackTrackingMethodVisitor.StackItem p : si.getParents()) {
            if (!this.isServiceTarget(p)) continue;
            return true;
        }
        return false;
    }

    private void validateSamplerLocation() {
        BTraceMethodNode mn = this.getParent();
        if (!mn.isSampled()) {
            return;
        }
        OnMethod om = mn.getOnMethod();
        if (om == null && mn.isSampled()) {
            Verifier.reportError("sampler.invalid.location", this.methodName + this.methodDesc);
            return;
        }
        if (om != null && om.getSamplerKind() != Sampled.Sampler.None) {
            switch (om.getLocation().getValue()) {
                case ENTRY: 
                case RETURN: 
                case ERROR: 
                case CALL: {
                    break;
                }
                default: {
                    Verifier.reportError("sampler.invalid.location", this.methodName + this.methodDesc);
                }
            }
        }
    }

    private boolean isJfrEventType(String typeName) {
        return "org/openjdk/btrace/core/jfr/JfrEvent".equals(typeName);
    }

    static {
        PRIMITIVE_WRAPPER_TYPES.add("java/lang/Boolean");
        PRIMITIVE_WRAPPER_TYPES.add("java/lang/Byte");
        PRIMITIVE_WRAPPER_TYPES.add("java/lang/Character");
        PRIMITIVE_WRAPPER_TYPES.add("java/lang/Short");
        PRIMITIVE_WRAPPER_TYPES.add("java/lang/Integer");
        PRIMITIVE_WRAPPER_TYPES.add("java/lang/Long");
        PRIMITIVE_WRAPPER_TYPES.add("java/lang/Float");
        PRIMITIVE_WRAPPER_TYPES.add("java/lang/Double");
        UNBOX_METHODS.add("booleanValue");
        UNBOX_METHODS.add("byteValue");
        UNBOX_METHODS.add("charValue");
        UNBOX_METHODS.add("shortValue");
        UNBOX_METHODS.add("intValue");
        UNBOX_METHODS.add("longValue");
        UNBOX_METHODS.add("floatValue");
        UNBOX_METHODS.add("doubleValue");
    }
}

