/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.openjdk.btrace.core.types.AnyType;
import org.openjdk.btrace.instr.Constants;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;

public final class TypeUtils {
    public static final Type objectArrayType = Type.getType(Object[].class);
    public static final Type anyTypeArray = Type.getType(AnyType[].class);
    private static final Map<String, String> primitives = new HashMap<String, String>();

    private TypeUtils() {
    }

    public static boolean isPrimitive(String typeDesc) {
        if (typeDesc.length() == 1) {
            switch (typeDesc.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'Z': {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isPrimitive(Type t) {
        return t == Type.BOOLEAN_TYPE || t == Type.BYTE_TYPE || t == Type.CHAR_TYPE || t == Type.DOUBLE_TYPE || t == Type.FLOAT_TYPE || t == Type.INT_TYPE || t == Type.LONG_TYPE || t == Type.SHORT_TYPE;
    }

    public static boolean isAnyType(Type t) {
        return t.equals(Constants.ANYTYPE_TYPE);
    }

    public static boolean isAnyTypeArray(Type t) {
        return t.equals(anyTypeArray);
    }

    public static boolean isObject(Type t) {
        return t.equals(Constants.OBJECT_TYPE);
    }

    public static boolean isObjectOrAnyType(Type t) {
        return TypeUtils.isObject(t) || TypeUtils.isAnyType(t);
    }

    public static boolean isString(Type t) {
        return t.equals(Constants.STRING_TYPE);
    }

    public static boolean isArray(Type t) {
        return t.getSort() == 9;
    }

    public static boolean isThrowable(Type t) {
        return t.equals(Constants.THROWABLE_TYPE);
    }

    public static boolean isVoid(Type t) {
        return Type.VOID_TYPE.equals(t) || Constants.VOIDREF_TYPE.equals(t);
    }

    public static Type getArrayType(int arrayOpcode) {
        switch (arrayOpcode) {
            case 46: 
            case 79: {
                return Type.getType("[I");
            }
            case 51: 
            case 84: {
                return Type.getType("[B");
            }
            case 50: 
            case 83: {
                return objectArrayType;
            }
            case 52: 
            case 85: {
                return Type.getType("[C");
            }
            case 48: 
            case 81: {
                return Type.getType("[F");
            }
            case 53: 
            case 86: {
                return Type.getType("[S");
            }
            case 47: 
            case 80: {
                return Type.getType("[J");
            }
            case 49: 
            case 82: {
                return Type.getType("[D");
            }
        }
        throw new RuntimeException("invalid array opcode");
    }

    public static Type getElementType(int arrayOpcode) {
        switch (arrayOpcode) {
            case 46: 
            case 79: {
                return Type.INT_TYPE;
            }
            case 51: 
            case 84: {
                return Type.BYTE_TYPE;
            }
            case 50: 
            case 83: {
                return Constants.OBJECT_TYPE;
            }
            case 52: 
            case 85: {
                return Type.CHAR_TYPE;
            }
            case 48: 
            case 81: {
                return Type.FLOAT_TYPE;
            }
            case 53: 
            case 86: {
                return Type.SHORT_TYPE;
            }
            case 47: 
            case 80: {
                return Type.LONG_TYPE;
            }
            case 49: 
            case 82: {
                return Type.DOUBLE_TYPE;
            }
        }
        throw new RuntimeException("invalid array opcode");
    }

    public static String declarationToDescriptor(String decl) {
        String descriptor;
        int leftParen = decl.indexOf(40);
        int rightParen = decl.indexOf(41);
        if (leftParen == -1 || rightParen == -1) {
            throw new IllegalArgumentException();
        }
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        String args = decl.substring(leftParen + 1, rightParen);
        StringTokenizer st = new StringTokenizer(args, ",");
        while (st.hasMoreTokens()) {
            String arg = st.nextToken().trim();
            descriptor = primitives.get(arg);
            if (arg.length() == 0) {
                throw new IllegalArgumentException();
            }
            if (descriptor == null) {
                descriptor = TypeUtils.objectOrArrayType(arg);
            }
            buf.append(descriptor);
        }
        buf.append(')');
        String returnType = decl.substring(0, leftParen).trim();
        descriptor = primitives.get(returnType);
        if (returnType.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (descriptor == null) {
            descriptor = TypeUtils.objectOrArrayType(returnType);
        }
        buf.append(descriptor);
        return buf.toString();
    }

    public static String descriptorToSimplified(String desc, String owner, String name) {
        String retTypeDesc = null;
        Type[] args = null;
        if (desc.contains("(")) {
            retTypeDesc = Type.getReturnType(desc).getDescriptor();
            args = Type.getArgumentTypes(desc);
        } else {
            retTypeDesc = TypeUtils.isPrimitive(desc) ? desc : Type.getType(desc).getDescriptor();
            args = new Type[]{};
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TypeUtils.getJavaType(retTypeDesc)).append(' ').append(owner.replace('/', '.')).append('#').append(name);
        if (args.length > 0) {
            sb.append("(");
            boolean more = false;
            for (Type t : args) {
                if (more) {
                    sb.append(", ");
                } else {
                    more = true;
                }
                sb.append(TypeUtils.getJavaType(t.getDescriptor()));
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static String getJavaType(String desc) {
        int arrIndex = desc.lastIndexOf(91) + 1;
        String string = desc = arrIndex > 0 ? desc.substring(arrIndex) : desc;
        if (desc.startsWith("L")) {
            desc = desc.substring(1, desc.length() - 1).replace('/', '.');
        } else {
            for (Map.Entry<String, String> entry : primitives.entrySet()) {
                if (!entry.getValue().equals(desc)) continue;
                desc = entry.getKey();
                break;
            }
        }
        StringBuilder sb = new StringBuilder(desc);
        for (int i = 0; i < arrIndex; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static String objectOrArrayType(String type) {
        StringBuilder buf = new StringBuilder();
        int index = 0;
        while ((index = type.indexOf("[]", index) + 1) > 0) {
            buf.append('[');
        }
        String t = type.substring(0, type.length() - buf.length() * 2);
        String desc = primitives.get(t);
        if (desc != null) {
            buf.append(desc);
        } else {
            buf.append('L');
            if (t.indexOf(46) < 0) {
                buf.append(t);
            } else {
                buf.append(t.replace('.', '/'));
            }
            buf.append(';');
        }
        return buf.toString();
    }

    static {
        primitives.put("void", "V");
        primitives.put("byte", "B");
        primitives.put("char", "C");
        primitives.put("double", "D");
        primitives.put("float", "F");
        primitives.put("int", "I");
        primitives.put("long", "J");
        primitives.put("short", "S");
        primitives.put("boolean", "Z");
    }
}

