/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.libs.org.jctools.queues.unpadded;

import org.openjdk.btrace.libs.org.jctools.queues.LinkedQueueNode;
import org.openjdk.btrace.libs.org.jctools.queues.MessagePassingQueue;
import org.openjdk.btrace.libs.org.jctools.queues.MessagePassingQueueUtil;
import org.openjdk.btrace.libs.org.jctools.queues.unpadded.BaseLinkedUnpaddedQueue;
import org.openjdk.btrace.libs.org.jctools.util.UnsafeAccess;

public class MpscLinkedUnpaddedQueue<E>
extends BaseLinkedUnpaddedQueue<E> {
    public MpscLinkedUnpaddedQueue() {
        LinkedQueueNode node = this.newNode();
        this.spConsumerNode(node);
        this.xchgProducerNode(node);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        LinkedQueueNode<E> nextNode = this.newNode(e);
        LinkedQueueNode<E> prevProducerNode = this.xchgProducerNode(nextNode);
        prevProducerNode.soNext(nextNode);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        LinkedQueueNode originalConsumerNode;
        if (null == o) {
            return false;
        }
        LinkedQueueNode prevConsumerNode = originalConsumerNode = this.lpConsumerNode();
        LinkedQueueNode currConsumerNode = this.getNextConsumerNode(originalConsumerNode);
        while (currConsumerNode != null) {
            if (o.equals(currConsumerNode.lpValue())) {
                LinkedQueueNode nextNode = this.getNextConsumerNode(currConsumerNode);
                if (nextNode != null) {
                    prevConsumerNode.soNext(nextNode);
                } else {
                    prevConsumerNode.soNext(null);
                    if (!this.casProducerNode(currConsumerNode, prevConsumerNode)) {
                        nextNode = this.spinWaitForNextNode(currConsumerNode);
                        prevConsumerNode.soNext(nextNode);
                    }
                }
                currConsumerNode.soNext(null);
                currConsumerNode.spValue(null);
                return true;
            }
            prevConsumerNode = currConsumerNode;
            currConsumerNode = this.getNextConsumerNode(currConsumerNode);
        }
        return false;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2) {
        return MessagePassingQueueUtil.fillUnbounded(this, s2);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2, int limit) {
        LinkedQueueNode<E> tail;
        if (null == s2) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        LinkedQueueNode<E> head = tail = this.newNode(s2.get());
        for (int i = 1; i < limit; ++i) {
            LinkedQueueNode<E> temp = this.newNode(s2.get());
            tail.spNext(temp);
            tail = temp;
        }
        LinkedQueueNode<E> oldPNode = this.xchgProducerNode(tail);
        oldPNode.soNext(head);
        return limit;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s2, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.fill(this, s2, wait, exit);
    }

    private LinkedQueueNode<E> xchgProducerNode(LinkedQueueNode<E> newVal) {
        LinkedQueueNode oldVal;
        if (UnsafeAccess.SUPPORTS_GET_AND_SET_REF) {
            return (LinkedQueueNode)UnsafeAccess.UNSAFE.getAndSetObject(this, P_NODE_OFFSET, newVal);
        }
        while (!UnsafeAccess.UNSAFE.compareAndSwapObject(this, P_NODE_OFFSET, oldVal = this.lvProducerNode(), newVal)) {
        }
        return oldVal;
    }

    private LinkedQueueNode<E> getNextConsumerNode(LinkedQueueNode<E> currConsumerNode) {
        LinkedQueueNode<E> nextNode = currConsumerNode.lvNext();
        if (nextNode == null && currConsumerNode != this.lvProducerNode()) {
            nextNode = this.spinWaitForNextNode(currConsumerNode);
        }
        return nextNode;
    }
}

