/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jdk.jfr.AnnotationElement;
import jdk.jfr.BooleanFlag;
import jdk.jfr.Category;
import jdk.jfr.DataAmount;
import jdk.jfr.Description;
import jdk.jfr.EventFactory;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Frequency;
import jdk.jfr.Label;
import jdk.jfr.MemoryAddress;
import jdk.jfr.Name;
import jdk.jfr.Percentage;
import jdk.jfr.Period;
import jdk.jfr.Registered;
import jdk.jfr.StackTrace;
import jdk.jfr.Timespan;
import jdk.jfr.Timestamp;
import jdk.jfr.Unsigned;
import jdk.jfr.ValueDescriptor;
import org.openjdk.btrace.core.annotations.Event;
import org.openjdk.btrace.core.jfr.JfrEvent;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;
import org.openjdk.btrace.runtime.JfrEventImpl;

final class JfrEventFactoryImpl
implements JfrEvent.Factory {
    private static final Logger log = LoggerFactory.getLogger(JfrEventFactoryImpl.class);
    private static final Map<String, Class<?>> VALUE_TYPES = new HashMap();
    private static final Map<String, Class<? extends Annotation>> SPECIFICATION_ANNOTATION_TYPES = new HashMap<String, Class<? extends Annotation>>();
    private final EventFactory eventFactory;
    private final Map<String, Integer> fieldIndex = new HashMap<String, Integer>();
    private Runnable periodicHook = null;

    JfrEventFactoryImpl(JfrEvent.Template template) {
        JfrEvent.Template.Field[] fields;
        ArrayList<AnnotationElement> defAnnotations = new ArrayList<AnnotationElement>();
        ArrayList<ValueDescriptor> defFields = new ArrayList<ValueDescriptor>();
        defAnnotations.add(new AnnotationElement(Name.class, template.getName()));
        defAnnotations.add(new AnnotationElement(Registered.class, true));
        defAnnotations.add(new AnnotationElement(StackTrace.class, template.isStacktrace()));
        if (template.getLabel() != null) {
            defAnnotations.add(new AnnotationElement(Label.class, template.getLabel()));
        }
        if (template.getDescription() != null) {
            defAnnotations.add(new AnnotationElement(Description.class, template.getDescription()));
        }
        if (template.getCategory() != null) {
            defAnnotations.add(new AnnotationElement(Category.class, template.getCategory()));
        }
        if (template.getPeriod() != null) {
            defAnnotations.add(new AnnotationElement(Period.class, template.getPeriod()));
        }
        if ((fields = template.getFields()) != null) {
            for (int i = 0; i < fields.length; ++i) {
                Class<? extends Annotation> annotationType;
                JfrEvent.Template.Field field = fields[i];
                ArrayList<AnnotationElement> fieldAnnotations = new ArrayList<AnnotationElement>();
                if (field.getDescription() != null) {
                    fieldAnnotations.add(new AnnotationElement(Description.class, field.getDescription()));
                }
                if (field.getLabel() != null) {
                    fieldAnnotations.add(new AnnotationElement(Label.class, field.getLabel()));
                }
                if (field.getSpecificationName() != null && (annotationType = SPECIFICATION_ANNOTATION_TYPES.get(field.getSpecificationName())) != null) {
                    fieldAnnotations.add(new AnnotationElement(annotationType, field.getSpecificationValue()));
                }
                ValueDescriptor vd = new ValueDescriptor(VALUE_TYPES.get(field.getType()), field.getName(), fieldAnnotations);
                defFields.add(vd);
                this.fieldIndex.put(field.getName(), i);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating event factory: {}", (Object)template.getName());
        }
        this.eventFactory = EventFactory.create(defAnnotations, defFields);
        if (log.isDebugEnabled()) {
            log.debug("Registering event factory: {}", (Object)template.getName());
        }
        this.eventFactory.register();
        if (template.getPeriod() != null && template.getPeriodicHandler() != null) {
            this.addJfrPeriodicEvent(template);
        }
    }

    @Override
    public JfrEvent newEvent() {
        return new JfrEventImpl(this.eventFactory.newEvent(), this.fieldIndex);
    }

    private void addJfrPeriodicEvent(JfrEvent.Template template) {
        try {
            Class<?> handlerClass = Class.forName(template.getOwner());
            final Method handlerMethod = handlerClass.getMethod(template.getPeriodicHandler(), JfrEvent.class);
            Runnable hook = (Runnable)Proxy.newProxyInstance(handlerClass.getClassLoader(), new Class[]{Runnable.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("run")) {
                        try {
                            JfrEvent event = JfrEventFactoryImpl.this.newEvent();
                            return handlerMethod.invoke(null, event);
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.out);
                            throw t;
                        }
                    }
                    return method.invoke((Object)this, args);
                }
            });
            Class<?> eClz = this.eventFactory.newEvent().getClass();
            FlightRecorder.addPeriodicEvent(eClz, hook);
            this.periodicHook = hook;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            StringBuilder msg = new StringBuilder("Unable to register periodic JFR event of type '");
            String eMsg = e.getMessage();
            msg.append(eMsg.replace('/', '.'));
            msg.append("'");
            log.info(msg.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void unregister() {
        if (this.periodicHook != null) {
            FlightRecorder.removePeriodicEvent(this.periodicHook);
        }
        this.eventFactory.unregister();
    }

    static {
        VALUE_TYPES.put(Event.FieldType.BYTE.name(), Byte.TYPE);
        VALUE_TYPES.put(Event.FieldType.BOOLEAN.name(), Boolean.TYPE);
        VALUE_TYPES.put(Event.FieldType.CHAR.name(), Character.TYPE);
        VALUE_TYPES.put(Event.FieldType.INT.name(), Integer.TYPE);
        VALUE_TYPES.put(Event.FieldType.SHORT.name(), Short.TYPE);
        VALUE_TYPES.put(Event.FieldType.FLOAT.name(), Float.TYPE);
        VALUE_TYPES.put(Event.FieldType.LONG.name(), Long.TYPE);
        VALUE_TYPES.put(Event.FieldType.DOUBLE.name(), Double.TYPE);
        VALUE_TYPES.put(Event.FieldType.STRING.name(), String.class);
        SPECIFICATION_ANNOTATION_TYPES.put(Event.FieldKind.TIMESTAMP.name(), Timestamp.class);
        SPECIFICATION_ANNOTATION_TYPES.put(Event.FieldKind.TIMESPAN.name(), Timespan.class);
        SPECIFICATION_ANNOTATION_TYPES.put(Event.FieldKind.DATAAMOUNT.name(), DataAmount.class);
        SPECIFICATION_ANNOTATION_TYPES.put(Event.FieldKind.FREQUENCY.name(), Frequency.class);
        SPECIFICATION_ANNOTATION_TYPES.put(Event.FieldKind.MEMORYADDRESS.name(), MemoryAddress.class);
        SPECIFICATION_ANNOTATION_TYPES.put(Event.FieldKind.PERCENTAGE.name(), Percentage.class);
        SPECIFICATION_ANNOTATION_TYPES.put(Event.FieldKind.BOOLEANFLAG.name(), BooleanFlag.class);
        SPECIFICATION_ANNOTATION_TYPES.put(Event.FieldKind.UNSIGNED.name(), Unsigned.class);
    }
}

