/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.contexts;

import io.kestra.core.contexts.KestraApplicationContext;
import io.kestra.core.plugins.PluginRegistry;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KestraApplicationContextBuilder
implements ApplicationContextConfiguration {
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private final List<String> environments = new ArrayList<String>();
    private final List<String> packages = new ArrayList<String>();
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private PluginRegistry pluginRegistry;

    @NonNull
    public KestraApplicationContextBuilder classLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
        return this;
    }

    @NonNull
    public KestraApplicationContextBuilder mainClass(Class<?> mainClass) {
        if (mainClass != null) {
            String name;
            if (this.classLoader == null) {
                this.classLoader = mainClass.getClassLoader();
            }
            if (StringUtils.isNotEmpty((CharSequence)(name = mainClass.getPackage().getName()))) {
                this.packages(name);
            }
        }
        return this;
    }

    @NonNull
    public KestraApplicationContextBuilder packages(String ... packages) {
        if (packages != null) {
            this.packages.addAll(Arrays.asList(packages));
        }
        return this;
    }

    @NonNull
    public KestraApplicationContextBuilder environments(String ... environments) {
        if (environments != null) {
            this.environments.addAll(Arrays.asList(environments));
        }
        return this;
    }

    @NonNull
    public KestraApplicationContextBuilder properties(@Nullable Map<String, Object> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    @NonNull
    public KestraApplicationContextBuilder pluginRegistry(@Nullable PluginRegistry pluginRegistry) {
        if (pluginRegistry != null) {
            this.pluginRegistry = pluginRegistry;
        }
        return this;
    }

    @NonNull
    public ApplicationContext build() {
        KestraApplicationContext applicationContext = new KestraApplicationContext(this, this.pluginRegistry);
        Environment environment = applicationContext.getEnvironment();
        if (!this.packages.isEmpty()) {
            for (String aPackage : this.packages) {
                environment.addPackage(aPackage);
            }
        }
        if (!this.properties.isEmpty()) {
            PropertySource contextProperties = PropertySource.of((String)"context", this.properties, (int)0);
            environment.addPropertySource(contextProperties);
        }
        return applicationContext;
    }

    @NonNull
    public List<String> getEnvironments() {
        return this.environments;
    }

    public Optional<Boolean> getDeduceEnvironments() {
        return Optional.empty();
    }

    public boolean isEnvironmentPropertySource() {
        return true;
    }

    @Nullable
    public List<String> getEnvironmentVariableIncludes() {
        return null;
    }

    @Nullable
    public List<String> getEnvironmentVariableExcludes() {
        return null;
    }

    @NonNull
    public ConversionService<?> getConversionService() {
        return ConversionService.SHARED;
    }

    @NonNull
    public ClassPathResourceLoader getResourceLoader() {
        return ClassPathResourceLoader.defaultLoader((ClassLoader)this.classLoader);
    }

    @NonNull
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

