/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.endpoints;

import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.Worker;
import io.micronaut.context.annotation.Requires;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import jakarta.inject.Inject;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;

@Endpoint(id="worker", defaultSensitive=false)
@Requires(property="kestra.server-type", pattern="(WORKER|STANDALONE)")
public class WorkerEndpoint {
    @Inject
    Worker worker;

    @Read
    public WorkerEndpointResult running() {
        return WorkerEndpointResult.builder().runningCount(this.worker.getMetricRunningCount().values().stream().mapToInt(AtomicInteger::get).sum()).runnings(this.worker.getWorkerThreadTasks().stream().map(workerTask -> new WorkerEndpointWorkerTask(workerTask.getTaskRun(), workerTask.getTask())).collect(Collectors.toList())).build();
    }

    public static class WorkerEndpointResult {
        private final int runningCount;
        private final List<WorkerEndpointWorkerTask> runnings;

        @ConstructorProperties(value={"runningCount", "runnings"})
        @Generated
        WorkerEndpointResult(int runningCount, List<WorkerEndpointWorkerTask> runnings) {
            this.runningCount = runningCount;
            this.runnings = runnings;
        }

        @Generated
        public static WorkerEndpointResultBuilder builder() {
            return new WorkerEndpointResultBuilder();
        }

        @Generated
        public int getRunningCount() {
            return this.runningCount;
        }

        @Generated
        public List<WorkerEndpointWorkerTask> getRunnings() {
            return this.runnings;
        }

        @Generated
        public static class WorkerEndpointResultBuilder {
            @Generated
            private int runningCount;
            @Generated
            private List<WorkerEndpointWorkerTask> runnings;

            @Generated
            WorkerEndpointResultBuilder() {
            }

            @Generated
            public WorkerEndpointResultBuilder runningCount(int runningCount) {
                this.runningCount = runningCount;
                return this;
            }

            @Generated
            public WorkerEndpointResultBuilder runnings(List<WorkerEndpointWorkerTask> runnings) {
                this.runnings = runnings;
                return this;
            }

            @Generated
            public WorkerEndpointResult build() {
                return new WorkerEndpointResult(this.runningCount, this.runnings);
            }

            @Generated
            public String toString() {
                return "WorkerEndpoint.WorkerEndpointResult.WorkerEndpointResultBuilder(runningCount=" + this.runningCount + ", runnings=" + this.runnings + ")";
            }
        }
    }

    public static class WorkerEndpointWorkerTask {
        private final TaskRun taskRun;
        private final Task task;

        @Generated
        public TaskRun getTaskRun() {
            return this.taskRun;
        }

        @Generated
        public Task getTask() {
            return this.task;
        }

        @ConstructorProperties(value={"taskRun", "task"})
        @Generated
        public WorkerEndpointWorkerTask(TaskRun taskRun, Task task) {
            this.taskRun = taskRun;
            this.task = task;
        }
    }
}

