/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.IllegalConditionEvaluation;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.utils.DateUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetTime;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition for allows events between two specific time")
@Plugin(examples={@Example(full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.TimeBetweenCondition", "      after: \"16:19:12+02:00\""})})
public class TimeBetweenCondition
extends Condition
implements ScheduleCondition {
    @NotNull
    @Schema(title="The date to test", description="Can be any variable or any valid ISO 8601 time, default will use `{{ now(format='iso_offset_time') }}`")
    @PluginProperty(dynamic=true)
    private final String date;
    @Schema(title="The date must after this one")
    @PluginProperty
    private OffsetTime after;
    @Schema(title="The date must before this one")
    @PluginProperty
    private OffsetTime before;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        String render = conditionContext.getRunContext().render(this.date, conditionContext.getVariables());
        OffsetTime currentDate = DateUtils.parseOffsetTime(render);
        if (this.before != null && this.after != null) {
            return currentDate.isAfter(this.after) && currentDate.isBefore(this.before);
        }
        if (this.before != null) {
            return currentDate.isBefore(this.before);
        }
        if (this.after != null) {
            return currentDate.isAfter(this.after);
        }
        throw new IllegalConditionEvaluation("Invalid condition with no before nor after");
    }

    @Generated
    private static String $default$date() {
        return "{{ now(format='iso_offset_time') }}";
    }

    @Generated
    protected TimeBetweenCondition(TimeBetweenConditionBuilder<?, ?> b) {
        super(b);
        this.date = b.date$set ? b.date$value : TimeBetweenCondition.$default$date();
        this.after = b.after;
        this.before = b.before;
    }

    @Generated
    public static TimeBetweenConditionBuilder<?, ?> builder() {
        return new TimeBetweenConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "TimeBetweenCondition(super=" + super.toString() + ", date=" + this.getDate() + ", after=" + this.getAfter() + ", before=" + this.getBefore() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeBetweenCondition)) {
            return false;
        }
        TimeBetweenCondition other = (TimeBetweenCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        OffsetTime this$after = this.getAfter();
        OffsetTime other$after = other.getAfter();
        if (this$after == null ? other$after != null : !((Object)this$after).equals(other$after)) {
            return false;
        }
        OffsetTime this$before = this.getBefore();
        OffsetTime other$before = other.getBefore();
        return !(this$before == null ? other$before != null : !((Object)this$before).equals(other$before));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeBetweenCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        OffsetTime $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
        OffsetTime $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        return result;
    }

    @Generated
    public String getDate() {
        return this.date;
    }

    @Generated
    public OffsetTime getAfter() {
        return this.after;
    }

    @Generated
    public OffsetTime getBefore() {
        return this.before;
    }

    @Generated
    public TimeBetweenCondition() {
        this.date = TimeBetweenCondition.$default$date();
    }

    @Generated
    public static abstract class TimeBetweenConditionBuilder<C extends TimeBetweenCondition, B extends TimeBetweenConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private boolean date$set;
        @Generated
        private String date$value;
        @Generated
        private OffsetTime after;
        @Generated
        private OffsetTime before;

        @Generated
        public B date(String date) {
            this.date$value = date;
            this.date$set = true;
            return (B)this.self();
        }

        @Generated
        public B after(OffsetTime after) {
            this.after = after;
            return (B)this.self();
        }

        @Generated
        public B before(OffsetTime before) {
            this.before = before;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TimeBetweenCondition.TimeBetweenConditionBuilder(super=" + super.toString() + ", date$value=" + this.date$value + ", after=" + this.after + ", before=" + this.before + ")";
        }
    }

    @Generated
    private static final class TimeBetweenConditionBuilderImpl
    extends TimeBetweenConditionBuilder<TimeBetweenCondition, TimeBetweenConditionBuilderImpl> {
        @Generated
        private TimeBetweenConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected TimeBetweenConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TimeBetweenCondition build() {
            return new TimeBetweenCondition(this);
        }
    }
}

