/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.Input;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalTime;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import lombok.Generated;

public class TimeInput
extends Input<LocalTime> {
    @Schema(title="Minimal value.")
    LocalTime after;
    @Schema(title="Maximal value.")
    LocalTime before;

    @Override
    public void validate(LocalTime input) throws ConstraintViolationException {
        if (this.after != null && input.isBefore(this.after)) {
            throw new ConstraintViolationException("Invalid input '" + input + "', it must be after '" + this.after + "'", Set.of(ManualConstraintViolation.of("Invalid input", this, TimeInput.class, this.getName(), input)));
        }
        if (this.before != null && input.isAfter(this.before)) {
            throw new ConstraintViolationException("Invalid input '" + input + "', it must be before '" + this.before + "'", Set.of(ManualConstraintViolation.of("Invalid input", this, TimeInput.class, this.getName(), input)));
        }
    }

    @Generated
    protected TimeInput(TimeInputBuilder<?, ?> b) {
        super(b);
        this.after = b.after;
        this.before = b.before;
    }

    @Generated
    public static TimeInputBuilder<?, ?> builder() {
        return new TimeInputBuilderImpl();
    }

    @Generated
    public LocalTime getAfter() {
        return this.after;
    }

    @Generated
    public LocalTime getBefore() {
        return this.before;
    }

    @Generated
    public TimeInput() {
    }

    @Generated
    public static abstract class TimeInputBuilder<C extends TimeInput, B extends TimeInputBuilder<C, B>>
    extends Input.InputBuilder<LocalTime, C, B> {
        @Generated
        private LocalTime after;
        @Generated
        private LocalTime before;

        @Generated
        public B after(LocalTime after) {
            this.after = after;
            return (B)this.self();
        }

        @Generated
        public B before(LocalTime before) {
            this.before = before;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TimeInput.TimeInputBuilder(super=" + super.toString() + ", after=" + this.after + ", before=" + this.before + ")";
        }
    }

    @Generated
    private static final class TimeInputBuilderImpl
    extends TimeInputBuilder<TimeInput, TimeInputBuilderImpl> {
        @Generated
        private TimeInputBuilderImpl() {
        }

        @Override
        @Generated
        protected TimeInputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TimeInput build() {
            return new TimeInput(this);
        }
    }
}

