/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.hierarchies;

import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.Task;
import io.micronaut.core.annotation.Introspected;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@Introspected
public abstract class AbstractGraphTask
extends AbstractGraph {
    private final Task task;
    private final TaskRun taskRun;
    private final List<String> values;
    private final RelationType relationType;

    public AbstractGraphTask() {
        this.task = null;
        this.taskRun = null;
        this.values = null;
        this.relationType = null;
    }

    public AbstractGraphTask(Task task, TaskRun taskRun, List<String> values, RelationType relationType) {
        this.task = task;
        this.taskRun = taskRun;
        this.values = values;
        this.relationType = relationType;
    }

    @Override
    public String getLabel() {
        return this.getUid() + (String)(this.getTaskRun() != null ? " > " + this.getTaskRun().getValue() + " (" + this.getTaskRun().getId() + ")" : "");
    }

    @Override
    public String getUid() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.task != null) {
            list.add(this.task.getId());
        }
        if (this.values != null) {
            list.addAll(this.values);
        }
        return String.join((CharSequence)"_", list);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractGraphTask)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return (this.uid + this.getClass().getName()).hashCode();
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractGraphTask(super=" + super.toString() + ", task=" + this.getTask() + ", taskRun=" + this.getTaskRun() + ", values=" + this.getValues() + ", relationType=" + this.getRelationType() + ")";
    }

    @Generated
    public Task getTask() {
        return this.task;
    }

    @Generated
    public TaskRun getTaskRun() {
        return this.taskRun;
    }

    @Generated
    public List<String> getValues() {
        return this.values;
    }

    @Generated
    public RelationType getRelationType() {
        return this.relationType;
    }
}

