/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.hierarchies;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.Graph;
import io.kestra.core.models.hierarchies.GraphClusterEnd;
import io.kestra.core.models.hierarchies.GraphClusterRoot;
import io.kestra.core.models.hierarchies.GraphTask;
import io.kestra.core.models.hierarchies.Relation;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.Task;
import java.util.List;
import lombok.Generated;

public class GraphCluster
extends AbstractGraph {
    @JsonIgnore
    protected final Graph<AbstractGraph, Relation> graph = new Graph();
    protected RelationType relationType;
    @JsonIgnore
    private final GraphClusterRoot root;
    @JsonIgnore
    private final GraphClusterEnd end;

    public GraphCluster() {
        this.relationType = null;
        this.root = new GraphClusterRoot();
        this.end = new GraphClusterEnd();
        this.graph.addNode(this.root);
        this.graph.addNode(this.end);
    }

    public GraphCluster(String uid) {
        super(uid);
        this.relationType = null;
        this.root = new GraphClusterRoot();
        this.end = new GraphClusterEnd();
        this.graph.addNode(this.root);
        this.graph.addNode(this.end);
    }

    public GraphCluster(Task task, TaskRun taskRun, List<String> values, RelationType relationType) {
        this.uid = "cluster_" + task.getId();
        this.relationType = relationType;
        this.root = new GraphClusterRoot();
        this.end = new GraphClusterEnd();
        this.graph.addNode(this.root);
        this.graph.addNode(this.end);
        GraphTask flowableGraphTask = new GraphTask(task, taskRun, values, relationType);
        this.getGraph().addNode(flowableGraphTask);
        this.getGraph().addEdge(this.getRoot(), flowableGraphTask, new Relation());
    }

    @Generated
    public Graph<AbstractGraph, Relation> getGraph() {
        return this.graph;
    }

    @Generated
    public RelationType getRelationType() {
        return this.relationType;
    }

    @Generated
    public GraphClusterRoot getRoot() {
        return this.root;
    }

    @Generated
    public GraphClusterEnd getEnd() {
        return this.end;
    }
}

