/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.WorkerGroup;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.flows.WorkingDirectory;
import io.kestra.core.utils.Rethrow;
import io.micronaut.core.annotation.Introspected;
import java.time.Duration;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type", visible=true, include=JsonTypeInfo.As.EXISTING_PROPERTY)
@Introspected
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public abstract class Task {
    @NotNull
    @NotBlank
    @Pattern(regexp="[a-zA-Z0-9_-]+")
    protected @NotNull @NotBlank @Pattern(regexp="[a-zA-Z0-9_-]+") String id;
    @NotNull
    @NotBlank
    @Pattern(regexp="\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*")
    protected @NotNull @NotBlank @Pattern(regexp="\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*") String type;
    private String description;
    @Valid
    protected AbstractRetry retry;
    protected Duration timeout;
    protected Boolean disabled;
    @Valid
    private WorkerGroup workerGroup;

    public Optional<Task> findById(String id) {
        Optional<Task> childs;
        if (this.getId().equals(id)) {
            return Optional.of(this);
        }
        if (this.isFlowable() && (childs = ((FlowableTask)((Object)this)).allChildTasks().stream().map(t -> t.findById(id)).filter(Optional::isPresent).map(Optional::get).findFirst()).isPresent()) {
            return childs;
        }
        return Optional.empty();
    }

    public Optional<Task> findById(String id, RunContext runContext, TaskRun taskRun) throws IllegalVariableEvaluationException {
        Optional<Task> errorChilds;
        Optional<Task> childs;
        if (this.getId().equals(id)) {
            return Optional.of(this);
        }
        if (this.isFlowable() && (childs = ((FlowableTask)((Object)this)).childTasks(runContext, taskRun).stream().map(Rethrow.throwFunction(resolvedTask -> resolvedTask.getTask().findById(id, runContext, taskRun))).filter(Optional::isPresent).map(Optional::get).findFirst()).isPresent()) {
            return childs;
        }
        if (this.isFlowable() && ((FlowableTask)((Object)this)).getErrors() != null && (errorChilds = ((FlowableTask)((Object)this)).getErrors().stream().map(Rethrow.throwFunction(task -> task.findById(id, runContext, taskRun))).filter(Optional::isPresent).map(Optional::get).findFirst()).isPresent()) {
            return errorChilds;
        }
        return Optional.empty();
    }

    @JsonIgnore
    public boolean isFlowable() {
        return this instanceof FlowableTask;
    }

    @JsonIgnore
    public boolean isSendToWorkerTask() {
        return !(this instanceof FlowableTask) || this instanceof WorkingDirectory;
    }

    @Generated
    private static Boolean $default$disabled() {
        return false;
    }

    @Generated
    protected Task(TaskBuilder<?, ?> b) {
        this.id = b.id;
        this.type = b.type;
        this.description = b.description;
        this.retry = b.retry;
        this.timeout = b.timeout;
        this.disabled = b.disabled$set ? b.disabled$value : Task.$default$disabled();
        this.workerGroup = b.workerGroup;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public AbstractRetry getRetry() {
        return this.retry;
    }

    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    @Generated
    public Boolean getDisabled() {
        return this.disabled;
    }

    @Generated
    public WorkerGroup getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public Task() {
        this.disabled = Task.$default$disabled();
    }

    @Generated
    public static abstract class TaskBuilder<C extends Task, B extends TaskBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String type;
        @Generated
        private String description;
        @Generated
        private AbstractRetry retry;
        @Generated
        private Duration timeout;
        @Generated
        private boolean disabled$set;
        @Generated
        private Boolean disabled$value;
        @Generated
        private WorkerGroup workerGroup;

        @Generated
        protected B $fillValuesFrom(C instance) {
            TaskBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Task instance, TaskBuilder<?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.description(instance.description);
            b.retry(instance.retry);
            b.timeout(instance.timeout);
            b.disabled(instance.disabled);
            b.workerGroup(instance.workerGroup);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B retry(AbstractRetry retry) {
            this.retry = retry;
            return this.self();
        }

        @Generated
        public B timeout(Duration timeout) {
            this.timeout = timeout;
            return this.self();
        }

        @Generated
        public B disabled(Boolean disabled) {
            this.disabled$value = disabled;
            this.disabled$set = true;
            return this.self();
        }

        @Generated
        public B workerGroup(WorkerGroup workerGroup) {
            this.workerGroup = workerGroup;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Task.TaskBuilder(id=" + this.id + ", type=" + this.type + ", description=" + this.description + ", retry=" + this.retry + ", timeout=" + this.timeout + ", disabled$value=" + this.disabled$value + ", workerGroup=" + this.workerGroup + ")";
        }
    }
}

