/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.templates;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.serializers.JacksonMapper;
import io.micronaut.core.annotation.Introspected;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@Introspected
public class Template
implements DeletedInterface {
    private static final ObjectMapper YAML_MAPPER = JacksonMapper.ofYaml().copy().setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

        public boolean hasIgnoreMarker(AnnotatedMember m) {
            List<String> exclusions = Arrays.asList("revision", "deleted", "source");
            return exclusions.contains(m.getName()) || super.hasIgnoreMarker(m);
        }
    }).setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
    @NotNull
    @NotBlank
    @Pattern(regexp="[a-zA-Z0-9._-]+")
    private @NotNull @NotBlank @Pattern(regexp="[a-zA-Z0-9._-]+") String id;
    @NotNull
    @Pattern(regexp="[a-z0-9._-]+")
    private @NotNull @Pattern(regexp="[a-z0-9._-]+") String namespace;
    String description;
    @Valid
    @NotEmpty
    private List<Task> tasks;
    @Valid
    private List<Task> errors;
    @NotNull
    private final boolean deleted;

    @JsonIgnore
    public String uid() {
        return Template.uid(this.getNamespace(), this.getId());
    }

    @JsonIgnore
    public static String uid(String namespace, String id) {
        return String.join((CharSequence)"_", Arrays.asList(namespace, id));
    }

    public Optional<ConstraintViolationException> validateUpdate(Template updated) {
        HashSet<ManualConstraintViolation<Template>> violations = new HashSet<ManualConstraintViolation<Template>>();
        if (!updated.getId().equals(this.getId())) {
            violations.add(ManualConstraintViolation.of("Illegal template id update", updated, Template.class, "template.id", updated.getId()));
        }
        if (!updated.getNamespace().equals(this.getNamespace())) {
            violations.add(ManualConstraintViolation.of("Illegal namespace update", updated, Template.class, "template.namespace", updated.getNamespace()));
        }
        if (violations.size() > 0) {
            return Optional.of(new ConstraintViolationException(violations));
        }
        return Optional.empty();
    }

    public String generateSource() {
        try {
            return YAML_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Template toDeleted() {
        return new Template(this.id, this.namespace, this.description, this.tasks, this.errors, true);
    }

    @Generated
    private static boolean $default$deleted() {
        return false;
    }

    @Generated
    protected Template(TemplateBuilder<?, ?> b) {
        this.id = b.id;
        this.namespace = b.namespace;
        this.description = b.description;
        this.tasks = b.tasks;
        this.errors = b.errors;
        this.deleted = b.deleted$set ? b.deleted$value : Template.$default$deleted();
    }

    @Generated
    public static TemplateBuilder<?, ?> builder() {
        return new TemplateBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @ConstructorProperties(value={"id", "namespace", "description", "tasks", "errors", "deleted"})
    @Generated
    public Template(String id, String namespace, String description, List<Task> tasks, List<Task> errors, boolean deleted) {
        this.id = id;
        this.namespace = namespace;
        this.description = description;
        this.tasks = tasks;
        this.errors = errors;
        this.deleted = deleted;
    }

    @Generated
    public Template() {
        this.deleted = Template.$default$deleted();
    }

    @Generated
    public String toString() {
        return "Template(id=" + this.getId() + ", namespace=" + this.getNamespace() + ", description=" + this.getDescription() + ", tasks=" + this.getTasks() + ", errors=" + this.getErrors() + ", deleted=" + this.isDeleted() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Template;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @Generated
    public static abstract class TemplateBuilder<C extends Template, B extends TemplateBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String namespace;
        @Generated
        private String description;
        @Generated
        private List<Task> tasks;
        @Generated
        private List<Task> errors;
        @Generated
        private boolean deleted$set;
        @Generated
        private boolean deleted$value;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B tasks(List<Task> tasks) {
            this.tasks = tasks;
            return this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return this.self();
        }

        @Generated
        public B deleted(boolean deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Template.TemplateBuilder(id=" + this.id + ", namespace=" + this.namespace + ", description=" + this.description + ", tasks=" + this.tasks + ", errors=" + this.errors + ", deleted$value=" + this.deleted$value + ")";
        }
    }

    @Generated
    private static final class TemplateBuilderImpl
    extends TemplateBuilder<Template, TemplateBuilderImpl> {
        @Generated
        private TemplateBuilderImpl() {
        }

        @Override
        @Generated
        protected TemplateBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Template build() {
            return new Template(this);
        }
    }
}

