/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.tasks.WorkerGroup;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type", visible=true, include=JsonTypeInfo.As.EXISTING_PROPERTY)
@Introspected
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public abstract class AbstractTrigger {
    @NotNull
    @NotBlank
    @Pattern(regexp="[a-zA-Z0-9_-]+")
    @Schema(title="A unique id for the whole flow")
    protected @NotNull @NotBlank @Pattern(regexp="[a-zA-Z0-9_-]+") String id;
    @NotNull
    @NotBlank
    @Pattern(regexp="\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*")
    @Schema(title="The class name for this current trigger")
    protected @NotNull @NotBlank @Pattern(regexp="\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*") String type;
    private String description;
    @Valid
    @Schema(title="List of Conditions in order to limit the flow trigger.")
    private List<Condition> conditions;
    @NotNull
    private boolean disabled;
    @Valid
    private WorkerGroup workerGroup;

    @Generated
    private static boolean $default$disabled() {
        return false;
    }

    @Generated
    protected AbstractTrigger(AbstractTriggerBuilder<?, ?> b) {
        this.id = b.id;
        this.type = b.type;
        this.description = b.description;
        this.conditions = b.conditions;
        this.disabled = b.disabled$set ? b.disabled$value : AbstractTrigger.$default$disabled();
        this.workerGroup = b.workerGroup;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public WorkerGroup getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public AbstractTrigger() {
        this.disabled = AbstractTrigger.$default$disabled();
    }

    @Generated
    public static abstract class AbstractTriggerBuilder<C extends AbstractTrigger, B extends AbstractTriggerBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String type;
        @Generated
        private String description;
        @Generated
        private List<Condition> conditions;
        @Generated
        private boolean disabled$set;
        @Generated
        private boolean disabled$value;
        @Generated
        private WorkerGroup workerGroup;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B conditions(List<Condition> conditions) {
            this.conditions = conditions;
            return this.self();
        }

        @Generated
        public B disabled(boolean disabled) {
            this.disabled$value = disabled;
            this.disabled$set = true;
            return this.self();
        }

        @Generated
        public B workerGroup(WorkerGroup workerGroup) {
            this.workerGroup = workerGroup;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractTrigger.AbstractTriggerBuilder(id=" + this.id + ", type=" + this.type + ", description=" + this.description + ", conditions=" + this.conditions + ", disabled$value=" + this.disabled$value + ", workerGroup=" + this.workerGroup + ")";
        }
    }
}

