/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.IdUtils;
import io.micronaut.http.HttpRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Generated;

@Schema(title="Trigger a flow from a webhook", description="Webbook trigger allow you to trigger a flow from a webhook url. The trigger will generate a `key` that must be used on url : `/api/v1/executions/webhook/{namespace}/[flowId]/{key}`. Kestra accept `GET`, `POST` & `PUT` request on this url. The whole body & headers will be available as variable:\n - `trigger.body`\n- `trigger.headers`")
@Plugin(examples={@Example(title="Add a trigger to the current flow", code={"triggers:", "  - id: webhook", "    type: io.kestra.core.models.triggers.types.Webhook"}, full=true), @Example(title="After the trigger is created, a key will be created that will be use in the webhook url, now, you can launch the flow on the url `/api/v1/executions/webhook/{namespace}/[flowId]/4wjtkzwVGBM9yKnjm3yv8r`", code={"triggers:", "  - id: webhook", "    type: io.kestra.core.models.triggers.types.Webhook", "    key: 4wjtkzwVGBM9yKnjm3yv8r"}, full=true)})
public class Webhook
extends AbstractTrigger
implements TriggerOutput<Output> {
    @Size(min=16, max=256)
    @Schema(title="The unique key that will be part of the url", description="If you don't provide a key, a random one will be generated. Is used as key for generating the url of the webhook.\n\n::alert{type=\"warning\"}\nTake care when using manual key, the key is the only security to protect your webhook and must be considered as a secret !\n::\n", defaultValue="<generated-hash>")
    @PluginProperty
    private final @Size(min=16, max=256) String key;

    public Optional<Execution> evaluate(HttpRequest<String> request, Flow flow) {
        String body = request.getBody().orElse(null);
        ObjectMapper mapper = JacksonMapper.ofJson().setSerializationInclusion(JsonInclude.Include.USE_DEFAULTS);
        Execution.ExecutionBuilder builder = Execution.builder().id(IdUtils.create()).namespace(flow.getNamespace()).flowId(flow.getId()).flowRevision(flow.getRevision()).state(new State()).trigger(ExecutionTrigger.of((AbstractTrigger)this, Output.builder().body(this.tryMap(mapper, body).or(() -> this.tryArray(mapper, body)).orElse(body)).headers(request.getHeaders().asMap()).parameters(request.getParameters().asMap()).build()));
        return Optional.of(builder.build());
    }

    private Optional<Object> tryMap(ObjectMapper mapper, String body) {
        try {
            return Optional.of(mapper.readValue(body, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    private Optional<Object> tryArray(ObjectMapper mapper, String body) {
        try {
            return Optional.of(mapper.readValue(body, (TypeReference)new TypeReference<List<Object>>(){}));
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    @Generated
    private static String $default$key() {
        return IdUtils.create();
    }

    @Generated
    protected Webhook(WebhookBuilder<?, ?> b) {
        super(b);
        this.key = b.key$set ? b.key$value : Webhook.$default$key();
    }

    @Generated
    public static WebhookBuilder<?, ?> builder() {
        return new WebhookBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Webhook(super=" + super.toString() + ", key=" + this.getKey() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Webhook)) {
            return false;
        }
        Webhook other = (Webhook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Webhook;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Webhook() {
        this.key = Webhook.$default$key();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The full body for the webhook request", description="We try to deserialize the incoming request as json (array or object).\nIf we can't the full body as string will be available")
        @NotNull
        private Object body;
        @Schema(title="The headers for the webhook request")
        @NotNull
        private Map<String, List<String>> headers;
        @Schema(title="The parameters for the webhook request")
        @NotNull
        private Map<String, List<String>> parameters;

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String toString() {
            return "Webhook.Output(body=" + this.getBody() + ", headers=" + this.getHeaders() + ", parameters=" + this.getParameters() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Output)) {
                return false;
            }
            Output other = (Output)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$body = this.getBody();
            Object other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.getHeaders();
            Map<String, List<String>> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            Map<String, List<String>> this$parameters = this.getParameters();
            Map<String, List<String>> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Output;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            Map<String, List<String>> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            Map<String, List<String>> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        @Generated
        public Object getBody() {
            return this.body;
        }

        @Generated
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Generated
        public Map<String, List<String>> getParameters() {
            return this.parameters;
        }

        @Generated
        public Output() {
        }

        @ConstructorProperties(value={"body", "headers", "parameters"})
        @Generated
        public Output(Object body, Map<String, List<String>> headers, Map<String, List<String>> parameters) {
            this.body = body;
            this.headers = headers;
            this.parameters = parameters;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Object body;
            @Generated
            private Map<String, List<String>> headers;
            @Generated
            private Map<String, List<String>> parameters;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder body(Object body) {
                this.body = body;
                return this;
            }

            @Generated
            public OutputBuilder headers(Map<String, List<String>> headers) {
                this.headers = headers;
                return this;
            }

            @Generated
            public OutputBuilder parameters(Map<String, List<String>> parameters) {
                this.parameters = parameters;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.body, this.headers, this.parameters);
            }

            @Generated
            public String toString() {
                return "Webhook.Output.OutputBuilder(body=" + this.body + ", headers=" + this.headers + ", parameters=" + this.parameters + ")";
            }
        }
    }

    @Generated
    public static abstract class WebhookBuilder<C extends Webhook, B extends WebhookBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private boolean key$set;
        @Generated
        private String key$value;

        @Generated
        public B key(String key) {
            this.key$value = key;
            this.key$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Webhook.WebhookBuilder(super=" + super.toString() + ", key$value=" + this.key$value + ")";
        }
    }

    @Generated
    private static final class WebhookBuilderImpl
    extends WebhookBuilder<Webhook, WebhookBuilderImpl> {
        @Generated
        private WebhookBuilderImpl() {
        }

        @Override
        @Generated
        protected WebhookBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Webhook build() {
            return new Webhook(this);
        }
    }
}

