/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.statistics.DailyExecutionStatistics;
import io.kestra.core.models.executions.statistics.ExecutionCount;
import io.kestra.core.models.executions.statistics.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.SaveRepositoryInterface;
import io.kestra.core.utils.DateUtils;
import io.micronaut.data.model.Pageable;
import io.reactivex.Flowable;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public interface ExecutionRepositoryInterface
extends SaveRepositoryInterface<Execution> {
    public Boolean isTaskRunEnabled();

    public Optional<Execution> findById(String var1);

    public ArrayListTotal<Execution> findByFlowId(String var1, String var2, Pageable var3);

    public ArrayListTotal<Execution> find(Pageable var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @Nullable ZonedDateTime var5, @Nullable ZonedDateTime var6, @Nullable List<State.Type> var7, @Nullable Map<String, String> var8);

    public Flowable<Execution> find(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable ZonedDateTime var4, @Nullable ZonedDateTime var5, @Nullable List<State.Type> var6, @Nullable Map<String, String> var7);

    public ArrayListTotal<TaskRun> findTaskRun(Pageable var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @Nullable ZonedDateTime var5, @Nullable ZonedDateTime var6, @Nullable List<State.Type> var7);

    public Execution delete(Execution var1);

    public Integer purge(Execution var1);

    public Integer maxTaskRunSetting();

    public List<DailyExecutionStatistics> dailyStatistics(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable ZonedDateTime var4, @Nullable ZonedDateTime var5, @Nullable DateUtils.GroupType var6, boolean var7);

    public Map<String, Map<String, List<DailyExecutionStatistics>>> dailyGroupByFlowStatistics(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable List<FlowFilter> var4, @Nullable ZonedDateTime var5, @Nullable ZonedDateTime var6, boolean var7);

    public List<ExecutionCount> executionCounts(List<Flow> var1, @Nullable List<State.Type> var2, @Nullable ZonedDateTime var3, @Nullable ZonedDateTime var4);

    @Override
    public Execution save(Execution var1);

    default public Function<String, String> sortMapping() throws IllegalArgumentException {
        return s -> s;
    }

    public static class FlowFilter {
        @NotNull
        private String namespace;
        @NotNull
        private String id;

        @Generated
        protected FlowFilter(FlowFilterBuilder<?, ?> b) {
            this.namespace = b.namespace;
            this.id = b.id;
        }

        @Generated
        public static FlowFilterBuilder<?, ?> builder() {
            return new FlowFilterBuilderImpl();
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public FlowFilter() {
        }

        @Generated
        public static abstract class FlowFilterBuilder<C extends FlowFilter, B extends FlowFilterBuilder<C, B>> {
            @Generated
            private String namespace;
            @Generated
            private String id;

            @Generated
            public B namespace(String namespace) {
                this.namespace = namespace;
                return this.self();
            }

            @Generated
            public B id(String id) {
                this.id = id;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "ExecutionRepositoryInterface.FlowFilter.FlowFilterBuilder(namespace=" + this.namespace + ", id=" + this.id + ")";
            }
        }

        @Generated
        private static final class FlowFilterBuilderImpl
        extends FlowFilterBuilder<FlowFilter, FlowFilterBuilderImpl> {
            @Generated
            private FlowFilterBuilderImpl() {
            }

            @Override
            @Generated
            protected FlowFilterBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public FlowFilter build() {
                return new FlowFilter(this);
            }
        }
    }
}

