/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.runners.ExecutionDelay;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.runners.WorkerTaskExecution;
import io.kestra.core.runners.WorkerTaskResult;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class Executor {
    private Execution execution;
    private Exception exception;
    private final List<String> from = new ArrayList<String>();
    private Long offset;
    @JsonIgnore
    private boolean executionUpdated = false;
    private Flow flow;
    private final List<TaskRun> nexts = new ArrayList<TaskRun>();
    private final List<WorkerTask> workerTasks = new ArrayList<WorkerTask>();
    private final List<WorkerTaskResult> workerTaskResults = new ArrayList<WorkerTaskResult>();
    private final List<ExecutionDelay> executionDelays = new ArrayList<ExecutionDelay>();
    private WorkerTaskResult joined;
    private final List<WorkerTaskExecution> workerTaskExecutions = new ArrayList<WorkerTaskExecution>();

    public Executor(Execution execution, Long offset) {
        this.execution = execution;
        this.offset = offset;
    }

    public Executor(WorkerTaskResult workerTaskResult) {
        this.joined = workerTaskResult;
    }

    public Boolean canBeProcessed() {
        return this.getException() == null && this.getFlow() != null && !this.getExecution().isDeleted();
    }

    public Executor withFlow(Flow flow) {
        this.flow = flow;
        return this;
    }

    public Executor withExecution(Execution execution, String from) {
        this.execution = execution;
        this.from.add(from);
        this.executionUpdated = true;
        return this;
    }

    public Executor withException(Exception exception, String from) {
        this.exception = exception;
        this.from.add(from);
        this.executionUpdated = true;
        return this;
    }

    public Executor withTaskRun(List<TaskRun> taskRuns, String from) {
        this.nexts.addAll(taskRuns);
        this.from.add(from);
        return this;
    }

    public Executor withWorkerTasks(List<WorkerTask> workerTasks, String from) {
        this.workerTasks.addAll(workerTasks);
        this.from.add(from);
        return this;
    }

    public Executor withWorkerTaskResults(List<WorkerTaskResult> workerTaskResults, String from) {
        this.workerTaskResults.addAll(workerTaskResults);
        this.from.add(from);
        return this;
    }

    public Executor withWorkerTaskDelays(List<ExecutionDelay> executionDelays, String from) {
        this.executionDelays.addAll(executionDelays);
        this.from.add(from);
        return this;
    }

    public Executor withWorkerTaskExecutions(List<WorkerTaskExecution> newExecutions, String from) {
        this.workerTaskExecutions.addAll(newExecutions);
        this.from.add(from);
        return this;
    }

    public Executor serialize() {
        return new Executor(this.execution, this.offset);
    }

    @Generated
    public Execution getExecution() {
        return this.execution;
    }

    @Generated
    public Exception getException() {
        return this.exception;
    }

    @Generated
    public List<String> getFrom() {
        return this.from;
    }

    @Generated
    public Long getOffset() {
        return this.offset;
    }

    @Generated
    public boolean isExecutionUpdated() {
        return this.executionUpdated;
    }

    @Generated
    public Flow getFlow() {
        return this.flow;
    }

    @Generated
    public List<TaskRun> getNexts() {
        return this.nexts;
    }

    @Generated
    public List<WorkerTask> getWorkerTasks() {
        return this.workerTasks;
    }

    @Generated
    public List<WorkerTaskResult> getWorkerTaskResults() {
        return this.workerTaskResults;
    }

    @Generated
    public List<ExecutionDelay> getExecutionDelays() {
        return this.executionDelays;
    }

    @Generated
    public WorkerTaskResult getJoined() {
        return this.joined;
    }

    @Generated
    public List<WorkerTaskExecution> getWorkerTaskExecutions() {
        return this.workerTaskExecutions;
    }

    @ConstructorProperties(value={"execution", "exception", "offset", "executionUpdated", "flow", "joined"})
    @Generated
    public Executor(Execution execution, Exception exception, Long offset, boolean executionUpdated, Flow flow, WorkerTaskResult joined) {
        this.execution = execution;
        this.exception = exception;
        this.offset = offset;
        this.executionUpdated = executionUpdated;
        this.flow = flow;
        this.joined = joined;
    }
}

