/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.schedulers;

import com.google.common.base.Throwables;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.types.Schedule;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.runners.WorkerJob;
import io.kestra.core.runners.WorkerTrigger;
import io.kestra.core.runners.WorkerTriggerResult;
import io.kestra.core.schedulers.Scheduler;
import io.kestra.core.schedulers.SchedulerExecutionWithTrigger;
import io.kestra.core.schedulers.SchedulerTriggerStateInterface;
import io.kestra.core.services.ConditionService;
import io.kestra.core.services.FlowListenersInterface;
import io.kestra.core.services.FlowService;
import io.kestra.core.services.TaskDefaultService;
import io.kestra.core.services.WorkerGroupService;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.ListUtils;
import io.micronaut.context.ApplicationContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public abstract class AbstractScheduler
implements Scheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractScheduler.class);
    protected final ApplicationContext applicationContext;
    private final QueueInterface<Execution> executionQueue;
    private final QueueInterface<Trigger> triggerQueue;
    private final QueueInterface<WorkerJob> workerTaskQueue;
    private final QueueInterface<WorkerTriggerResult> workerTriggerResultQueue;
    protected final FlowListenersInterface flowListeners;
    private final RunContextFactory runContextFactory;
    private final MetricRegistry metricRegistry;
    private final ConditionService conditionService;
    private final TaskDefaultService taskDefaultService;
    private final WorkerGroupService workerGroupService;
    protected Boolean isReady = false;
    private final ScheduledExecutorService scheduleExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Map<String, ZonedDateTime> lastEvaluate = new ConcurrentHashMap<String, ZonedDateTime>();
    private final Object triggerStateSavedLock = new Object();
    private final Map<String, Trigger> triggerStateSaved = new ConcurrentHashMap<String, Trigger>();
    protected SchedulerTriggerStateInterface triggerState;
    private volatile List<FlowWithTrigger> schedulable = new ArrayList<FlowWithTrigger>();
    private volatile Map<String, FlowWithPollingTriggerNextDate> schedulableNextDate = new HashMap<String, FlowWithPollingTriggerNextDate>();

    @Inject
    public AbstractScheduler(ApplicationContext applicationContext, FlowListenersInterface flowListeners) {
        this.applicationContext = applicationContext;
        this.executionQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"executionQueue"));
        this.triggerQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"triggerQueue"));
        this.workerTaskQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"workerJobQueue"));
        this.workerTriggerResultQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"workerTriggerResultQueue"));
        this.flowListeners = flowListeners;
        this.runContextFactory = (RunContextFactory)applicationContext.getBean(RunContextFactory.class);
        this.metricRegistry = (MetricRegistry)applicationContext.getBean(MetricRegistry.class);
        this.conditionService = (ConditionService)applicationContext.getBean(ConditionService.class);
        this.taskDefaultService = (TaskDefaultService)applicationContext.getBean(TaskDefaultService.class);
        this.workerGroupService = (WorkerGroupService)applicationContext.getBean(WorkerGroupService.class);
    }

    @Override
    public void run() {
        this.flowListeners.run();
        ScheduledFuture<?> handle = this.scheduleExecutor.scheduleAtFixedRate(this::handle, 0L, 1L, TimeUnit.SECONDS);
        this.flowListeners.listen(this::computeSchedulable);
        Thread thread = new Thread(() -> {
            Await.until(handle::isDone);
            try {
                handle.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Executor fatal exception", (Throwable)e);
                this.applicationContext.close();
                Runtime.getRuntime().exit(1);
            }
        }, "scheduler-listener");
        thread.start();
        this.flowListeners.listen((flow, previous) -> {
            Object object = this.triggerStateSavedLock;
            synchronized (object) {
                if (flow.isDeleted()) {
                    ListUtils.emptyOnNull(flow.getTriggers()).forEach(abstractTrigger -> {
                        Trigger trigger = Trigger.of(flow, abstractTrigger);
                        this.triggerStateSaved.remove(trigger.uid());
                        this.triggerQueue.delete(trigger);
                    });
                } else if (previous != null) {
                    FlowService.findRemovedTrigger(flow, previous).forEach(abstractTrigger -> {
                        Trigger trigger = Trigger.of(flow, abstractTrigger);
                        this.triggerStateSaved.remove(trigger.uid());
                        this.triggerQueue.delete(trigger);
                    });
                }
            }
        });
        this.workerTriggerResultQueue.receive(Scheduler.class, workerTriggerResult -> {
            if (workerTriggerResult.getSuccess().booleanValue() && workerTriggerResult.getExecution().isPresent()) {
                SchedulerExecutionWithTrigger triggerExecution = new SchedulerExecutionWithTrigger(workerTriggerResult.getExecution().get(), workerTriggerResult.getTriggerContext());
                this.handleEvaluatePollingTriggerResult(triggerExecution);
            } else if (workerTriggerResult.getTrigger() instanceof PollingTriggerInterface && ((PollingTriggerInterface)((Object)workerTriggerResult.getTrigger())).getInterval() != null) {
                Trigger triggerNotRunning = Trigger.of(workerTriggerResult.getTriggerContext());
                this.triggerState.save(triggerNotRunning);
            }
        });
    }

    private synchronized void computeSchedulable(List<Flow> flows) {
        this.schedulableNextDate = new HashMap<String, FlowWithPollingTriggerNextDate>();
        this.schedulable = flows.stream().filter(flow -> flow.getTriggers() != null && flow.getTriggers().size() > 0).filter(flow -> !flow.isDisabled()).flatMap(flow -> flow.getTriggers().stream().filter(abstractTrigger -> !abstractTrigger.isDisabled() && abstractTrigger instanceof PollingTriggerInterface).map(trigger -> {
            RunContext runContext = this.runContextFactory.of((Flow)flow, (AbstractTrigger)trigger);
            return new FlowWithTrigger((Flow)flow, (AbstractTrigger)trigger, runContext, this.conditionService.conditionContext(runContext, (Flow)flow, null));
        })).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle() {
        if (!this.isReady.booleanValue()) {
            log.warn("Scheduler is not ready, waiting");
        }
        this.metricRegistry.counter("scheduler.loop.count", new String[0]).increment();
        ZonedDateTime now = AbstractScheduler.now();
        if (log.isTraceEnabled()) {
            log.trace("Scheduler next iteration for {} with {} schedulables of {} flows", new Object[]{now, this.schedulable.size(), this.flowListeners.flows().size()});
        }
        AbstractScheduler abstractScheduler = this;
        synchronized (abstractScheduler) {
            List<FlowWithPollingTriggerNextDate> readyForEvaluate = this.schedulable.stream().filter(f -> this.conditionService.isValid(f.getFlow(), f.getTrigger(), f.getConditionContext())).map(flowWithTrigger -> ((FlowWithPollingTrigger.FlowWithPollingTriggerBuilder)((FlowWithPollingTrigger.FlowWithPollingTriggerBuilder)((FlowWithPollingTrigger.FlowWithPollingTriggerBuilder)((FlowWithPollingTrigger.FlowWithPollingTriggerBuilder)((FlowWithPollingTrigger.FlowWithPollingTriggerBuilder)FlowWithPollingTrigger.builder().flow(flowWithTrigger.getFlow())).trigger(flowWithTrigger.getTrigger())).pollingTrigger((PollingTriggerInterface)((Object)flowWithTrigger.getTrigger()))).conditionContext(flowWithTrigger.getConditionContext())).triggerContext((TriggerContext)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)TriggerContext.builder().namespace(flowWithTrigger.getFlow().getNamespace())).flowId(flowWithTrigger.getFlow().getId())).flowRevision(flowWithTrigger.getFlow().getRevision())).triggerId(flowWithTrigger.getTrigger().getId())).date(AbstractScheduler.now())).build())).build()).filter(f -> this.isEvaluationInterval((FlowWithPollingTrigger)f, now)).filter(f -> !this.isTriggerRunning((FlowWithPollingTrigger)f)).filter(f -> this.isExecutionNotRunning((FlowWithPollingTrigger)f, now)).map(f -> {
                Trigger lastTrigger = this.getLastTrigger((FlowWithPollingTrigger)f, now);
                return FlowWithPollingTriggerNextDate.of(f, f.getPollingTrigger().nextEvaluationDate(f.getConditionContext(), Optional.of(lastTrigger)));
            }).filter(Objects::nonNull).toList();
            if (log.isTraceEnabled()) {
                log.trace("Scheduler will evaluate for {} with {} readyForEvaluate of {} schedulables", new Object[]{now, readyForEvaluate.size(), this.schedulable.size()});
            }
            this.metricRegistry.counter("scheduler.evaluate.count", new String[0]).increment((double)readyForEvaluate.size());
            readyForEvaluate.forEach(f -> {
                this.schedulableNextDate.put(f.getTriggerContext().uid(), (FlowWithPollingTriggerNextDate)f);
                Logger logger = f.getConditionContext().getRunContext().logger();
                if (f.getPollingTrigger().getInterval() != null) {
                    Trigger triggerRunning = Trigger.of(f.getTriggerContext(), now);
                    this.triggerState.save(triggerRunning);
                    try {
                        this.sendPollingTriggerToWorker((FlowWithPollingTrigger)f);
                    }
                    catch (InternalException e) {
                        logger.error("[namespace: {}] [flow: {}] [trigger: {}] Unable to send polling trigger to worker", new Object[]{f.getFlow().getNamespace(), f.getFlow().getId(), f.getTrigger().getId(), e});
                    }
                } else if (f.getPollingTrigger() instanceof Schedule) {
                    try {
                        SchedulerExecutionWithTrigger schedulerExecutionWithTrigger = this.evaluateScheduleTrigger((FlowWithPollingTrigger)f);
                        this.handleEvaluatePollingTriggerResult(schedulerExecutionWithTrigger);
                    }
                    catch (Exception e) {
                        logger.error("[namespace: {}] [flow: {}] [trigger: {}] Evaluate schedule trigger failed", new Object[]{f.getFlow().getNamespace(), f.getFlow().getId(), f.getTrigger().getId(), e});
                    }
                } else {
                    logger.error("[namespace: {}] [flow: {}] [trigger: {}] Polling trigger must have an interval (except the Schedule)", new Object[]{f.getFlow().getNamespace(), f.getFlow().getId(), f.getTrigger().getId()});
                }
            });
        }
    }

    private void handleEvaluatePollingTriggerResult(SchedulerExecutionWithTrigger result) {
        Stream.of(result).filter(Objects::nonNull).peek(this::log).forEach(this::saveLastTriggerAndEmitExecution);
    }

    private boolean isExecutionNotRunning(FlowWithPollingTrigger f, ZonedDateTime now) {
        Trigger lastTrigger = this.getLastTrigger(f, now);
        if (lastTrigger.getExecutionId() == null) {
            return true;
        }
        if (lastTrigger.getExecutionCurrentState() == null) {
            if (lastTrigger.getUpdatedDate() != null) {
                this.metricRegistry.timer("scheduler.execution.missing.duration", this.metricRegistry.tags(lastTrigger)).record(Duration.between(lastTrigger.getUpdatedDate(), Instant.now()));
            }
            if (lastTrigger.getUpdatedDate() == null || lastTrigger.getUpdatedDate().plusSeconds(60L).isBefore(Instant.now())) {
                log.warn("[namespace: {}] [flow: {}] [trigger: {}] Execution '{}' is not found, schedule is blocked since '{}'", new Object[]{lastTrigger.getNamespace(), lastTrigger.getFlowId(), lastTrigger.getTriggerId(), lastTrigger.getExecutionId(), lastTrigger.getUpdatedDate()});
            }
            return false;
        }
        if (lastTrigger.getUpdatedDate() != null) {
            this.metricRegistry.timer("scheduler.execution.running.duration", this.metricRegistry.tags(lastTrigger)).record(Duration.between(lastTrigger.getUpdatedDate(), Instant.now()));
        }
        if (log.isDebugEnabled()) {
            log.debug("[namespace: {}] [flow: {}] [trigger: {}] Execution '{}' is still '{}', updated at '{}'", new Object[]{lastTrigger.getNamespace(), lastTrigger.getFlowId(), lastTrigger.getTriggerId(), lastTrigger.getExecutionId(), lastTrigger.getExecutionCurrentState(), lastTrigger.getUpdatedDate()});
        }
        return false;
    }

    private void log(SchedulerExecutionWithTrigger executionWithTrigger) {
        this.metricRegistry.counter("scheduler.trigger.count", this.metricRegistry.tags(executionWithTrigger, new String[0])).increment();
        ZonedDateTime now = AbstractScheduler.now();
        if (executionWithTrigger.getExecution().getTrigger() != null && executionWithTrigger.getExecution().getTrigger().getVariables() != null && executionWithTrigger.getExecution().getTrigger().getVariables().containsKey("next")) {
            ZonedDateTime next;
            Object nextVariable = executionWithTrigger.getExecution().getTrigger().getVariables().get("next");
            ZonedDateTime zonedDateTime = next = nextVariable != null ? ZonedDateTime.parse((CharSequence)nextVariable) : null;
            if (next != null && now.isBefore(next)) {
                this.metricRegistry.timer("scheduler.trigger.delay.duration", this.metricRegistry.tags(executionWithTrigger, new String[0])).record(Duration.between(executionWithTrigger.getTriggerContext().getDate(), now));
            }
        }
        log.info("[namespace: {}] [flow: {}] [trigger: {}] Scheduled execution {} at '{}' started at '{}'", new Object[]{executionWithTrigger.getExecution().getNamespace(), executionWithTrigger.getExecution().getFlowId(), executionWithTrigger.getTriggerContext().getTriggerId(), executionWithTrigger.getExecution().getId(), executionWithTrigger.getTriggerContext().getDate(), now});
    }

    private Trigger getLastTrigger(FlowWithPollingTrigger f, ZonedDateTime now) {
        return this.triggerState.findLast(f.getTriggerContext()).orElseGet(() -> {
            ZonedDateTime nextDate = f.getPollingTrigger().nextEvaluationDate(f.getConditionContext(), Optional.empty());
            TriggerContext build = ((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)Trigger.builder().date(nextDate.compareTo(now) < 0 ? nextDate : now)).flowId(f.getFlow().getId())).flowRevision(f.getFlow().getRevision())).namespace(f.getFlow().getNamespace())).triggerId(f.getTriggerContext().getTriggerId())).updatedDate(Instant.now())).build();
            Object object = this.triggerStateSavedLock;
            synchronized (object) {
                if (this.triggerStateSaved.containsKey(((Trigger)build).uid())) {
                    Trigger cachedTrigger = this.triggerStateSaved.get(((Trigger)build).uid());
                    this.triggerState.save((Trigger)build);
                    this.triggerStateSaved.remove(((Trigger)build).uid());
                    return cachedTrigger;
                }
                this.triggerStateSaved.put(((Trigger)build).uid(), (Trigger)build);
            }
            return build;
        });
    }

    private boolean isEvaluationInterval(FlowWithPollingTrigger flowWithPollingTrigger, ZonedDateTime now) {
        boolean result;
        if (flowWithPollingTrigger.getPollingTrigger().getInterval() == null) {
            return true;
        }
        String key = flowWithPollingTrigger.getTriggerContext().uid();
        if (!this.lastEvaluate.containsKey(key)) {
            this.lastEvaluate.put(key, now);
            return true;
        }
        boolean bl = result = this.lastEvaluate.get(key).plus(flowWithPollingTrigger.getPollingTrigger().getInterval()).compareTo(now) < 0;
        if (result) {
            this.lastEvaluate.put(key, now);
        }
        return result;
    }

    private boolean isTriggerRunning(FlowWithPollingTrigger flowWithPollingTrigger) {
        if (flowWithPollingTrigger.getPollingTrigger().getInterval() == null) {
            return false;
        }
        Optional<Trigger> runningTrigger = this.triggerState.findLast(flowWithPollingTrigger.getTriggerContext()).filter(trigger -> trigger.getEvaluateRunningDate() != null);
        return runningTrigger.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveLastTriggerAndEmitExecution(SchedulerExecutionWithTrigger executionWithTrigger) {
        Trigger trigger = Trigger.of(executionWithTrigger.getTriggerContext(), executionWithTrigger.getExecution());
        Object object = this.triggerStateSavedLock;
        synchronized (object) {
            this.triggerState.save(trigger);
            this.executionQueue.emit(executionWithTrigger.getExecution());
        }
    }

    private static ZonedDateTime now() {
        return ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS);
    }

    private SchedulerExecutionWithTrigger evaluateScheduleTrigger(FlowWithPollingTrigger flowWithTrigger) {
        try {
            FlowWithPollingTrigger flowWithPollingTrigger = flowWithTrigger.from(this.taskDefaultService.injectDefaults(flowWithTrigger.getFlow(), flowWithTrigger.getConditionContext().getRunContext().logger()));
            flowWithPollingTrigger.getConditionContext().getRunContext().forScheduler(flowWithPollingTrigger.getTriggerContext(), flowWithTrigger.getTrigger());
            Optional<Execution> evaluate = flowWithPollingTrigger.getPollingTrigger().evaluate(flowWithPollingTrigger.getConditionContext(), flowWithPollingTrigger.getTriggerContext());
            if (log.isDebugEnabled() && log.isDebugEnabled()) {
                log.debug("[namespace: {}] [flow: {}] [trigger: {}] [type: {}] {}", new Object[]{flowWithPollingTrigger.getFlow().getNamespace(), flowWithPollingTrigger.getFlow().getId(), flowWithPollingTrigger.getTrigger().getId(), flowWithPollingTrigger.getTrigger().getType(), evaluate.map(execution -> "New execution '" + execution.getId() + "'").orElse("Empty evaluation")});
            }
            flowWithPollingTrigger.getConditionContext().getRunContext().cleanup();
            return evaluate.map(execution -> new SchedulerExecutionWithTrigger((Execution)execution, flowWithTrigger.getTriggerContext())).orElse(null);
        }
        catch (Exception e) {
            this.logError(flowWithTrigger, e);
            return null;
        }
    }

    private void logError(FlowWithPollingTrigger flowWithPollingTriggerNextDate, Throwable e) {
        Logger logger = flowWithPollingTriggerNextDate.getConditionContext().getRunContext().logger();
        logger.warn("[namespace: {}] [flow: {}] [trigger: {}] [date: {}] Evaluate Failed with error '{}'", new Object[]{flowWithPollingTriggerNextDate.getFlow().getNamespace(), flowWithPollingTriggerNextDate.getFlow().getId(), flowWithPollingTriggerNextDate.getTriggerContext().getTriggerId(), flowWithPollingTriggerNextDate.getTriggerContext().getDate(), e.getMessage(), e});
        if (logger.isTraceEnabled()) {
            logger.trace(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void sendPollingTriggerToWorker(FlowWithPollingTrigger flowWithTrigger) throws InternalException {
        FlowWithPollingTrigger flowWithTriggerWithDefault = flowWithTrigger.from(this.taskDefaultService.injectDefaults(flowWithTrigger.getFlow(), flowWithTrigger.getConditionContext().getRunContext().logger()));
        if (log.isDebugEnabled()) {
            log.debug("[namespace: {}] [flow: {}] [trigger: {}] [date: {}] Scheduling evaluation to the worker", new Object[]{flowWithTrigger.getFlow().getNamespace(), flowWithTrigger.getFlow().getId(), flowWithTrigger.getTriggerContext().getDate(), flowWithTrigger.getTriggerContext().getTriggerId()});
        }
        WorkerTrigger workerTrigger = WorkerTrigger.builder().trigger(flowWithTriggerWithDefault.trigger).triggerContext(flowWithTriggerWithDefault.triggerContext).conditionContext(flowWithTriggerWithDefault.conditionContext).build();
        this.workerTaskQueue.emit(this.workerGroupService.resolveGroupFromJob(workerTrigger), workerTrigger);
    }

    @Override
    public void close() {
        this.scheduleExecutor.shutdown();
    }

    @Generated
    public List<FlowWithTrigger> getSchedulable() {
        return this.schedulable;
    }

    @Generated
    public Map<String, FlowWithPollingTriggerNextDate> getSchedulableNextDate() {
        return this.schedulableNextDate;
    }

    private static class FlowWithPollingTrigger {
        private Flow flow;
        private AbstractTrigger trigger;
        private PollingTriggerInterface pollingTrigger;
        private TriggerContext triggerContext;
        private ConditionContext conditionContext;

        public FlowWithPollingTrigger from(Flow flow) throws InternalException {
            AbstractTrigger abstractTrigger = flow.getTriggers().stream().filter(a -> a.getId().equals(this.trigger.getId())).findFirst().orElseThrow(() -> new InternalException("Couldn't find the trigger '" + this.trigger.getId() + "' on flow '" + flow.uid() + "'"));
            return ((FlowWithPollingTriggerBuilder)((FlowWithPollingTriggerBuilder)((FlowWithPollingTriggerBuilder)this.toBuilder().flow(flow)).trigger(abstractTrigger)).pollingTrigger((PollingTriggerInterface)((Object)abstractTrigger))).build();
        }

        @Generated
        protected FlowWithPollingTrigger(FlowWithPollingTriggerBuilder<?, ?> b) {
            this.flow = b.flow;
            this.trigger = b.trigger;
            this.pollingTrigger = b.pollingTrigger;
            this.triggerContext = b.triggerContext;
            this.conditionContext = b.conditionContext;
        }

        @Generated
        public static FlowWithPollingTriggerBuilder<?, ?> builder() {
            return new FlowWithPollingTriggerBuilderImpl();
        }

        @Generated
        public FlowWithPollingTriggerBuilder<?, ?> toBuilder() {
            return new FlowWithPollingTriggerBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public Flow getFlow() {
            return this.flow;
        }

        @Generated
        public AbstractTrigger getTrigger() {
            return this.trigger;
        }

        @Generated
        public PollingTriggerInterface getPollingTrigger() {
            return this.pollingTrigger;
        }

        @Generated
        public TriggerContext getTriggerContext() {
            return this.triggerContext;
        }

        @Generated
        public ConditionContext getConditionContext() {
            return this.conditionContext;
        }

        @Generated
        public FlowWithPollingTrigger() {
        }

        @Generated
        public static abstract class FlowWithPollingTriggerBuilder<C extends FlowWithPollingTrigger, B extends FlowWithPollingTriggerBuilder<C, B>> {
            @Generated
            private Flow flow;
            @Generated
            private AbstractTrigger trigger;
            @Generated
            private PollingTriggerInterface pollingTrigger;
            @Generated
            private TriggerContext triggerContext;
            @Generated
            private ConditionContext conditionContext;

            @Generated
            protected B $fillValuesFrom(C instance) {
                FlowWithPollingTriggerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(FlowWithPollingTrigger instance, FlowWithPollingTriggerBuilder<?, ?> b) {
                b.flow(instance.flow);
                b.trigger(instance.trigger);
                b.pollingTrigger(instance.pollingTrigger);
                b.triggerContext(instance.triggerContext);
                b.conditionContext(instance.conditionContext);
            }

            @Generated
            public B flow(Flow flow) {
                this.flow = flow;
                return this.self();
            }

            @Generated
            public B trigger(AbstractTrigger trigger) {
                this.trigger = trigger;
                return this.self();
            }

            @Generated
            public B pollingTrigger(PollingTriggerInterface pollingTrigger) {
                this.pollingTrigger = pollingTrigger;
                return this.self();
            }

            @Generated
            public B triggerContext(TriggerContext triggerContext) {
                this.triggerContext = triggerContext;
                return this.self();
            }

            @Generated
            public B conditionContext(ConditionContext conditionContext) {
                this.conditionContext = conditionContext;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "AbstractScheduler.FlowWithPollingTrigger.FlowWithPollingTriggerBuilder(flow=" + this.flow + ", trigger=" + this.trigger + ", pollingTrigger=" + this.pollingTrigger + ", triggerContext=" + this.triggerContext + ", conditionContext=" + this.conditionContext + ")";
            }
        }

        @Generated
        private static final class FlowWithPollingTriggerBuilderImpl
        extends FlowWithPollingTriggerBuilder<FlowWithPollingTrigger, FlowWithPollingTriggerBuilderImpl> {
            @Generated
            private FlowWithPollingTriggerBuilderImpl() {
            }

            @Override
            @Generated
            protected FlowWithPollingTriggerBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public FlowWithPollingTrigger build() {
                return new FlowWithPollingTrigger(this);
            }
        }
    }

    public static class FlowWithPollingTriggerNextDate
    extends FlowWithPollingTrigger {
        private ZonedDateTime next;

        public static FlowWithPollingTriggerNextDate of(FlowWithPollingTrigger f, ZonedDateTime next) {
            return ((FlowWithPollingTriggerNextDateBuilder)((FlowWithPollingTriggerNextDateBuilder)((FlowWithPollingTriggerNextDateBuilder)((FlowWithPollingTriggerNextDateBuilder)((FlowWithPollingTriggerNextDateBuilder)((FlowWithPollingTriggerNextDateBuilder)FlowWithPollingTriggerNextDate.builder().flow(f.getFlow())).trigger(f.getTrigger())).pollingTrigger(f.getPollingTrigger())).conditionContext(f.getConditionContext())).triggerContext((TriggerContext)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)TriggerContext.builder().namespace(f.getTriggerContext().getNamespace())).flowId(f.getTriggerContext().getFlowId())).flowRevision(f.getTriggerContext().getFlowRevision())).triggerId(f.getTriggerContext().getTriggerId())).date(next)).build())).next(next)).build();
        }

        @Generated
        protected FlowWithPollingTriggerNextDate(FlowWithPollingTriggerNextDateBuilder<?, ?> b) {
            super(b);
            this.next = b.next;
        }

        @Generated
        public static FlowWithPollingTriggerNextDateBuilder<?, ?> builder() {
            return new FlowWithPollingTriggerNextDateBuilderImpl();
        }

        @Generated
        public ZonedDateTime getNext() {
            return this.next;
        }

        @Generated
        public FlowWithPollingTriggerNextDate() {
        }

        @Generated
        public static abstract class FlowWithPollingTriggerNextDateBuilder<C extends FlowWithPollingTriggerNextDate, B extends FlowWithPollingTriggerNextDateBuilder<C, B>>
        extends FlowWithPollingTrigger.FlowWithPollingTriggerBuilder<C, B> {
            @Generated
            private ZonedDateTime next;

            @Generated
            public B next(ZonedDateTime next) {
                this.next = next;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "AbstractScheduler.FlowWithPollingTriggerNextDate.FlowWithPollingTriggerNextDateBuilder(super=" + super.toString() + ", next=" + this.next + ")";
            }
        }

        @Generated
        private static final class FlowWithPollingTriggerNextDateBuilderImpl
        extends FlowWithPollingTriggerNextDateBuilder<FlowWithPollingTriggerNextDate, FlowWithPollingTriggerNextDateBuilderImpl> {
            @Generated
            private FlowWithPollingTriggerNextDateBuilderImpl() {
            }

            @Override
            @Generated
            protected FlowWithPollingTriggerNextDateBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public FlowWithPollingTriggerNextDate build() {
                return new FlowWithPollingTriggerNextDate(this);
            }
        }
    }

    public static class FlowWithTrigger {
        private final Flow flow;
        private final AbstractTrigger trigger;
        private final RunContext runContext;
        private final ConditionContext conditionContext;

        @ConstructorProperties(value={"flow", "trigger", "runContext", "conditionContext"})
        @Generated
        public FlowWithTrigger(Flow flow, AbstractTrigger trigger, RunContext runContext, ConditionContext conditionContext) {
            this.flow = flow;
            this.trigger = trigger;
            this.runContext = runContext;
            this.conditionContext = conditionContext;
        }

        @Generated
        public Flow getFlow() {
            return this.flow;
        }

        @Generated
        public AbstractTrigger getTrigger() {
            return this.trigger;
        }

        @Generated
        public RunContext getRunContext() {
            return this.runContext;
        }

        @Generated
        public ConditionContext getConditionContext() {
            return this.conditionContext;
        }
    }
}

