/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers.ion;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.Timestamp;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.IOContext;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;

public class IonParser
extends com.fasterxml.jackson.dataformat.ion.IonParser {
    public IonParser(IonReader r, IOContext ctxt) {
        super(r, ctxt);
    }

    protected JsonToken _tokenFromType(IonType type) {
        String[] typeAnnotations = this._reader.getTypeAnnotations();
        if (typeAnnotations.length > 0) {
            return JsonToken.VALUE_EMBEDDED_OBJECT;
        }
        return super._tokenFromType(type);
    }

    public Object getEmbeddedObject() throws IOException {
        if (this.getTypeId() != null) {
            if (this.getTypeId().equals(Instant.class.getSimpleName())) {
                return Instant.parse(this._reader.stringValue());
            }
            if (this.getTypeId().equals(OffsetDateTime.class.getSimpleName())) {
                return OffsetDateTime.parse(this._reader.stringValue());
            }
            if (this.getTypeId().equals(ZonedDateTime.class.getSimpleName())) {
                return ZonedDateTime.parse(this._reader.stringValue());
            }
            if (this.getTypeId().equals(LocalDateTime.class.getSimpleName())) {
                return LocalDateTime.parse(this._reader.stringValue());
            }
            if (this.getTypeId().equals(LocalDate.class.getSimpleName())) {
                return LocalDate.parse(this._reader.stringValue());
            }
            if (this.getTypeId().equals(OffsetTime.class.getSimpleName())) {
                return OffsetTime.parse(this._reader.stringValue());
            }
            if (this.getTypeId().equals(LocalTime.class.getSimpleName())) {
                return LocalTime.parse(this._reader.stringValue());
            }
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && this._reader.getType() == IonType.TIMESTAMP) {
            ZoneOffset zoneOffset;
            Timestamp timestamp = this._reader.timestampValue();
            Calendar calendar = timestamp.calendarValue();
            Instant instant = calendar.toInstant();
            ZoneOffset zoneOffset2 = zoneOffset = timestamp.getLocalOffset() == null ? null : ZoneOffset.ofTotalSeconds(timestamp.getLocalOffset() * 60);
            if (zoneOffset == null || zoneOffset.getId().equals("Z")) {
                if (instant.truncatedTo(ChronoUnit.DAYS) == instant) {
                    return LocalDate.ofInstant(instant, ZoneId.of("UTC"));
                }
                return instant;
            }
            return instant.atOffset(zoneOffset).toZonedDateTime();
        }
        return super.getEmbeddedObject();
    }
}

