/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import io.kestra.core.annotations.Retryable;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.utils.Slugify;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Introspected
public interface StorageInterface {
    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public InputStream get(URI var1) throws IOException;

    @Retryable(includes={IOException.class}, excludes={FileNotFoundException.class})
    public Long size(URI var1) throws IOException;

    @Retryable(includes={IOException.class})
    public URI put(URI var1, InputStream var2) throws IOException;

    @Retryable(includes={IOException.class})
    public boolean delete(URI var1) throws IOException;

    @Retryable(includes={IOException.class})
    public List<URI> deleteByPrefix(URI var1) throws IOException;

    default public String executionPrefix(Flow flow, Execution execution) {
        return String.join((CharSequence)"/", Arrays.asList(flow.getNamespace().replace(".", "/"), Slugify.of(flow.getId()), "executions", execution.getId()));
    }

    default public String executionPrefix(Execution execution) {
        return String.join((CharSequence)"/", Arrays.asList(execution.getNamespace().replace(".", "/"), Slugify.of(execution.getFlowId()), "executions", execution.getId()));
    }

    default public String executionPrefix(TaskRun taskRun) {
        return String.join((CharSequence)"/", Arrays.asList(taskRun.getNamespace().replace(".", "/"), Slugify.of(taskRun.getFlowId()), "executions", taskRun.getExecutionId()));
    }

    default public String statePrefix(String namespace, @Nullable String flowId, @Nullable String name, @Nullable String value) {
        String namespacePrefix = namespace.replace(".", "/");
        ArrayList<String> paths = new ArrayList<String>(flowId == null ? List.of(namespacePrefix, "states") : List.of(namespacePrefix, Slugify.of(flowId), "states"));
        if (name != null) {
            paths.add(name);
        }
        if (value != null) {
            paths.add(Hashing.goodFastHash((int)64).hashString((CharSequence)value, Charsets.UTF_8).toString());
        }
        return String.join((CharSequence)"/", paths);
    }

    default public Optional<String> extractExecutionId(URI path) {
        Pattern pattern = Pattern.compile("^/(.+)/executions/([^/]+)/", 2);
        Matcher matcher = pattern.matcher(path.getPath());
        if (!matcher.find() || matcher.group(2).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(matcher.group(2));
    }

    default public URI uri(Flow flow, Execution execution, String inputName, String file) throws URISyntaxException {
        return new URI("/" + String.join((CharSequence)"/", Arrays.asList(this.executionPrefix(flow, execution), "inputs", inputName, file)));
    }

    @Retryable(includes={IOException.class})
    default public URI from(Flow flow, Execution execution, String input, File file) throws IOException {
        try {
            return this.put(this.uri(flow, execution, input, file.getName()), new BufferedInputStream(new FileInputStream(file)));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Retryable(includes={IOException.class})
    default public URI from(Flow flow, Execution execution, Input<?> input, File file) throws IOException {
        return this.from(flow, execution, input.getName(), file);
    }

    default public URI outputPrefix(Flow flow) {
        try {
            return new URI("/" + String.join((CharSequence)"/", Arrays.asList(flow.getNamespace().replace(".", "/"), Slugify.of(flow.getId()))));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    default public URI outputPrefix(Flow flow, Task task, Execution execution, TaskRun taskRun) {
        try {
            return new URI("/" + String.join((CharSequence)"/", Arrays.asList(flow.getNamespace().replace(".", "/"), Slugify.of(flow.getId()), "executions", execution.getId(), "tasks", Slugify.of(taskRun.getTaskId()), taskRun.getId())));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    default public URI outputPrefix(TriggerContext triggerContext, AbstractTrigger trigger, String triggerExecutionId) {
        try {
            return new URI("/" + String.join((CharSequence)"/", Arrays.asList(triggerContext.getNamespace().replace(".", "/"), Slugify.of(triggerContext.getFlowId()), "executions", triggerExecutionId, "trigger", Slugify.of(trigger.getId()))));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

