/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.debugs;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Metric;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Debugging task that returns a rendered value.", description="This task is mostly useful for debugging purpose.\n\nIt allows you to see inputs or outputs variables or to debug some templated functions.")
@Plugin(examples={@Example(code={"format: \"{{task.id}} > {{taskrun.startDate}}\""})}, metrics={@Metric(name="length", type="counter"), @Metric(name="duration", type="timer")})
public class Return
extends Task
implements RunnableTask<Output> {
    @Schema(title="The templated string to render")
    @PluginProperty(dynamic=true)
    private String format;

    @Override
    public Output run(RunContext runContext) throws Exception {
        long start = System.nanoTime();
        Logger logger = runContext.logger();
        String render = runContext.render(this.format);
        logger.debug(render);
        long end = System.nanoTime();
        runContext.metric(Counter.of("length", render.length(), "format", this.format)).metric(Timer.of("duration", Duration.ofNanos(end - start), "format", this.format));
        return Output.builder().value(render).build();
    }

    @Generated
    protected Return(ReturnBuilder<?, ?> b) {
        super(b);
        this.format = b.format;
    }

    @Generated
    public static ReturnBuilder<?, ?> builder() {
        return new ReturnBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Return(super=" + super.toString() + ", format=" + this.getFormat() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Return)) {
            return false;
        }
        Return other = (Return)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !this$format.equals(other$format));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Return;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        return result;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public Return() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The generated string")
        private String value;

        @ConstructorProperties(value={"value"})
        @Generated
        Output(String value) {
            this.value = value;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String value;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder value(String value) {
                this.value = value;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.value);
            }

            @Generated
            public String toString() {
                return "Return.Output.OutputBuilder(value=" + this.value + ")";
            }
        }
    }

    @Generated
    public static abstract class ReturnBuilder<C extends Return, B extends ReturnBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String format;

        @Generated
        public B format(String format) {
            this.format = format;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Return.ReturnBuilder(super=" + super.toString() + ", format=" + this.format + ")";
        }
    }

    @Generated
    private static final class ReturnBuilderImpl
    extends ReturnBuilder<Return, ReturnBuilderImpl> {
        @Generated
        private ReturnBuilderImpl() {
        }

        @Override
        @Generated
        protected ReturnBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Return build() {
            return new Return(this);
        }
    }
}

