/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.scripts;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.scripts.AbstractBash;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPython
extends AbstractBash {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPython.class);
    @Schema(title="The python interpreter to use", description="Set the python interpreter path to use")
    @PluginProperty(dynamic=true)
    @NotNull
    @NotEmpty
    private final String pythonPath;
    @Schema(title="Python command args", description="Arguments list to pass to main python script")
    @PluginProperty(dynamic=true)
    private List<String> args;
    @Schema(title="Requirements are python dependencies to add to the python execution process", description="Python dependencies list to setup in the virtualenv, in the same format than requirements.txt")
    @PluginProperty(dynamic=true)
    protected List<String> requirements;

    protected String virtualEnvCommand(RunContext runContext, List<String> requirements) throws IllegalVariableEvaluationException {
        ArrayList<Object> renderer = new ArrayList<Object>();
        if (this.exitOnFailed.booleanValue()) {
            renderer.add("set -o errexit");
        }
        renderer.add(this.pythonPath + " -m venv --system-site-packages " + this.workingDirectory + " > /dev/null");
        if (requirements != null) {
            renderer.addAll(Arrays.asList("./bin/pip install pip --upgrade > /dev/null", "./bin/pip install " + runContext.render(String.join((CharSequence)" ", requirements), (Map<String, Object>)this.additionalVars) + " > /dev/null"));
        }
        return String.join((CharSequence)"\n", renderer);
    }

    @Override
    protected Map<String, String> finalEnv() throws IOException {
        Map<String, String> env = super.finalEnv();
        env.put("PYTHONUNBUFFERED", "true");
        return env;
    }

    @Generated
    private static String $default$pythonPath() {
        return "python";
    }

    @Generated
    protected AbstractPython(AbstractPythonBuilder<?, ?> b) {
        super((AbstractBash.AbstractBashBuilder<?, ?>)b);
        this.pythonPath = b.pythonPath$set ? b.pythonPath$value : AbstractPython.$default$pythonPath();
        this.args = b.args;
        this.requirements = b.requirements;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractPython(super=" + super.toString() + ", pythonPath=" + this.getPythonPath() + ", args=" + this.getArgs() + ", requirements=" + this.getRequirements() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPython)) {
            return false;
        }
        AbstractPython other = (AbstractPython)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pythonPath = this.getPythonPath();
        String other$pythonPath = other.getPythonPath();
        if (this$pythonPath == null ? other$pythonPath != null : !this$pythonPath.equals(other$pythonPath)) {
            return false;
        }
        List<String> this$args = this.getArgs();
        List<String> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        List<String> this$requirements = this.getRequirements();
        List<String> other$requirements = other.getRequirements();
        return !(this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractPython;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pythonPath = this.getPythonPath();
        result = result * 59 + ($pythonPath == null ? 43 : $pythonPath.hashCode());
        List<String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        List<String> $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        return result;
    }

    @Generated
    public String getPythonPath() {
        return this.pythonPath;
    }

    @Generated
    public List<String> getArgs() {
        return this.args;
    }

    @Generated
    public List<String> getRequirements() {
        return this.requirements;
    }

    @Generated
    public AbstractPython() {
        this.pythonPath = AbstractPython.$default$pythonPath();
    }

    @Generated
    public static abstract class AbstractPythonBuilder<C extends AbstractPython, B extends AbstractPythonBuilder<C, B>>
    extends AbstractBash.AbstractBashBuilder<C, B> {
        @Generated
        private boolean pythonPath$set;
        @Generated
        private String pythonPath$value;
        @Generated
        private List<String> args;
        @Generated
        private List<String> requirements;

        @Generated
        public B pythonPath(String pythonPath) {
            this.pythonPath$value = pythonPath;
            this.pythonPath$set = true;
            return (B)this.self();
        }

        @Generated
        public B args(List<String> args) {
            this.args = args;
            return (B)this.self();
        }

        @Generated
        public B requirements(List<String> requirements) {
            this.requirements = requirements;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AbstractPython.AbstractPythonBuilder(super=" + super.toString() + ", pythonPath$value=" + this.pythonPath$value + ", args=" + this.args + ", requirements=" + this.requirements + ")";
        }
    }
}

