/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.scripts;

import com.google.common.base.Charsets;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.scripts.AbstractBash;
import io.kestra.core.tasks.scripts.ScriptOutput;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.io.IOUtils;

@Schema(title="Execute a Node.js script", description="With the Node task, you can execute a full javascript script.\nThe task will create a temporary folder for each tasks and allows to install some npm packages defined in an optional `package.json` file.\n\nBy convention, you need to define at least a `main.js` files in `inputFiles` that will be the script used.\nYou can also  add as many javascript files as you need in `inputFiles`.\n\nYou can send outputs & metrics from your node script that can be used by others tasks. In order to help, we inject a node package directly on the working dir.Here is an example usage:\n```javascript\nconst Kestra = require(\"./kestra\");\nKestra.outputs({test: 'value', int: 2, bool: true, float: 3.65});\nKestra.counter('count', 1, {tag1: 'i', tag2: 'win'});\nKestra.timer('timer1', (callback) => { setTimeout(callback, 1000) }, {tag1: 'i', tag2: 'lost'});\nKestra.timer('timer2', 2.12, {tag1: 'i', tag2: 'destroy'});\n```")
@Plugin(examples={@Example(title="Execute a node script", code={"inputFiles:", "  main.js: |", "    const Kestra = require(\"./kestra\");", "    const fs = require('fs')", "    const result = fs.readFileSync(process.argv[2], \"utf-8\")", "    console.log(JSON.parse(result).status)", "    const axios = require('axios')", "    axios.get('http://google.fr').then(d => { console.log(d.status); Kestra.outputs({'status': d.status, 'text': d.data})})", "    console.log(require('./mymodule').value)", "  data.json: |", "    {\"status\": \"OK\"}", "  mymodule.js: |", "    module.exports.value = 'hello world'", "  package.json: |", "    {", "      \"name\": \"tmp\",", "      \"version\": \"1.0.0\",", "      \"description\": \"\",", "      \"main\": \"index.js\",", "      \"dependencies\": {", "          \"axios\": \"^0.20.0\"", "      },", "      \"devDependencies\": {},", "      \"scripts\": {", "          \"test\": \"echo `Error: no test specified` && exit 1\"", "      },", "      \"author\": \"\",", "      \"license\": \"ISC\"", "    }", "args:", "  - data.json"}), @Example(title="Execute a node script with an input file from Kestra's local storage created by a previous task.", code={"inputFiles:", "  data.csv: {{outputs.previousTaskId.uri}}", "  main.js: |", "    const fs = require('fs')", "    const result = fs.readFileSync('data.csv', 'utf-8')", "    console.log(result)"})})
public class Node
extends AbstractBash
implements RunnableTask<ScriptOutput> {
    @Schema(title="The node interpreter to use", description="Set the node interpreter path to use")
    @PluginProperty
    private final String nodePath;
    @Schema(title="The npm binary to use", description="Set the npm binary path for node dependencies setup")
    @PluginProperty
    private final String npmPath;
    @Schema(title="node command args", description="Arguments list to pass to main javascript script")
    @PluginProperty(dynamic=true)
    private List<String> args;

    @Override
    protected Map<String, String> finalInputFiles(RunContext runContext) throws IOException, IllegalVariableEvaluationException {
        Map<String, String> map = super.finalInputFiles(runContext);
        map.put("kestra.js", IOUtils.toString((InputStream)Objects.requireNonNull(Node.class.getClassLoader().getResourceAsStream("scripts/kestra.js")), (Charset)Charsets.UTF_8));
        return map;
    }

    @Override
    public ScriptOutput run(RunContext runContext) throws Exception {
        Map<String, String> finalInputFiles = this.finalInputFiles(runContext);
        if (!finalInputFiles.containsKey("main.js")) {
            throw new Exception("Invalid input files structure, expecting inputFiles property to contain at least a main.js key with javascript code value.");
        }
        return this.run(runContext, Rethrow.throwSupplier(() -> {
            ArrayList<String> renderer = new ArrayList<String>();
            if (this.exitOnFailed.booleanValue()) {
                renderer.add("set -o errexit");
            }
            String args = this.getArgs() == null ? "" : " " + runContext.render(String.join((CharSequence)" ", this.getArgs()));
            String npmInstall = finalInputFiles.containsKey("package.json") ? this.npmPath + " i > /dev/null" : "";
            renderer.addAll(Arrays.asList("PATH=\"$PATH:" + new File(this.nodePath).getParent() + "\"", npmInstall, this.nodePath + " main.js" + args));
            return String.join((CharSequence)"\n", renderer);
        }));
    }

    @Generated
    private static String $default$nodePath() {
        return "node";
    }

    @Generated
    private static String $default$npmPath() {
        return "npm";
    }

    @Generated
    protected Node(NodeBuilder<?, ?> b) {
        super((AbstractBash.AbstractBashBuilder<?, ?>)b);
        this.nodePath = b.nodePath$set ? b.nodePath$value : Node.$default$nodePath();
        this.npmPath = b.npmPath$set ? b.npmPath$value : Node.$default$npmPath();
        this.args = b.args;
    }

    @Generated
    public static NodeBuilder<?, ?> builder() {
        return new NodeBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Node(super=" + super.toString() + ", nodePath=" + this.getNodePath() + ", npmPath=" + this.getNpmPath() + ", args=" + this.getArgs() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$nodePath = this.getNodePath();
        String other$nodePath = other.getNodePath();
        if (this$nodePath == null ? other$nodePath != null : !this$nodePath.equals(other$nodePath)) {
            return false;
        }
        String this$npmPath = this.getNpmPath();
        String other$npmPath = other.getNpmPath();
        if (this$npmPath == null ? other$npmPath != null : !this$npmPath.equals(other$npmPath)) {
            return false;
        }
        List<String> this$args = this.getArgs();
        List<String> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Node;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $nodePath = this.getNodePath();
        result = result * 59 + ($nodePath == null ? 43 : $nodePath.hashCode());
        String $npmPath = this.getNpmPath();
        result = result * 59 + ($npmPath == null ? 43 : $npmPath.hashCode());
        List<String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    @Generated
    public String getNodePath() {
        return this.nodePath;
    }

    @Generated
    public String getNpmPath() {
        return this.npmPath;
    }

    @Generated
    public List<String> getArgs() {
        return this.args;
    }

    @Generated
    public Node() {
        this.nodePath = Node.$default$nodePath();
        this.npmPath = Node.$default$npmPath();
    }

    @Generated
    public static abstract class NodeBuilder<C extends Node, B extends NodeBuilder<C, B>>
    extends AbstractBash.AbstractBashBuilder<C, B> {
        @Generated
        private boolean nodePath$set;
        @Generated
        private String nodePath$value;
        @Generated
        private boolean npmPath$set;
        @Generated
        private String npmPath$value;
        @Generated
        private List<String> args;

        @Generated
        public B nodePath(String nodePath) {
            this.nodePath$value = nodePath;
            this.nodePath$set = true;
            return (B)this.self();
        }

        @Generated
        public B npmPath(String npmPath) {
            this.npmPath$value = npmPath;
            this.npmPath$set = true;
            return (B)this.self();
        }

        @Generated
        public B args(List<String> args) {
            this.args = args;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Node.NodeBuilder(super=" + super.toString() + ", nodePath$value=" + this.nodePath$value + ", npmPath$value=" + this.npmPath$value + ", args=" + this.args + ")";
        }
    }

    @Generated
    private static final class NodeBuilderImpl
    extends NodeBuilder<Node, NodeBuilderImpl> {
        @Generated
        private NodeBuilderImpl() {
        }

        @Override
        @Generated
        protected NodeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Node build() {
            return new Node(this);
        }
    }
}

