/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.scripts;

import com.google.common.base.Charsets;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.scripts.AbstractPython;
import io.kestra.core.tasks.scripts.ScriptOutput;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="Execute a Python script", description="With the Python task, you can execute a full Python script.\nThe task will create a fresh `virtualenv` for every tasks and allows to install some Python package define in `requirements` property.\n\nBy convention, you need to define at least a `main.py` files in `inputFiles` that will be the script used.\nBut you are also able to add as many script as you need in `inputFiles`.\n\nYou can also add a `pip.conf` in `inputFiles` to customize the pip download of dependencies (like a private registry).\n\nYou can send outputs & metrics from your python script that can be used by others tasks. In order to help, we inject a python package directly on the working dir.Here is an example usage:\n```python\nfrom kestra import Kestra\nKestra.outputs({'test': 'value', 'int': 2, 'bool': True, 'float': 3.65})\nKestra.counter('count', 1, {'tag1': 'i', 'tag2': 'win'})\nKestra.timer('timer1', lambda: time.sleep(1), {'tag1': 'i', 'tag2': 'lost'})\nKestra.timer('timer2', 2.12, {'tag1': 'i', 'tag2': 'destroy'})\n```")
@Plugin(examples={@Example(title="Execute a python script", code={"inputFiles:", "  data.json: |", "          {\"status\": \"OK\"}", "  main.py: |", "    from kestra import Kestra", "    import json", "    import requests", "    import sys", "    result = json.loads(open(sys.argv[1]).read())", "    print(f\"python script {result['status']}\")", "    response = requests.get('http://google.com')", "    print(response.status_code)", "    Kestra.outputs({'status': response.status_code, 'text': response.text})", "  pip.conf: |", "    # some specific pip repository configuration", "args:", "  - data.json", "requirements:", "  - requests"}), @Example(title="Execute a python script with an input file from Kestra's local storage created by a previous task.", code={"inputFiles:", "  data.csv: {{outputs.previousTaskId.uri}}", "  main.py: |", "    with open('data.csv', 'r') as f:", "      print(f.read())"})})
public class Python
extends AbstractPython
implements RunnableTask<ScriptOutput> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Python.class);
    @Schema(title="The commands to run", description="Default command will be launched with `./bin/python main.py {{args}}`")
    @PluginProperty(dynamic=true)
    @NotNull
    @NotEmpty
    protected List<String> commands;
    @Schema(title="Python command args", description="Arguments list to pass to main python script")
    @PluginProperty(dynamic=true)
    private List<String> args;
    @Schema(title="Create a virtual env", description="When a virtual env is created, we will install the `requirements` needed. Disabled it if all the requirements is already on the file system.\nIf you disabled the virtual env creation, the `requirements` will be ignored.")
    @PluginProperty
    protected Boolean virtualEnv;

    @Override
    protected Map<String, String> finalInputFiles(RunContext runContext) throws IOException, IllegalVariableEvaluationException {
        Map<String, String> map = super.finalInputFiles(runContext);
        map.put("kestra.py", IOUtils.toString((InputStream)Objects.requireNonNull(AbstractPython.class.getClassLoader().getResourceAsStream("scripts/python/src/kestra.py")), (Charset)Charsets.UTF_8));
        return map;
    }

    @Override
    public ScriptOutput run(RunContext runContext) throws Exception {
        Map<String, String> finalInputFiles = this.finalInputFiles(runContext);
        if (!finalInputFiles.containsKey("main.py") && this.commands.size() == 1 && this.commands.get(0).equals("./bin/python main.py")) {
            throw new Exception("Invalid input files structure, expecting inputFiles property to contain at least a main.py key with python code value.");
        }
        return this.run(runContext, Rethrow.throwSupplier(() -> {
            ArrayList<Object> renderer = new ArrayList<Object>();
            if (this.virtualEnv.booleanValue()) {
                renderer.add(this.virtualEnvCommand(runContext, this.requirements));
            } else if (this.exitOnFailed.booleanValue()) {
                renderer.add("set -o errexit");
            }
            for (String command : this.commands) {
                String argsString = this.args == null ? "" : " " + runContext.render(String.join((CharSequence)" ", this.args), (Map<String, Object>)this.additionalVars);
                renderer.add(runContext.render(command, (Map<String, Object>)this.additionalVars) + argsString);
            }
            return String.join((CharSequence)"\n", renderer);
        }));
    }

    @Generated
    private static List<String> $default$commands() {
        return Collections.singletonList("./bin/python main.py");
    }

    @Generated
    private static Boolean $default$virtualEnv() {
        return true;
    }

    @Generated
    protected Python(PythonBuilder<?, ?> b) {
        super((AbstractPython.AbstractPythonBuilder<?, ?>)b);
        this.commands = b.commands$set ? b.commands$value : Python.$default$commands();
        this.args = b.args;
        this.virtualEnv = b.virtualEnv$set ? b.virtualEnv$value : Python.$default$virtualEnv();
    }

    @Generated
    public static PythonBuilder<?, ?> builder() {
        return new PythonBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Python(super=" + super.toString() + ", commands=" + this.getCommands() + ", args=" + this.getArgs() + ", virtualEnv=" + this.getVirtualEnv() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Python)) {
            return false;
        }
        Python other = (Python)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$virtualEnv = this.getVirtualEnv();
        Boolean other$virtualEnv = other.getVirtualEnv();
        if (this$virtualEnv == null ? other$virtualEnv != null : !((Object)this$virtualEnv).equals(other$virtualEnv)) {
            return false;
        }
        List<String> this$commands = this.getCommands();
        List<String> other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        List<String> this$args = this.getArgs();
        List<String> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Python;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $virtualEnv = this.getVirtualEnv();
        result = result * 59 + ($virtualEnv == null ? 43 : ((Object)$virtualEnv).hashCode());
        List<String> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        List<String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    @Generated
    public List<String> getCommands() {
        return this.commands;
    }

    @Override
    @Generated
    public List<String> getArgs() {
        return this.args;
    }

    @Generated
    public Boolean getVirtualEnv() {
        return this.virtualEnv;
    }

    @Generated
    public Python() {
        this.commands = Python.$default$commands();
        this.virtualEnv = Python.$default$virtualEnv();
    }

    @Generated
    public static abstract class PythonBuilder<C extends Python, B extends PythonBuilder<C, B>>
    extends AbstractPython.AbstractPythonBuilder<C, B> {
        @Generated
        private boolean commands$set;
        @Generated
        private List<String> commands$value;
        @Generated
        private List<String> args;
        @Generated
        private boolean virtualEnv$set;
        @Generated
        private Boolean virtualEnv$value;

        @Generated
        public B commands(List<String> commands) {
            this.commands$value = commands;
            this.commands$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public B args(List<String> args) {
            this.args = args;
            return (B)this.self();
        }

        @Generated
        public B virtualEnv(Boolean virtualEnv) {
            this.virtualEnv$value = virtualEnv;
            this.virtualEnv$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Python.PythonBuilder(super=" + super.toString() + ", commands$value=" + this.commands$value + ", args=" + this.args + ", virtualEnv$value=" + this.virtualEnv$value + ")";
        }
    }

    @Generated
    private static final class PythonBuilderImpl
    extends PythonBuilder<Python, PythonBuilderImpl> {
        @Generated
        private PythonBuilderImpl() {
        }

        @Override
        @Generated
        protected PythonBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Python build() {
            return new Python(this);
        }
    }
}

